/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.hadoop.hdfs.web.resources.Param;

abstract class EnumSetParam<E extends Enum<E>>
extends Param<EnumSet<E>, Domain<E>> {
    static <E extends Enum<E>> String toString(EnumSet<E> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        Iterator i = set.iterator();
        b.append(i.next());
        while (i.hasNext()) {
            b.append(',').append(i.next());
        }
        return b.toString();
    }

    static <E extends Enum<E>> EnumSet<E> toEnumSet(Class<E> clazz, E ... values) {
        EnumSet<E> set = EnumSet.noneOf(clazz);
        set.addAll(Arrays.asList(values));
        return set;
    }

    EnumSetParam(Domain<E> domain, EnumSet<E> value) {
        super(domain, value);
    }

    @Override
    public String toString() {
        return this.getName() + "=" + EnumSetParam.toString((EnumSet)this.value);
    }

    @Override
    public String getValueString() {
        return EnumSetParam.toString((EnumSet)this.value);
    }

    static final class Domain<E extends Enum<E>>
    extends Param.Domain<EnumSet<E>> {
        private final Class<E> enumClass;

        Domain(String name, Class<E> enumClass) {
            super(name);
            this.enumClass = enumClass;
        }

        @Override
        public final String getDomain() {
            return Arrays.asList(this.enumClass.getEnumConstants()).toString();
        }

        @Override
        final EnumSet<E> parse(String str) {
            EnumSet<E> set = EnumSet.noneOf(this.enumClass);
            if (!str.isEmpty()) {
                int j = 0;
                while (j >= 0) {
                    int i = j;
                    String sub = (j = str.indexOf(44, i + 1)) >= 0 ? str.substring(i, j) : str.substring(i);
                    set.add(Enum.valueOf(this.enumClass, sub.trim().toUpperCase()));
                }
            }
            return set;
        }
    }
}

