/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.function.Supplier;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Preconditions;
import org.junit.Test;

public class TestPreconditions {
    private static final String NON_NULL_STRING = "NON_NULL_OBJECT";
    private static final String NON_INT_STRING = "NOT_INT";
    private static final String EXPECTED_ERROR_MSG = "Expected-Error-MSG";
    private static final String EXPECTED_ERROR_MSG_ARGS = "Expected-Error-MSG %s number %d";
    private static final String NULL_FORMATTER = null;
    private String errorMessage;

    @Test
    public void testCheckNotNullSuccess() {
        Preconditions.checkNotNull((Object)NON_NULL_STRING);
        Preconditions.checkNotNull((Object)NON_NULL_STRING, null);
        Preconditions.checkNotNull((Object)NON_NULL_STRING, () -> String.format("%d", NON_INT_STRING));
        Preconditions.checkNotNull((Object)NON_NULL_STRING, (String)NULL_FORMATTER, (Object[])new Object[]{null, 1});
        Preconditions.checkNotNull((Object)NON_NULL_STRING, (String)EXPECTED_ERROR_MSG_ARGS, (Object[])new Object[]{null, null});
        Preconditions.checkNotNull((Object)NON_NULL_STRING, (String)"message %d %d", (Object[])new Object[]{NON_INT_STRING, 1});
        Preconditions.checkNotNull((Object)NON_NULL_STRING, (String)EXPECTED_ERROR_MSG_ARGS, (Object[])new Object[]{NON_INT_STRING});
        Preconditions.checkNotNull((Object)NON_NULL_STRING, () -> String.format(NULL_FORMATTER, NON_INT_STRING));
    }

    @Test
    public void testCheckNotNullFailure() throws Exception {
        LambdaTestUtils.intercept(NullPointerException.class, Preconditions.getDefaultNullMSG(), () -> Preconditions.checkNotNull(null));
        this.errorMessage = EXPECTED_ERROR_MSG;
        LambdaTestUtils.intercept(NullPointerException.class, this.errorMessage, () -> Preconditions.checkNotNull(null, (Object)this.errorMessage));
        LambdaTestUtils.intercept(NullPointerException.class, null, () -> Preconditions.checkNotNull(null, (Object)this.errorMessage));
        this.errorMessage = "Expected-Error-MSG %s";
        String arg = "NPE";
        String expectedMSG = String.format(this.errorMessage, arg);
        LambdaTestUtils.intercept(NullPointerException.class, expectedMSG, () -> Preconditions.checkNotNull(null, (String)this.errorMessage, (Object[])new Object[]{arg}));
        this.errorMessage = EXPECTED_ERROR_MSG_ARGS;
        expectedMSG = String.format(this.errorMessage, arg, 1);
        LambdaTestUtils.intercept(NullPointerException.class, expectedMSG, () -> Preconditions.checkNotNull(null, (String)this.errorMessage, (Object[])new Object[]{arg, 1}));
        LambdaTestUtils.intercept(NullPointerException.class, Preconditions.getDefaultNullMSG(), () -> Preconditions.checkNotNull(null, (String)this.errorMessage, (Object[])new Object[]{1, NON_INT_STRING}));
        LambdaTestUtils.intercept(NullPointerException.class, Preconditions.getDefaultNullMSG(), () -> Preconditions.checkNotNull(null, (String)this.errorMessage, (Object[])new Object[]{NON_NULL_STRING}));
        LambdaTestUtils.intercept(NullPointerException.class, Preconditions.getDefaultNullMSG(), () -> Preconditions.checkNotNull(null, () -> String.format(this.errorMessage, 1, NON_INT_STRING)));
        LambdaTestUtils.intercept(NullPointerException.class, Preconditions.getDefaultNullMSG(), () -> Preconditions.checkNotNull(null, () -> String.format(this.errorMessage, NON_NULL_STRING)));
        LambdaTestUtils.intercept(NullPointerException.class, Preconditions.getDefaultNullMSG(), () -> Preconditions.checkNotNull(null, () -> String.format(NULL_FORMATTER, NON_NULL_STRING)));
    }

    @Test
    public void testCheckArgumentWithSuccess() throws Exception {
        Preconditions.checkArgument((boolean)true);
        Preconditions.checkArgument((boolean)true, null);
        Preconditions.checkArgument((boolean)true, (Object)null);
        Preconditions.checkArgument((boolean)true, (Object)NON_NULL_STRING);
        Preconditions.checkArgument((boolean)true, (String)EXPECTED_ERROR_MSG_ARGS, (Object[])new Object[]{null, null});
        Preconditions.checkArgument((boolean)true, (String)EXPECTED_ERROR_MSG_ARGS, (Object[])new Object[]{1, 2});
        Preconditions.checkArgument((boolean)true, () -> String.format("%d", NON_INT_STRING));
        Preconditions.checkArgument((boolean)true, (String)NULL_FORMATTER, (Object[])new Object[]{null, 1});
        Preconditions.checkArgument((boolean)true, (String)EXPECTED_ERROR_MSG_ARGS, (Object[])new Object[]{null, null});
        Preconditions.checkArgument((boolean)true, (String)"message %d %d", (Object[])new Object[]{NON_INT_STRING, 1});
        Preconditions.checkArgument((boolean)true, (String)EXPECTED_ERROR_MSG_ARGS, (Object[])new Object[]{NON_INT_STRING});
        Preconditions.checkArgument((boolean)true, () -> String.format(NULL_FORMATTER, NON_INT_STRING));
    }

    @Test
    public void testCheckArgumentWithFailure() throws Exception {
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> Preconditions.checkArgument((boolean)false));
        this.errorMessage = null;
        LambdaTestUtils.intercept(IllegalArgumentException.class, null, () -> Preconditions.checkArgument((boolean)false, (Object)this.errorMessage));
        this.errorMessage = EXPECTED_ERROR_MSG;
        LambdaTestUtils.intercept(IllegalArgumentException.class, this.errorMessage, () -> Preconditions.checkArgument((boolean)false, (Object)this.errorMessage));
        this.errorMessage = "Expected-Error-MSG %s";
        String arg = "IllegalArgExcep";
        String expectedMSG = String.format(this.errorMessage, arg);
        LambdaTestUtils.intercept(IllegalArgumentException.class, expectedMSG, () -> Preconditions.checkArgument((boolean)false, (String)this.errorMessage, (Object[])new Object[]{arg}));
        this.errorMessage = EXPECTED_ERROR_MSG_ARGS;
        expectedMSG = String.format(this.errorMessage, arg, 1);
        LambdaTestUtils.intercept(IllegalArgumentException.class, expectedMSG, () -> Preconditions.checkArgument((boolean)false, (String)this.errorMessage, (Object[])new Object[]{arg, 1}));
        LambdaTestUtils.intercept(IllegalArgumentException.class, Preconditions.getDefaultCheckArgumentMSG(), () -> Preconditions.checkArgument((boolean)false, (String)this.errorMessage, (Object[])new Object[]{1, NON_INT_STRING}));
        LambdaTestUtils.intercept(IllegalArgumentException.class, Preconditions.getDefaultCheckArgumentMSG(), () -> Preconditions.checkArgument((boolean)false, (String)this.errorMessage, (Object[])new Object[]{NON_NULL_STRING}));
        Supplier nullSupplier = null;
        LambdaTestUtils.intercept(IllegalArgumentException.class, null, () -> Preconditions.checkArgument((boolean)false, (Supplier)nullSupplier));
        LambdaTestUtils.intercept(IllegalArgumentException.class, Preconditions.getDefaultCheckArgumentMSG(), () -> Preconditions.checkArgument((boolean)false, () -> String.format(this.errorMessage, 1, NON_INT_STRING)));
        LambdaTestUtils.intercept(IllegalArgumentException.class, Preconditions.getDefaultCheckArgumentMSG(), () -> Preconditions.checkArgument((boolean)false, () -> String.format(this.errorMessage, NON_NULL_STRING)));
        LambdaTestUtils.intercept(IllegalArgumentException.class, Preconditions.getDefaultCheckArgumentMSG(), () -> Preconditions.checkArgument((boolean)false, () -> String.format(NULL_FORMATTER, NON_NULL_STRING)));
    }

    @Test
    public void testCheckStateWithSuccess() throws Exception {
        Preconditions.checkState((boolean)true);
        Preconditions.checkState((boolean)true, null);
        Preconditions.checkState((boolean)true, (Object)null);
        Preconditions.checkState((boolean)true, (Object)NON_NULL_STRING);
        Preconditions.checkState((boolean)true, (String)EXPECTED_ERROR_MSG_ARGS, (Object[])new Object[]{null, null});
        Preconditions.checkState((boolean)true, (String)EXPECTED_ERROR_MSG_ARGS, (Object[])new Object[]{1, 2});
        Preconditions.checkState((boolean)true, () -> String.format("%d", NON_INT_STRING));
        Preconditions.checkState((boolean)true, (String)NULL_FORMATTER, (Object[])new Object[]{null, 1});
        Preconditions.checkState((boolean)true, (String)EXPECTED_ERROR_MSG_ARGS, (Object[])new Object[]{null, null});
        Preconditions.checkState((boolean)true, (String)"message %d %d", (Object[])new Object[]{NON_INT_STRING, 1});
        Preconditions.checkState((boolean)true, (String)EXPECTED_ERROR_MSG_ARGS, (Object[])new Object[]{NON_INT_STRING});
        Preconditions.checkState((boolean)true, () -> String.format(NULL_FORMATTER, NON_INT_STRING));
    }

    @Test
    public void testCheckStateWithFailure() throws Exception {
        LambdaTestUtils.intercept(IllegalStateException.class, () -> Preconditions.checkState((boolean)false));
        this.errorMessage = null;
        LambdaTestUtils.intercept(IllegalStateException.class, null, () -> Preconditions.checkState((boolean)false, (Object)this.errorMessage));
        this.errorMessage = EXPECTED_ERROR_MSG;
        LambdaTestUtils.intercept(IllegalStateException.class, this.errorMessage, () -> Preconditions.checkState((boolean)false, (Object)this.errorMessage));
        this.errorMessage = "Expected-Error-MSG %s";
        String arg = "IllegalStaExcep";
        String expectedMSG = String.format(this.errorMessage, arg);
        LambdaTestUtils.intercept(IllegalStateException.class, expectedMSG, () -> Preconditions.checkState((boolean)false, (String)this.errorMessage, (Object[])new Object[]{arg}));
        this.errorMessage = EXPECTED_ERROR_MSG_ARGS;
        expectedMSG = String.format(this.errorMessage, arg, 1);
        LambdaTestUtils.intercept(IllegalStateException.class, expectedMSG, () -> Preconditions.checkState((boolean)false, (String)this.errorMessage, (Object[])new Object[]{arg, 1}));
        LambdaTestUtils.intercept(IllegalStateException.class, Preconditions.getDefaultCheckStateMSG(), () -> Preconditions.checkState((boolean)false, (String)this.errorMessage, (Object[])new Object[]{1, NON_INT_STRING}));
        LambdaTestUtils.intercept(IllegalStateException.class, Preconditions.getDefaultCheckStateMSG(), () -> Preconditions.checkState((boolean)false, (String)this.errorMessage, (Object[])new Object[]{NON_NULL_STRING}));
        Supplier nullSupplier = null;
        LambdaTestUtils.intercept(IllegalStateException.class, null, () -> Preconditions.checkState((boolean)false, (Supplier)nullSupplier));
        LambdaTestUtils.intercept(IllegalStateException.class, Preconditions.getDefaultCheckStateMSG(), () -> Preconditions.checkState((boolean)false, () -> String.format(this.errorMessage, 1, NON_INT_STRING)));
        LambdaTestUtils.intercept(IllegalStateException.class, Preconditions.getDefaultCheckStateMSG(), () -> Preconditions.checkState((boolean)false, () -> String.format(this.errorMessage, NON_NULL_STRING)));
        LambdaTestUtils.intercept(IllegalStateException.class, Preconditions.getDefaultCheckStateMSG(), () -> Preconditions.checkState((boolean)false, () -> String.format(NULL_FORMATTER, NON_NULL_STRING)));
    }
}

