/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.bzip2;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.bzip2.Bzip2Compressor;
import org.apache.hadoop.io.compress.bzip2.Bzip2Decompressor;
import org.apache.hadoop.io.compress.bzip2.Bzip2Factory;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestBzip2CompressorDecompressor {
    private static final Random rnd = new Random(12345L);

    @Before
    public void before() {
        Assume.assumeTrue((boolean)Bzip2Factory.isNativeBzip2Loaded((Configuration)new Configuration()));
    }

    @Test
    public void testCompressDecompress() {
        byte[] rawData = null;
        int rawDataSize = 0;
        rawDataSize = 65536;
        rawData = TestBzip2CompressorDecompressor.generate(rawDataSize);
        try {
            Bzip2Compressor compressor = new Bzip2Compressor();
            Bzip2Decompressor decompressor = new Bzip2Decompressor();
            Assert.assertFalse((String)"testBzip2CompressDecompress finished error", (boolean)compressor.finished());
            compressor.setInput(rawData, 0, rawData.length);
            Assert.assertTrue((String)"testBzip2CompressDecompress getBytesRead before error", (compressor.getBytesRead() == 0L ? 1 : 0) != 0);
            compressor.finish();
            byte[] compressedResult = new byte[rawDataSize];
            int cSize = compressor.compress(compressedResult, 0, rawDataSize);
            Assert.assertTrue((String)"testBzip2CompressDecompress getBytesRead after error", (compressor.getBytesRead() == (long)rawDataSize ? 1 : 0) != 0);
            Assert.assertTrue((String)"testBzip2CompressDecompress compressed size no less than original size", (cSize < rawDataSize ? 1 : 0) != 0);
            decompressor.setInput(compressedResult, 0, cSize);
            byte[] decompressedBytes = new byte[rawDataSize];
            decompressor.decompress(decompressedBytes, 0, decompressedBytes.length);
            Assert.assertArrayEquals((String)"testBzip2CompressDecompress arrays not equals ", (byte[])rawData, (byte[])decompressedBytes);
            compressor.reset();
            decompressor.reset();
        }
        catch (IOException ex) {
            Assert.fail((String)("testBzip2CompressDecompress ex !!!" + ex));
        }
    }

    public static byte[] generate(int size) {
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (byte)rnd.nextInt(16);
        }
        return array;
    }

    @Test
    public void testBzip2CompressDecompressInMultiThreads() throws Exception {
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        for (int i = 0; i < 10; ++i) {
            ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

                @Override
                public void doWork() throws Exception {
                    TestBzip2CompressorDecompressor.this.testCompressDecompress();
                }
            });
        }
        ctx.startThreads();
        ctx.waitFor(60000L);
    }
}

