/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.util.FileBasedIPList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestFileBasedIPList {
    @After
    public void tearDown() {
        TestFileBasedIPList.removeFile("ips.txt");
    }

    @Test
    public void testSubnetsAndIPs() throws IOException {
        String[] ips = new String[]{"10.119.103.112", "10.221.102.0/23"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips);
        FileBasedIPList ipList = new FileBasedIPList("ips.txt");
        Assert.assertTrue((String)"10.119.103.112 is not in the list", (boolean)ipList.isIn("10.119.103.112"));
        Assert.assertFalse((String)"10.119.103.113 is in the list", (boolean)ipList.isIn("10.119.103.113"));
        Assert.assertTrue((String)"10.221.102.0 is not in the list", (boolean)ipList.isIn("10.221.102.0"));
        Assert.assertTrue((String)"10.221.102.1 is not in the list", (boolean)ipList.isIn("10.221.102.1"));
        Assert.assertTrue((String)"10.221.103.1 is not in the list", (boolean)ipList.isIn("10.221.103.1"));
        Assert.assertTrue((String)"10.221.103.255 is not in the list", (boolean)ipList.isIn("10.221.103.255"));
        Assert.assertFalse((String)"10.221.104.0 is in the list", (boolean)ipList.isIn("10.221.104.0"));
        Assert.assertFalse((String)"10.221.104.1 is in the list", (boolean)ipList.isIn("10.221.104.1"));
    }

    @Test
    public void testNullIP() throws IOException {
        String[] ips = new String[]{"10.119.103.112", "10.221.102.0/23"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips);
        FileBasedIPList ipList = new FileBasedIPList("ips.txt");
        Assert.assertFalse((String)"Null Ip is in the list", (boolean)ipList.isIn(null));
    }

    @Test
    public void testWithMultipleSubnetAndIPs() throws IOException {
        String[] ips = new String[]{"10.119.103.112", "10.221.102.0/23", "10.222.0.0/16", "10.113.221.221"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips);
        FileBasedIPList ipList = new FileBasedIPList("ips.txt");
        Assert.assertTrue((String)"10.119.103.112 is not in the list", (boolean)ipList.isIn("10.119.103.112"));
        Assert.assertFalse((String)"10.119.103.113 is in the list", (boolean)ipList.isIn("10.119.103.113"));
        Assert.assertTrue((String)"10.221.103.121 is not in the list", (boolean)ipList.isIn("10.221.103.121"));
        Assert.assertFalse((String)"10.221.104.0 is in the list", (boolean)ipList.isIn("10.221.104.0"));
        Assert.assertTrue((String)"10.222.103.121 is not in the list", (boolean)ipList.isIn("10.222.103.121"));
        Assert.assertFalse((String)"10.223.104.0 is in the list", (boolean)ipList.isIn("10.223.104.0"));
        Assert.assertTrue((String)"10.113.221.221 is not in the list", (boolean)ipList.isIn("10.113.221.221"));
        Assert.assertFalse((String)"10.113.221.222 is in the list", (boolean)ipList.isIn("10.113.221.222"));
    }

    @Test
    public void testFileNotSpecified() {
        FileBasedIPList ipl = new FileBasedIPList(null);
        Assert.assertFalse((String)"110.113.221.222 is in the list", (boolean)ipl.isIn("110.113.221.222"));
    }

    @Test
    public void testFileMissing() {
        FileBasedIPList ipl = new FileBasedIPList("missingips.txt");
        Assert.assertFalse((String)"110.113.221.222 is in the list", (boolean)ipl.isIn("110.113.221.222"));
    }

    @Test
    public void testWithEmptyList() throws IOException {
        String[] ips = new String[]{};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips);
        FileBasedIPList ipl = new FileBasedIPList("ips.txt");
        Assert.assertFalse((String)"110.113.221.222 is in the list", (boolean)ipl.isIn("110.113.221.222"));
    }

    @Test
    public void testForBadFIle() throws IOException {
        String[] ips = new String[]{"10.221.102/23"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips);
        try {
            new FileBasedIPList("ips.txt");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testWithAWrongEntry() throws IOException {
        String[] ips = new String[]{"10.119.103.112", "10.221.102/23", "10.221.204.1/23"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips);
        try {
            new FileBasedIPList("ips.txt");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void createFileWithEntries(String fileName, String[] ips) throws IOException {
        FileUtils.writeLines((File)new File(fileName), Arrays.asList(ips));
    }

    public static void removeFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            new File(fileName).delete();
        }
    }
}

