/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.SocketInputStream;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSocketIOWithTimeout {
    static final Logger LOG = LoggerFactory.getLogger(TestSocketIOWithTimeout.class);
    private static int TIMEOUT = 1000;
    private static String TEST_STRING = "1234567890";
    private MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
    private static final int PAGE_SIZE = (int)NativeIO.POSIX.getCacheManipulator().getOperatingSystemPageSize();

    private void doIO(InputStream in, OutputStream out, int expectedTimeout) throws IOException {
        byte[] buf = new byte[PAGE_SIZE + 19];
        while (true) {
            long start = Time.now();
            try {
                if (in != null) {
                    in.read(buf);
                    continue;
                }
                out.write(buf);
            }
            catch (SocketTimeoutException e) {
                long diff = Time.now() - start;
                LOG.info("Got SocketTimeoutException as expected after " + diff + " millis : " + e.getMessage());
                Assert.assertTrue((Math.abs((long)expectedTimeout - diff) <= 200L ? 1 : 0) != 0);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSocketIOWithTimeout() throws Exception {
        Pipe pipe = Pipe.open();
        Pipe.SourceChannel source = pipe.source();
        Pipe.SinkChannel sink = pipe.sink();
        try {
            SocketInputStream in = new SocketInputStream((ReadableByteChannel)source, (long)TIMEOUT);
            SocketOutputStream out = new SocketOutputStream((WritableByteChannel)sink, (long)TIMEOUT);
            byte[] writeBytes = TEST_STRING.getBytes();
            byte[] readBytes = new byte[writeBytes.length];
            int byteWithHighBit = -128;
            out.write(writeBytes);
            out.write(byteWithHighBit);
            this.doIO(null, (OutputStream)out, TIMEOUT);
            in.read(readBytes);
            Assert.assertTrue((boolean)Arrays.equals(writeBytes, readBytes));
            Assert.assertEquals((long)(byteWithHighBit & 0xFF), (long)in.read());
            this.doIO((InputStream)in, null, TIMEOUT);
            in.setTimeout((long)(TIMEOUT * 2));
            this.doIO((InputStream)in, null, TIMEOUT * 2);
            in.setTimeout(0L);
            MultithreadedTestUtil.TestingThread thread = new MultithreadedTestUtil.TestingThread(this.ctx, (InputStream)in){
                final /* synthetic */ InputStream val$in;
                {
                    this.val$in = inputStream;
                    super(ctx);
                }

                @Override
                public void doWork() throws Exception {
                    try {
                        this.val$in.read();
                        Assert.fail((String)"Did not fail with interrupt");
                    }
                    catch (InterruptedIOException ste) {
                        LOG.info("Got expection while reading as expected : " + ste.getMessage());
                    }
                }
            };
            this.ctx.addThread(thread);
            this.ctx.startThreads();
            Thread.sleep(1000L);
            thread.interrupt();
            this.ctx.stop();
            Assert.assertTrue((boolean)source.isOpen());
            Assert.assertTrue((boolean)sink.isOpen());
            if (!Shell.WINDOWS) {
                try {
                    out.write(1);
                    Assert.fail((String)"Did not throw");
                }
                catch (IOException ioe) {
                    GenericTestUtils.assertExceptionContains("stream is closed", ioe);
                }
            }
            out.close();
            Assert.assertFalse((boolean)sink.isOpen());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
            Assert.assertFalse((boolean)source.isOpen());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (sink != null) {
                sink.close();
            }
        }
    }

    @Test
    public void testSocketIOWithTimeoutInterrupted() throws Exception {
        Pipe pipe = Pipe.open();
        int timeout = TIMEOUT * 10;
        try (Pipe.SourceChannel source = pipe.source();
             SocketInputStream in = new SocketInputStream((ReadableByteChannel)source, (long)timeout);){
            MultithreadedTestUtil.TestingThread thread = new MultithreadedTestUtil.TestingThread(this.ctx, (InputStream)in, timeout){
                final /* synthetic */ InputStream val$in;
                final /* synthetic */ int val$timeout;
                {
                    this.val$in = inputStream;
                    this.val$timeout = n;
                    super(ctx);
                }

                @Override
                public void doWork() throws Exception {
                    try {
                        this.val$in.read();
                        Assert.fail((String)"Did not fail with interrupt");
                    }
                    catch (InterruptedIOException ste) {
                        String detail = ste.getMessage();
                        String totalString = "Total timeout mills is " + this.val$timeout;
                        String leftString = "millis timeout left";
                        Assert.assertTrue((boolean)detail.contains(totalString));
                        Assert.assertTrue((boolean)detail.contains(leftString));
                    }
                }
            };
            this.ctx.addThread(thread);
            this.ctx.startThreads();
            Thread.sleep(1000L);
            thread.interrupt();
            this.ctx.stop();
        }
    }
}

