/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.sftp;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.sftp.SFTPFileSystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestSFTPFileSystem {
    private static final String TEST_SFTP_DIR = "testsftp";
    private static final String TEST_ROOT_DIR = GenericTestUtils.getTestDir().getAbsolutePath();
    @Rule
    public TestName name = new TestName();
    private static final String connection = "sftp://user:password@localhost";
    private static Path localDir = null;
    private static FileSystem localFs = null;
    private static FileSystem sftpFs = null;
    private static SshServer sshd = null;
    private static int port;

    private static void startSshdServer() throws IOException {
        sshd = SshServer.setUpDefaultServer();
        sshd.setPort(0);
        sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        ArrayList<UserAuthPasswordFactory> userAuthFactories = new ArrayList<UserAuthPasswordFactory>();
        userAuthFactories.add(new UserAuthPasswordFactory());
        sshd.setUserAuthFactories(userAuthFactories);
        sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                return username.equals("user") && password.equals("password");
            }
        });
        sshd.setSubsystemFactories(Arrays.asList(new SftpSubsystemFactory()));
        sshd.start();
        port = sshd.getPort();
    }

    @BeforeClass
    public static void setUp() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        TestSFTPFileSystem.startSshdServer();
        Configuration conf = new Configuration();
        conf.setClass("fs.sftp.impl", SFTPFileSystem.class, FileSystem.class);
        conf.setInt("fs.sftp.host.port", port);
        conf.setBoolean("fs.sftp.impl.disable.cache", true);
        localFs = FileSystem.getLocal((Configuration)conf);
        localDir = localFs.makeQualified(new Path(TEST_ROOT_DIR, TEST_SFTP_DIR));
        if (localFs.exists(localDir)) {
            localFs.delete(localDir, true);
        }
        localFs.mkdirs(localDir);
        sftpFs = FileSystem.get((URI)URI.create(connection), (Configuration)conf);
    }

    @AfterClass
    public static void tearDown() {
        if (localFs != null) {
            try {
                localFs.delete(localDir, true);
                localFs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (sftpFs != null) {
            try {
                sftpFs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (sshd != null) {
            try {
                sshd.stop(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final Path touch(FileSystem fs, String filename) throws IOException {
        return TestSFTPFileSystem.touch(fs, filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Path touch(FileSystem fs, String filename, byte[] data) throws IOException {
        Path lPath = new Path(localDir.toUri().getPath(), filename);
        try (FSDataOutputStream out = null;){
            out = fs.create(lPath);
            if (data != null) {
                out.write(data);
            }
        }
        return lPath;
    }

    @Test
    public void testCreateFile() throws Exception {
        Path file = TestSFTPFileSystem.touch(sftpFs, this.name.getMethodName().toLowerCase());
        Assert.assertTrue((boolean)localFs.exists(file));
        Assert.assertTrue((boolean)sftpFs.delete(file, false));
        Assert.assertFalse((boolean)localFs.exists(file));
    }

    @Test
    public void testFileExists() throws Exception {
        Path file = TestSFTPFileSystem.touch(localFs, this.name.getMethodName().toLowerCase());
        Assert.assertTrue((boolean)sftpFs.exists(file));
        Assert.assertTrue((boolean)localFs.exists(file));
        Assert.assertTrue((boolean)sftpFs.delete(file, false));
        Assert.assertFalse((boolean)sftpFs.exists(file));
        Assert.assertFalse((boolean)localFs.exists(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFile() throws Exception {
        byte[] data = "yaks".getBytes();
        Path file = TestSFTPFileSystem.touch(localFs, this.name.getMethodName().toLowerCase(), data);
        try (FSDataInputStream is = null;){
            is = sftpFs.open(file);
            byte[] b = new byte[data.length];
            is.read(b);
            Assert.assertArrayEquals((byte[])data, (byte[])b);
        }
        Assert.assertTrue((boolean)sftpFs.delete(file, false));
    }

    @Test
    public void testStatFile() throws Exception {
        byte[] data = "yaks".getBytes();
        Path file = TestSFTPFileSystem.touch(localFs, this.name.getMethodName().toLowerCase(), data);
        FileStatus lstat = localFs.getFileStatus(file);
        FileStatus sstat = sftpFs.getFileStatus(file);
        Assert.assertNotNull((Object)sstat);
        Assert.assertEquals((Object)lstat.getPath().toUri().getPath(), (Object)sstat.getPath().toUri().getPath());
        Assert.assertEquals((long)data.length, (long)sstat.getLen());
        Assert.assertEquals((long)lstat.getLen(), (long)sstat.getLen());
        Assert.assertTrue((boolean)sftpFs.delete(file, false));
    }

    @Test(expected=IOException.class)
    public void testDeleteNonEmptyDir() throws Exception {
        Path file = TestSFTPFileSystem.touch(localFs, this.name.getMethodName().toLowerCase());
        sftpFs.delete(localDir, false);
    }

    @Test
    public void testDeleteNonExistFile() throws Exception {
        Path file = new Path(localDir, this.name.getMethodName().toLowerCase());
        Assert.assertFalse((boolean)sftpFs.delete(file, false));
    }

    @Test
    public void testRenameFile() throws Exception {
        byte[] data = "dingos".getBytes();
        Path file1 = TestSFTPFileSystem.touch(localFs, this.name.getMethodName().toLowerCase() + "1");
        Path file2 = new Path(localDir, this.name.getMethodName().toLowerCase() + "2");
        Assert.assertTrue((boolean)sftpFs.rename(file1, file2));
        Assert.assertTrue((boolean)sftpFs.exists(file2));
        Assert.assertFalse((boolean)sftpFs.exists(file1));
        Assert.assertTrue((boolean)localFs.exists(file2));
        Assert.assertFalse((boolean)localFs.exists(file1));
        Assert.assertTrue((boolean)sftpFs.delete(file2, false));
    }

    @Test(expected=IOException.class)
    public void testRenameNonExistFile() throws Exception {
        Path file1 = new Path(localDir, this.name.getMethodName().toLowerCase() + "1");
        Path file2 = new Path(localDir, this.name.getMethodName().toLowerCase() + "2");
        sftpFs.rename(file1, file2);
    }

    @Test(expected=IOException.class)
    public void testRenamingFileOntoExistingFile() throws Exception {
        Path file1 = TestSFTPFileSystem.touch(localFs, this.name.getMethodName().toLowerCase() + "1");
        Path file2 = TestSFTPFileSystem.touch(localFs, this.name.getMethodName().toLowerCase() + "2");
        sftpFs.rename(file1, file2);
    }

    @Test
    public void testGetAccessTime() throws IOException {
        Path file = TestSFTPFileSystem.touch(localFs, this.name.getMethodName().toLowerCase());
        LocalFileSystem local = (LocalFileSystem)localFs;
        java.nio.file.Path path = local.pathToFile(file).toPath();
        long accessTime1 = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime().toMillis();
        accessTime1 = accessTime1 / 1000L * 1000L;
        long accessTime2 = sftpFs.getFileStatus(file).getAccessTime();
        Assert.assertEquals((long)accessTime1, (long)accessTime2);
    }

    @Test
    public void testGetModifyTime() throws IOException {
        Path file = TestSFTPFileSystem.touch(localFs, this.name.getMethodName().toLowerCase() + "1");
        File localFile = ((LocalFileSystem)localFs).pathToFile(file);
        long modifyTime1 = localFile.lastModified();
        modifyTime1 = modifyTime1 / 1000L * 1000L;
        long modifyTime2 = sftpFs.getFileStatus(file).getModificationTime();
        Assert.assertEquals((long)modifyTime1, (long)modifyTime2);
    }
}

