/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRPC;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslPlainServer;
import org.apache.hadoop.security.SaslPropertiesResolver;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.TestUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenInfo;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSaslRPC {
    SaslRpcServer.QualityOfProtection[] qop;
    SaslRpcServer.QualityOfProtection expectedQop;
    String saslPropertiesResolver;
    private static final String ADDRESS = "0.0.0.0";
    public static final Log LOG = LogFactory.getLog(TestSaslRPC.class);
    static final String ERROR_MESSAGE = "Token is invalid";
    static final String SERVER_PRINCIPAL_KEY = "test.ipc.server.principal";
    static final String SERVER_KEYTAB_KEY = "test.ipc.server.keytab";
    static final String SERVER_PRINCIPAL_1 = "p1/foo@BAR";
    static final String SERVER_PRINCIPAL_2 = "p2/foo@BAR";
    private static Configuration conf;
    static Boolean enableSecretManager;
    static Boolean forceSecretManager;
    static Boolean clientFallBackToSimpleAllowed;
    private static Pattern BadToken;
    private static Pattern KrbFailed;
    private static Pattern NoTokenAuth;
    private static Pattern NoFallback;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SaslRpcServer.QualityOfProtection qop : SaslRpcServer.QualityOfProtection.values()) {
            params.add(new Object[]{new SaslRpcServer.QualityOfProtection[]{qop}, qop, null});
        }
        params.add(new Object[]{new SaslRpcServer.QualityOfProtection[]{SaslRpcServer.QualityOfProtection.PRIVACY, SaslRpcServer.QualityOfProtection.AUTHENTICATION}, SaslRpcServer.QualityOfProtection.PRIVACY, null});
        params.add(new Object[]{new SaslRpcServer.QualityOfProtection[]{SaslRpcServer.QualityOfProtection.PRIVACY, SaslRpcServer.QualityOfProtection.AUTHENTICATION}, SaslRpcServer.QualityOfProtection.AUTHENTICATION, "org.apache.hadoop.ipc.TestSaslRPC$AuthSaslPropertiesResolver"});
        return params;
    }

    public TestSaslRPC(SaslRpcServer.QualityOfProtection[] qop, SaslRpcServer.QualityOfProtection expectedQop, String saslPropertiesResolver) {
        this.qop = qop;
        this.expectedQop = expectedQop;
        this.saslPropertiesResolver = saslPropertiesResolver;
    }

    @BeforeClass
    public static void setupKerb() {
        System.setProperty("java.security.krb5.kdc", "");
        System.setProperty("java.security.krb5.realm", "NONE");
        Security.addProvider((Provider)new SaslPlainServer.SecurityProvider());
    }

    @Before
    public void setup() {
        LOG.info((Object)"---------------------------------");
        LOG.info((Object)("Testing QOP:" + TestSaslRPC.getQOPNames(this.qop)));
        LOG.info((Object)"---------------------------------");
        conf = new Configuration();
        conf.set("hadoop.security.authentication", SaslRpcServer.AuthMethod.SIMPLE.toString());
        conf.set("hadoop.rpc.protection", TestSaslRPC.getQOPNames(this.qop));
        if (this.saslPropertiesResolver != null) {
            conf.set("hadoop.security.saslproperties.resolver.class", this.saslPropertiesResolver);
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        enableSecretManager = null;
        forceSecretManager = null;
        clientFallBackToSimpleAllowed = true;
    }

    static String getQOPNames(SaslRpcServer.QualityOfProtection[] qops) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (SaslRpcServer.QualityOfProtection qop : qops) {
            sb.append(org.apache.hadoop.util.StringUtils.toLowerCase((String)qop.name()));
            if (++i >= qops.length) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Test
    public void testDigestRpc() throws Exception {
        TestTokenSecretManager sm = new TestTokenSecretManager();
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestSaslProtocol.class).setInstance((Object)new TestSaslImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager((SecretManager)sm).build();
        this.doDigestRpc((Server)server, sm);
    }

    @Test
    public void testDigestRpcWithoutAnnotation() throws Exception {
        TestTokenSecretManager sm = new TestTokenSecretManager();
        try {
            SecurityUtil.setSecurityInfoProviders((SecurityInfo[])new SecurityInfo[]{new CustomSecurityInfo()});
            RPC.Server server = new RPC.Builder(conf).setProtocol(TestSaslProtocol.class).setInstance((Object)new TestSaslImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager((SecretManager)sm).build();
            this.doDigestRpc((Server)server, sm);
        }
        finally {
            SecurityUtil.setSecurityInfoProviders((SecurityInfo[])new SecurityInfo[0]);
        }
    }

    @Test
    public void testErrorMessage() throws Exception {
        BadTokenSecretManager sm = new BadTokenSecretManager();
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestSaslProtocol.class).setInstance((Object)new TestSaslImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager((SecretManager)sm).build();
        boolean succeeded = false;
        try {
            this.doDigestRpc((Server)server, sm);
        }
        catch (RemoteException e) {
            LOG.info((Object)("LOGGING MESSAGE: " + e.getLocalizedMessage()));
            Assert.assertEquals((Object)ERROR_MESSAGE, (Object)e.getLocalizedMessage());
            Assert.assertTrue((boolean)(e.unwrapRemoteException() instanceof SecretManager.InvalidToken));
            succeeded = true;
        }
        Assert.assertTrue((boolean)succeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDigestRpc(Server server, TestTokenSecretManager sm) throws Exception {
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        TestTokenIdentifier tokenId = new TestTokenIdentifier(new Text(current.getUserName()));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        current.addToken(token);
        TestSaslProtocol proxy = null;
        try {
            proxy = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
            SaslRpcServer.AuthMethod authMethod = proxy.getAuthMethod();
            Assert.assertEquals((Object)SaslRpcServer.AuthMethod.TOKEN, (Object)authMethod);
            Assert.assertEquals((Object)this.expectedQop.saslQop, (Object)RPC.getConnectionIdForProxy((Object)proxy).getSaslQop());
            proxy.ping();
        }
        finally {
            server.stop();
            if (proxy != null) {
                RPC.stopProxy((Object)proxy);
            }
        }
    }

    @Test
    public void testPingInterval() throws Exception {
        Configuration newConf = new Configuration(conf);
        newConf.set(SERVER_PRINCIPAL_KEY, SERVER_PRINCIPAL_1);
        conf.setInt("ipc.ping.interval", 60000);
        newConf.setBoolean("ipc.client.ping", true);
        Client.ConnectionId remoteId = Client.ConnectionId.getConnectionId((InetSocketAddress)new InetSocketAddress(0), TestSaslProtocol.class, null, (int)0, (Configuration)newConf);
        Assert.assertEquals((long)60000L, (long)remoteId.getPingInterval());
        newConf.setBoolean("ipc.client.ping", false);
        remoteId = Client.ConnectionId.getConnectionId((InetSocketAddress)new InetSocketAddress(0), TestSaslProtocol.class, null, (int)0, (Configuration)newConf);
        Assert.assertEquals((long)0L, (long)remoteId.getPingInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerConnectionConf() throws Exception {
        TestTokenSecretManager sm = new TestTokenSecretManager();
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestSaslProtocol.class).setInstance((Object)new TestSaslImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager((SecretManager)sm).build();
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        TestTokenIdentifier tokenId = new TestTokenIdentifier(new Text(current.getUserName()));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        current.addToken(token);
        Configuration newConf = new Configuration(conf);
        newConf.set("hadoop.rpc.socket.factory.class.default", "");
        Client client = null;
        TestSaslProtocol proxy1 = null;
        TestSaslProtocol proxy2 = null;
        TestSaslProtocol proxy3 = null;
        int[] timeouts = new int[]{111222, 3333333};
        try {
            newConf.setInt("ipc.client.connection.maxidletime", timeouts[0]);
            proxy1 = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)newConf);
            proxy1.getAuthMethod();
            client = WritableRpcEngine.getClient((Configuration)newConf);
            Set conns = client.getConnectionIds();
            Assert.assertEquals((String)"number of connections in cache is wrong", (long)1L, (long)conns.size());
            proxy2 = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)newConf);
            proxy2.getAuthMethod();
            Assert.assertEquals((String)"number of connections in cache is wrong", (long)1L, (long)conns.size());
            newConf.setInt("ipc.client.connection.maxidletime", timeouts[1]);
            proxy3 = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)newConf);
            proxy3.getAuthMethod();
            Assert.assertEquals((String)"number of connections in cache is wrong", (long)2L, (long)conns.size());
            Client.ConnectionId[] connsArray = new Client.ConnectionId[]{RPC.getConnectionIdForProxy((Object)proxy1), RPC.getConnectionIdForProxy((Object)proxy2), RPC.getConnectionIdForProxy((Object)proxy3)};
            Assert.assertEquals((Object)connsArray[0], (Object)connsArray[1]);
            Assert.assertEquals((long)connsArray[0].getMaxIdleTime(), (long)timeouts[0]);
            Assert.assertFalse((boolean)connsArray[0].equals((Object)connsArray[2]));
            Assert.assertNotSame((Object)connsArray[2].getMaxIdleTime(), (Object)timeouts[1]);
        }
        catch (Throwable throwable) {
            server.stop();
            if (client != null) {
                client.getConnectionIds().clear();
            }
            if (proxy1 != null) {
                RPC.stopProxy(proxy1);
            }
            if (proxy2 != null) {
                RPC.stopProxy(proxy2);
            }
            if (proxy3 != null) {
                RPC.stopProxy(proxy3);
            }
            throw throwable;
        }
        server.stop();
        if (client != null) {
            client.getConnectionIds().clear();
        }
        if (proxy1 != null) {
            RPC.stopProxy((Object)proxy1);
        }
        if (proxy2 != null) {
            RPC.stopProxy((Object)proxy2);
        }
        if (proxy3 != null) {
            RPC.stopProxy((Object)proxy3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testKerberosRpc(String principal, String keytab) throws Exception {
        Configuration newConf = new Configuration(conf);
        newConf.set(SERVER_PRINCIPAL_KEY, principal);
        newConf.set(SERVER_KEYTAB_KEY, keytab);
        SecurityUtil.login((Configuration)newConf, (String)SERVER_KEYTAB_KEY, (String)SERVER_PRINCIPAL_KEY);
        TestUserGroupInformation.verifyLoginMetrics(1L, 0);
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        System.out.println("UGI: " + current);
        RPC.Server server = new RPC.Builder(newConf).setProtocol(TestSaslProtocol.class).setInstance((Object)new TestSaslImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).build();
        TestSaslProtocol proxy = null;
        server.start();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        try {
            proxy = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)newConf);
            proxy.ping();
        }
        finally {
            server.stop();
            if (proxy != null) {
                RPC.stopProxy((Object)proxy);
            }
        }
        System.out.println("Test is successful.");
    }

    @Test
    public void testSaslPlainServer() throws IOException {
        this.runNegotiation(new TestPlainCallbacks.Client("user", "pass"), new TestPlainCallbacks.Server("user", "pass"));
    }

    @Test
    public void testSaslPlainServerBadPassword() {
        SaslException e = null;
        try {
            this.runNegotiation(new TestPlainCallbacks.Client("user", "pass1"), new TestPlainCallbacks.Server("user", "pass2"));
        }
        catch (SaslException se) {
            e = se;
        }
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)"PLAIN auth failed: wrong password", (Object)e.getMessage());
    }

    private void runNegotiation(CallbackHandler clientCbh, CallbackHandler serverCbh) throws SaslException {
        String mechanism = SaslRpcServer.AuthMethod.PLAIN.getMechanismName();
        SaslClient saslClient = Sasl.createSaslClient(new String[]{mechanism}, null, null, null, null, clientCbh);
        Assert.assertNotNull((Object)saslClient);
        SaslServer saslServer = Sasl.createSaslServer(mechanism, null, "localhost", null, serverCbh);
        Assert.assertNotNull((String)"failed to find PLAIN server", (Object)saslServer);
        byte[] response = saslClient.evaluateChallenge(new byte[0]);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)saslClient.isComplete());
        response = saslServer.evaluateResponse(response);
        Assert.assertNull((Object)response);
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertNotNull((Object)saslServer.getAuthorizationID());
    }

    private static Pattern Denied(SaslRpcServer.AuthMethod method) {
        return Pattern.compile(".*RemoteException.*AccessControlException.*: " + method + " authentication is not enabled.*");
    }

    private static Pattern No(SaslRpcServer.AuthMethod ... method) {
        String methods = StringUtils.join((Object[])method, (String)",\\s*");
        return Pattern.compile(".*Failed on local exception:.* Client cannot authenticate via:\\[" + methods + "\\].*");
    }

    @Test
    public void testSimpleServer() throws Exception {
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.OTHER));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.OTHER));
    }

    @Test
    public void testNoClientFallbackToSimple() throws Exception {
        clientFallBackToSimpleAllowed = false;
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.OTHER));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.INVALID));
        TestSaslRPC.assertAuthEquals(NoFallback, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE));
        TestSaslRPC.assertAuthEquals(NoFallback, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.OTHER));
        TestSaslRPC.assertAuthEquals(NoFallback, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(NoFallback, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.INVALID));
        forceSecretManager = true;
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.OTHER));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.TOKEN, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(BadToken, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.INVALID));
        TestSaslRPC.assertAuthEquals(NoFallback, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE));
        TestSaslRPC.assertAuthEquals(NoFallback, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.OTHER));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.TOKEN, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(BadToken, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.INVALID));
        TestSaslRPC.assertAuthEquals(TestSaslRPC.Denied(SaslRpcServer.AuthMethod.SIMPLE), this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.TOKEN));
        TestSaslRPC.assertAuthEquals(TestSaslRPC.No(SaslRpcServer.AuthMethod.TOKEN), this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.TOKEN, UseToken.OTHER));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.TOKEN, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.TOKEN, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(BadToken, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.TOKEN, UseToken.INVALID));
        TestSaslRPC.assertAuthEquals(TestSaslRPC.No(SaslRpcServer.AuthMethod.TOKEN), this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.TOKEN));
        TestSaslRPC.assertAuthEquals(TestSaslRPC.No(SaslRpcServer.AuthMethod.TOKEN), this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.TOKEN, UseToken.OTHER));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.TOKEN, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.TOKEN, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(BadToken, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.TOKEN, UseToken.INVALID));
    }

    @Test
    public void testSimpleServerWithTokens() throws Exception {
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.OTHER));
        enableSecretManager = true;
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.OTHER));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.OTHER));
        forceSecretManager = true;
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.TOKEN, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.OTHER));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.TOKEN, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.OTHER));
    }

    @Test
    public void testSimpleServerWithInvalidTokens() throws Exception {
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.INVALID));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.INVALID));
        enableSecretManager = true;
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.INVALID));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.SIMPLE, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.INVALID));
        forceSecretManager = true;
        TestSaslRPC.assertAuthEquals(BadToken, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.SIMPLE, UseToken.INVALID));
        TestSaslRPC.assertAuthEquals(BadToken, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.SIMPLE, UseToken.INVALID));
    }

    @Test
    public void testTokenOnlyServer() throws Exception {
        TestSaslRPC.assertAuthEquals(TestSaslRPC.Denied(SaslRpcServer.AuthMethod.SIMPLE), this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.TOKEN));
        TestSaslRPC.assertAuthEquals(TestSaslRPC.No(SaslRpcServer.AuthMethod.TOKEN), this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.TOKEN, UseToken.OTHER));
        TestSaslRPC.assertAuthEquals(TestSaslRPC.No(SaslRpcServer.AuthMethod.TOKEN), this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.TOKEN));
        TestSaslRPC.assertAuthEquals(TestSaslRPC.No(SaslRpcServer.AuthMethod.TOKEN), this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.TOKEN, UseToken.OTHER));
    }

    @Test
    public void testTokenOnlyServerWithTokens() throws Exception {
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.TOKEN, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.TOKEN, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.TOKEN, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.TOKEN, UseToken.VALID));
        enableSecretManager = false;
        TestSaslRPC.assertAuthEquals(NoTokenAuth, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.TOKEN, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(NoTokenAuth, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.TOKEN, UseToken.VALID));
    }

    @Test
    public void testTokenOnlyServerWithInvalidTokens() throws Exception {
        TestSaslRPC.assertAuthEquals(BadToken, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.TOKEN, UseToken.INVALID));
        TestSaslRPC.assertAuthEquals(BadToken, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.TOKEN, UseToken.INVALID));
        enableSecretManager = false;
        TestSaslRPC.assertAuthEquals(NoTokenAuth, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.TOKEN, UseToken.INVALID));
        TestSaslRPC.assertAuthEquals(NoTokenAuth, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.TOKEN, UseToken.INVALID));
    }

    @Test
    public void testKerberosServer() throws Exception {
        TestSaslRPC.assertAuthEquals(TestSaslRPC.Denied(SaslRpcServer.AuthMethod.SIMPLE), this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.KERBEROS));
        TestSaslRPC.assertAuthEquals(TestSaslRPC.No(SaslRpcServer.AuthMethod.TOKEN, SaslRpcServer.AuthMethod.KERBEROS), this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.KERBEROS, UseToken.OTHER));
        TestSaslRPC.assertAuthEquals(KrbFailed, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.KERBEROS));
        TestSaslRPC.assertAuthEquals(KrbFailed, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.KERBEROS, UseToken.OTHER));
    }

    @Test
    public void testKerberosServerWithTokens() throws Exception {
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.TOKEN, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.KERBEROS, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(SaslRpcServer.AuthMethod.TOKEN, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.KERBEROS, UseToken.VALID));
        enableSecretManager = false;
        TestSaslRPC.assertAuthEquals(TestSaslRPC.No(SaslRpcServer.AuthMethod.KERBEROS), this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.KERBEROS, UseToken.VALID));
        TestSaslRPC.assertAuthEquals(KrbFailed, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.KERBEROS, UseToken.VALID));
    }

    @Test
    public void testKerberosServerWithInvalidTokens() throws Exception {
        TestSaslRPC.assertAuthEquals(BadToken, this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.KERBEROS, UseToken.INVALID));
        TestSaslRPC.assertAuthEquals(BadToken, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.KERBEROS, UseToken.INVALID));
        enableSecretManager = false;
        TestSaslRPC.assertAuthEquals(TestSaslRPC.No(SaslRpcServer.AuthMethod.KERBEROS), this.getAuthMethod(SaslRpcServer.AuthMethod.SIMPLE, SaslRpcServer.AuthMethod.KERBEROS, UseToken.INVALID));
        TestSaslRPC.assertAuthEquals(KrbFailed, this.getAuthMethod(SaslRpcServer.AuthMethod.KERBEROS, SaslRpcServer.AuthMethod.KERBEROS, UseToken.INVALID));
    }

    private String getAuthMethod(SaslRpcServer.AuthMethod clientAuth, SaslRpcServer.AuthMethod serverAuth) throws Exception {
        try {
            return this.internalGetAuthMethod(clientAuth, serverAuth, UseToken.NONE);
        }
        catch (Exception e) {
            LOG.warn((Object)"Auth method failure", (Throwable)e);
            return e.toString();
        }
    }

    private String getAuthMethod(SaslRpcServer.AuthMethod clientAuth, SaslRpcServer.AuthMethod serverAuth, UseToken tokenType) throws Exception {
        try {
            return this.internalGetAuthMethod(clientAuth, serverAuth, tokenType);
        }
        catch (Exception e) {
            LOG.warn((Object)"Auth method failure", (Throwable)e);
            return e.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String internalGetAuthMethod(SaslRpcServer.AuthMethod clientAuth, SaslRpcServer.AuthMethod serverAuth, UseToken tokenType) throws Exception {
        boolean useSecretManager;
        final Configuration serverConf = new Configuration(conf);
        serverConf.set("hadoop.security.authentication", serverAuth.toString());
        UserGroupInformation.setConfiguration((Configuration)serverConf);
        UserGroupInformation serverUgi = serverAuth == SaslRpcServer.AuthMethod.KERBEROS ? UserGroupInformation.createRemoteUser((String)"server/localhost@NONE") : UserGroupInformation.createRemoteUser((String)"server");
        serverUgi.setAuthenticationMethod(serverAuth);
        TestTokenSecretManager sm = new TestTokenSecretManager();
        boolean bl = useSecretManager = serverAuth != SaslRpcServer.AuthMethod.SIMPLE;
        if (enableSecretManager != null) {
            useSecretManager &= enableSecretManager.booleanValue();
        }
        if (forceSecretManager != null) {
            useSecretManager |= forceSecretManager.booleanValue();
        }
        final TestTokenSecretManager serverSm = useSecretManager ? sm : null;
        Server server = (Server)serverUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Server>(){

            @Override
            public Server run() throws IOException {
                RPC.Server server = new RPC.Builder(serverConf).setProtocol(TestSaslProtocol.class).setInstance((Object)new TestSaslImpl()).setBindAddress(TestSaslRPC.ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager(serverSm).build();
                server.start();
                return server;
            }
        });
        final Configuration clientConf = new Configuration(conf);
        clientConf.set("hadoop.security.authentication", clientAuth.toString());
        clientConf.setBoolean("ipc.client.fallback-to-simple-auth-allowed", clientFallBackToSimpleAllowed.booleanValue());
        UserGroupInformation.setConfiguration((Configuration)clientConf);
        final UserGroupInformation clientUgi = UserGroupInformation.createRemoteUser((String)"client");
        clientUgi.setAuthenticationMethod(clientAuth);
        final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        if (tokenType != UseToken.NONE) {
            TestTokenIdentifier tokenId = new TestTokenIdentifier(new Text(clientUgi.getUserName()));
            Token token = null;
            switch (tokenType) {
                case VALID: {
                    token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
                    SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
                    break;
                }
                case INVALID: {
                    token = new Token(tokenId.getBytes(), "bad-password!".getBytes(), tokenId.getKind(), null);
                    SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
                    break;
                }
                case OTHER: {
                    token = new Token();
                    break;
                }
            }
            clientUgi.addToken(token);
        }
        try {
            LOG.info((Object)("trying ugi:" + clientUgi + " tokens:" + clientUgi.getTokens()));
            String string = (String)clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String run() throws IOException {
                    String string;
                    block3: {
                        TestSaslProtocol proxy = null;
                        try {
                            proxy = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)clientConf);
                            proxy.ping();
                            Assert.assertEquals((Object)clientUgi.getUserName(), (Object)proxy.getAuthUser());
                            SaslRpcServer.AuthMethod authMethod = proxy.getAuthMethod();
                            Assert.assertEquals((Object)(authMethod != SaslRpcServer.AuthMethod.SIMPLE ? TestSaslRPC.this.expectedQop.saslQop : null), (Object)RPC.getConnectionIdForProxy((Object)proxy).getSaslQop());
                            string = authMethod.toString();
                            if (proxy == null) break block3;
                        }
                        catch (Throwable throwable) {
                            if (proxy != null) {
                                RPC.stopProxy(proxy);
                            }
                            throw throwable;
                        }
                        RPC.stopProxy((Object)proxy);
                    }
                    return string;
                }
            });
            return string;
        }
        finally {
            server.stop();
        }
    }

    private static void assertAuthEquals(SaslRpcServer.AuthMethod expect, String actual) {
        Assert.assertEquals((Object)expect.toString(), (Object)actual);
    }

    private static void assertAuthEquals(Pattern expect, String actual) {
        if (!expect.matcher(actual).matches()) {
            Assert.assertEquals((Object)expect, (Object)actual);
        } else {
            Assert.assertTrue((boolean)true);
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Testing Kerberos authentication over RPC");
        if (args.length != 2) {
            System.err.println("Usage: java <options> org.apache.hadoop.ipc.TestSaslRPC  <serverPrincipal> <keytabFile>");
            System.exit(-1);
        }
        String principal = args[0];
        String keytab = args[1];
        TestSaslRPC.testKerberosRpc(principal, keytab);
    }

    static {
        enableSecretManager = null;
        forceSecretManager = null;
        clientFallBackToSimpleAllowed = true;
        ((Log4JLogger)Client.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)Server.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslInputStream.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SecurityUtil.LOG).getLogger().setLevel(Level.ALL);
        BadToken = Pattern.compile(".*DIGEST-MD5: digest response format violation.*");
        KrbFailed = Pattern.compile(".*Failed on local exception:.* Failed to specify server's Kerberos principal name.*");
        NoTokenAuth = Pattern.compile(".*IllegalArgumentException: TOKEN authentication requires a secret manager");
        NoFallback = Pattern.compile(".*Failed on local exception:.* Server asks us to fall back to SIMPLE auth, but this client is configured to only allow secure connections.*");
    }

    static class AuthSaslPropertiesResolver
    extends SaslPropertiesResolver {
        AuthSaslPropertiesResolver() {
        }

        public Map<String, String> getServerProperties(InetAddress address) {
            HashMap<String, String> newPropertes = new HashMap<String, String>(this.getDefaultProperties());
            newPropertes.put("javax.security.sasl.qop", SaslRpcServer.QualityOfProtection.AUTHENTICATION.getSaslQop());
            return newPropertes;
        }
    }

    static class TestPlainCallbacks {
        TestPlainCallbacks() {
        }

        public static class Server
        implements CallbackHandler {
            String user = null;
            String password = null;

            Server(String user, String password) {
                this.user = user;
                this.password = password;
            }

            @Override
            public void handle(Callback[] callbacks) throws UnsupportedCallbackException, SaslException {
                NameCallback nc = null;
                PasswordCallback pc = null;
                AuthorizeCallback ac = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        nc = (NameCallback)callback;
                        Assert.assertEquals((Object)this.user, (Object)nc.getName());
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        pc = (PasswordCallback)callback;
                        if (this.password.equals(new String(pc.getPassword()))) continue;
                        throw new IllegalArgumentException("wrong password");
                    }
                    if (callback instanceof AuthorizeCallback) {
                        ac = (AuthorizeCallback)callback;
                        Assert.assertEquals((Object)this.user, (Object)ac.getAuthorizationID());
                        Assert.assertEquals((Object)this.user, (Object)ac.getAuthenticationID());
                        ac.setAuthorized(true);
                        ac.setAuthorizedID(ac.getAuthenticationID());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Unsupported SASL PLAIN Callback");
                }
                Assert.assertNotNull(nc);
                Assert.assertNotNull(pc);
                Assert.assertNotNull(ac);
            }
        }

        public static class Client
        implements CallbackHandler {
            String user = null;
            String password = null;

            Client(String user, String password) {
                this.user = user;
                this.password = password;
            }

            @Override
            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(this.user);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL PLAIN Callback");
                }
            }
        }
    }

    public static class CustomSecurityInfo
    extends SecurityInfo {
        public KerberosInfo getKerberosInfo(Class<?> protocol, Configuration conf) {
            return new KerberosInfo(){

                public Class<? extends Annotation> annotationType() {
                    return null;
                }

                public String serverPrincipal() {
                    return TestSaslRPC.SERVER_PRINCIPAL_KEY;
                }

                public String clientPrincipal() {
                    return null;
                }
            };
        }

        public TokenInfo getTokenInfo(Class<?> protocol, Configuration conf) {
            return new TokenInfo(){

                public Class<? extends TokenSelector<? extends TokenIdentifier>> value() {
                    return TestTokenSelector.class;
                }

                public Class<? extends Annotation> annotationType() {
                    return null;
                }
            };
        }
    }

    public static class TestSaslImpl
    extends TestRPC.TestImpl
    implements TestSaslProtocol {
        @Override
        public SaslRpcServer.AuthMethod getAuthMethod() throws IOException {
            return UserGroupInformation.getCurrentUser().getAuthenticationMethod().getAuthMethod();
        }

        @Override
        public String getAuthUser() throws IOException {
            return UserGroupInformation.getCurrentUser().getUserName();
        }
    }

    @KerberosInfo(serverPrincipal="test.ipc.server.principal")
    @TokenInfo(value=TestTokenSelector.class)
    public static interface TestSaslProtocol
    extends TestRPC.TestProtocol {
        public SaslRpcServer.AuthMethod getAuthMethod() throws IOException;

        public String getAuthUser() throws IOException;
    }

    public static class TestTokenSelector
    implements TokenSelector<TestTokenIdentifier> {
        public Token<TestTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
            if (service == null) {
                return null;
            }
            for (Token<? extends TokenIdentifier> token : tokens) {
                if (!TestTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !service.equals((Object)token.getService())) continue;
                return token;
            }
            return null;
        }
    }

    public static class BadTokenSecretManager
    extends TestTokenSecretManager {
        @Override
        public byte[] retrievePassword(TestTokenIdentifier id) throws SecretManager.InvalidToken {
            throw new SecretManager.InvalidToken(TestSaslRPC.ERROR_MESSAGE);
        }
    }

    public static class TestTokenSecretManager
    extends SecretManager<TestTokenIdentifier> {
        public byte[] createPassword(TestTokenIdentifier id) {
            return id.getBytes();
        }

        public byte[] retrievePassword(TestTokenIdentifier id) throws SecretManager.InvalidToken {
            return id.getBytes();
        }

        public TestTokenIdentifier createIdentifier() {
            return new TestTokenIdentifier();
        }
    }

    public static class TestTokenIdentifier
    extends TokenIdentifier {
        private Text tokenid;
        private Text realUser;
        static final Text KIND_NAME = new Text("test.token");

        public TestTokenIdentifier() {
            this(new Text(), new Text());
        }

        public TestTokenIdentifier(Text tokenid) {
            this(tokenid, new Text());
        }

        public TestTokenIdentifier(Text tokenid, Text realUser) {
            this.tokenid = tokenid == null ? new Text() : tokenid;
            this.realUser = realUser == null ? new Text() : realUser;
        }

        public Text getKind() {
            return KIND_NAME;
        }

        public UserGroupInformation getUser() {
            if (this.realUser.toString().isEmpty()) {
                return UserGroupInformation.createRemoteUser((String)this.tokenid.toString());
            }
            UserGroupInformation realUgi = UserGroupInformation.createRemoteUser((String)this.realUser.toString());
            return UserGroupInformation.createProxyUser((String)this.tokenid.toString(), (UserGroupInformation)realUgi);
        }

        public void readFields(DataInput in) throws IOException {
            this.tokenid.readFields(in);
            this.realUser.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            this.tokenid.write(out);
            this.realUser.write(out);
        }
    }

    static enum UseToken {
        NONE,
        VALID,
        INVALID,
        OTHER;

    }
}

