/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.IOException;
import org.apache.hadoop.io.retry.UnreliableInterface;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;

class UnreliableImplementation
implements UnreliableInterface {
    private int failsOnceInvocationCount;
    private int failsOnceWithValueInvocationCount;
    private int failsOnceIOExceptionInvocationCount;
    private int failsOnceRemoteExceptionInvocationCount;
    private int failsTenTimesInvocationCount;
    private int succeedsOnceThenFailsCount;
    private int succeedsOnceThenFailsIdempotentCount;
    private int succeedsTenTimesThenFailsCount;
    private String identifier;
    private TypeOfExceptionToFailWith exceptionToFailWith;

    public UnreliableImplementation() {
        this(null);
    }

    public UnreliableImplementation(String identifier) {
        this(identifier, TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION);
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public UnreliableImplementation(String identifier, TypeOfExceptionToFailWith exceptionToFailWith) {
        this.identifier = identifier;
        this.exceptionToFailWith = exceptionToFailWith;
    }

    @Override
    public void alwaysSucceeds() {
    }

    @Override
    public void alwaysFailsWithFatalException() throws UnreliableInterface.FatalException {
        throw new UnreliableInterface.FatalException();
    }

    @Override
    public void alwaysFailsWithRemoteFatalException() throws RemoteException {
        throw new RemoteException(UnreliableInterface.FatalException.class.getName(), "Oops");
    }

    @Override
    public void failsOnceThenSucceeds() throws UnreliableInterface.UnreliableException {
        if (this.failsOnceInvocationCount++ == 0) {
            throw new UnreliableInterface.UnreliableException();
        }
    }

    @Override
    public boolean failsOnceThenSucceedsWithReturnValue() throws UnreliableInterface.UnreliableException {
        if (this.failsOnceWithValueInvocationCount++ == 0) {
            throw new UnreliableInterface.UnreliableException();
        }
        return true;
    }

    @Override
    public void failsOnceWithIOException() throws IOException {
        if (this.failsOnceIOExceptionInvocationCount++ == 0) {
            throw new IOException("test exception for failsOnceWithIOException");
        }
    }

    @Override
    public void failsOnceWithRemoteException() throws RemoteException {
        if (this.failsOnceRemoteExceptionInvocationCount++ == 0) {
            throw new RemoteException(IOException.class.getName(), "test exception for failsOnceWithRemoteException");
        }
    }

    @Override
    public void failsTenTimesThenSucceeds() throws UnreliableInterface.UnreliableException {
        if (this.failsTenTimesInvocationCount++ < 10) {
            throw new UnreliableInterface.UnreliableException();
        }
    }

    @Override
    public String succeedsOnceThenFailsReturningString() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        if (this.succeedsOnceThenFailsCount++ < 1) {
            return this.identifier;
        }
        UnreliableImplementation.throwAppropriateException(this.exceptionToFailWith, this.identifier);
        return null;
    }

    @Override
    public String succeedsTenTimesThenFailsReturningString() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        if (this.succeedsTenTimesThenFailsCount++ < 10) {
            return this.identifier;
        }
        UnreliableImplementation.throwAppropriateException(this.exceptionToFailWith, this.identifier);
        return null;
    }

    @Override
    public String succeedsOnceThenFailsReturningStringIdempotent() throws UnreliableInterface.UnreliableException, StandbyException, IOException {
        if (this.succeedsOnceThenFailsIdempotentCount++ < 1) {
            return this.identifier;
        }
        UnreliableImplementation.throwAppropriateException(this.exceptionToFailWith, this.identifier);
        return null;
    }

    @Override
    public String failsIfIdentifierDoesntMatch(String identifier) throws UnreliableInterface.UnreliableException, StandbyException, IOException {
        if (this.identifier.equals(identifier)) {
            return identifier;
        }
        String message = "expected '" + this.identifier + "' but received '" + identifier + "'";
        UnreliableImplementation.throwAppropriateException(this.exceptionToFailWith, message);
        return null;
    }

    @Override
    public void nonIdempotentVoidFailsIfIdentifierDoesntMatch(String identifier) throws UnreliableInterface.UnreliableException, StandbyException, IOException {
        if (this.identifier.equals(identifier)) {
            return;
        }
        String message = "expected '" + this.identifier + "' but received '" + identifier + "'";
        UnreliableImplementation.throwAppropriateException(this.exceptionToFailWith, message);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.identifier + "]";
    }

    private static void throwAppropriateException(TypeOfExceptionToFailWith eType, String message) throws UnreliableInterface.UnreliableException, StandbyException, IOException {
        switch (eType) {
            case STANDBY_EXCEPTION: {
                throw new StandbyException(message);
            }
            case UNRELIABLE_EXCEPTION: {
                throw new UnreliableInterface.UnreliableException(message);
            }
            case IO_EXCEPTION: {
                throw new IOException(message);
            }
            case REMOTE_EXCEPTION: {
                throw new RemoteException(IOException.class.getName(), message);
            }
        }
        throw new RuntimeException(message);
    }

    public static enum TypeOfExceptionToFailWith {
        UNRELIABLE_EXCEPTION,
        STANDBY_EXCEPTION,
        IO_EXCEPTION,
        REMOTE_EXCEPTION;

    }
}

