/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.protocol;

public enum GuacamoleStatus {
    SUCCESS(200, 1000, 0),
    UNSUPPORTED(501, 1011, 256),
    SERVER_ERROR(500, 1011, 512),
    SERVER_BUSY(503, 1008, 513),
    UPSTREAM_TIMEOUT(504, 1011, 514),
    UPSTREAM_ERROR(502, 1011, 515),
    RESOURCE_NOT_FOUND(404, 1002, 516),
    RESOURCE_CONFLICT(409, 1008, 517),
    RESOURCE_CLOSED(404, 1002, 518),
    UPSTREAM_NOT_FOUND(502, 1011, 519),
    UPSTREAM_UNAVAILABLE(502, 1011, 520),
    SESSION_CONFLICT(409, 1008, 521),
    SESSION_TIMEOUT(408, 1002, 522),
    SESSION_CLOSED(404, 1002, 523),
    CLIENT_BAD_REQUEST(400, 1002, 768),
    CLIENT_UNAUTHORIZED(403, 1008, 769),
    CLIENT_FORBIDDEN(403, 1008, 771),
    CLIENT_TIMEOUT(408, 1002, 776),
    CLIENT_OVERRUN(413, 1009, 781),
    CLIENT_BAD_TYPE(415, 1003, 783),
    CLIENT_TOO_MANY(429, 1008, 797);

    private final int http_code;
    private final int websocket_code;
    private final int guac_code;

    private GuacamoleStatus(int http_code, int websocket_code, int guac_code) {
        this.http_code = http_code;
        this.websocket_code = websocket_code;
        this.guac_code = guac_code;
    }

    public int getHttpStatusCode() {
        return this.http_code;
    }

    public int getWebSocketCode() {
        return this.websocket_code;
    }

    public int getGuacamoleStatusCode() {
        return this.guac_code;
    }

    public static GuacamoleStatus fromGuacamoleStatusCode(int code) {
        for (GuacamoleStatus status : GuacamoleStatus.values()) {
            if (status.getGuacamoleStatusCode() != code) continue;
            return status;
        }
        return null;
    }
}

