/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.protocol;

import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.io.GuacamoleReader;
import org.apache.guacamole.protocol.GuacamoleFilter;
import org.apache.guacamole.protocol.GuacamoleInstruction;

public class FilteredGuacamoleReader
implements GuacamoleReader {
    private final GuacamoleReader reader;
    private final GuacamoleFilter filter;

    public FilteredGuacamoleReader(GuacamoleReader reader, GuacamoleFilter filter) {
        this.reader = reader;
        this.filter = filter;
    }

    @Override
    public boolean available() throws GuacamoleException {
        return this.reader.available();
    }

    @Override
    public char[] read() throws GuacamoleException {
        GuacamoleInstruction filteredInstruction = this.readInstruction();
        if (filteredInstruction == null) {
            return null;
        }
        return filteredInstruction.toString().toCharArray();
    }

    @Override
    public GuacamoleInstruction readInstruction() throws GuacamoleException {
        GuacamoleInstruction unfilteredInstruction;
        GuacamoleInstruction filteredInstruction;
        do {
            if ((unfilteredInstruction = this.reader.readInstruction()) != null) continue;
            return null;
        } while ((filteredInstruction = this.filter.filter(unfilteredInstruction)) == null);
        return filteredInstruction;
    }
}

