/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.io;

import java.io.IOException;
import java.io.Reader;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import org.apache.guacamole.GuacamoleConnectionClosedException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.GuacamoleUpstreamTimeoutException;
import org.apache.guacamole.io.GuacamoleReader;
import org.apache.guacamole.protocol.GuacamoleInstruction;

public class ReaderGuacamoleReader
implements GuacamoleReader {
    private Reader input;
    private int parseStart;
    private char[] buffer = new char[20480];
    private int usedLength = 0;

    public ReaderGuacamoleReader(Reader input) {
        this.input = input;
    }

    @Override
    public boolean available() throws GuacamoleException {
        try {
            return this.input.ready() || this.usedLength != 0;
        }
        catch (IOException e) {
            throw new GuacamoleServerException(e);
        }
    }

    @Override
    public char[] read() throws GuacamoleException {
        try {
            while (true) {
                int numRead;
                int elementLength = 0;
                int i = this.parseStart;
                while (i < this.usedLength) {
                    char readChar;
                    if ((readChar = this.buffer[i++]) >= '0' && readChar <= '9') {
                        elementLength = elementLength * 10 + readChar - 48;
                        continue;
                    }
                    if (readChar == '.') {
                        if (i + elementLength >= this.usedLength) break;
                        char terminator = this.buffer[i + elementLength];
                        elementLength = 0;
                        this.parseStart = i += elementLength + 1;
                        if (terminator == ';') {
                            char[] instruction = new char[i];
                            System.arraycopy(this.buffer, 0, instruction, 0, i);
                            this.usedLength -= i;
                            this.parseStart = 0;
                            System.arraycopy(this.buffer, i, this.buffer, 0, this.usedLength);
                            return instruction;
                        }
                        if (terminator == ',') continue;
                        throw new GuacamoleServerException("Element terminator of instruction was not ';' nor ','");
                    }
                    throw new GuacamoleServerException("Non-numeric character in element length.");
                }
                if (this.usedLength > this.buffer.length / 2) {
                    char[] biggerBuffer = new char[this.buffer.length * 2];
                    System.arraycopy(this.buffer, 0, biggerBuffer, 0, this.usedLength);
                    this.buffer = biggerBuffer;
                }
                if ((numRead = this.input.read(this.buffer, this.usedLength, this.buffer.length - this.usedLength)) == -1) {
                    return null;
                }
                this.usedLength += numRead;
            }
        }
        catch (SocketTimeoutException e) {
            throw new GuacamoleUpstreamTimeoutException("Connection to guacd timed out.", e);
        }
        catch (SocketException e) {
            throw new GuacamoleConnectionClosedException("Connection to guacd is closed.", e);
        }
        catch (IOException e) {
            throw new GuacamoleServerException(e);
        }
    }

    @Override
    public GuacamoleInstruction readInstruction() throws GuacamoleException {
        char[] instructionBuffer = this.read();
        if (instructionBuffer == null) {
            return null;
        }
        LinkedList<String> elements = new LinkedList<String>();
        for (int elementStart = 0; elementStart < instructionBuffer.length; ++elementStart) {
            int lengthEnd = -1;
            for (int i = elementStart; i < instructionBuffer.length; ++i) {
                if (instructionBuffer[i] != '.') continue;
                lengthEnd = i;
                break;
            }
            if (lengthEnd == -1) {
                throw new GuacamoleServerException("Read returned incomplete instruction.");
            }
            int length = Integer.parseInt(new String(instructionBuffer, elementStart, lengthEnd - elementStart));
            elementStart = lengthEnd + 1;
            String element = new String(instructionBuffer, elementStart, length);
            elements.addLast(element);
            char terminator = instructionBuffer[elementStart += length];
            if (terminator != ';') continue;
            break;
        }
        String opcode = (String)elements.removeFirst();
        GuacamoleInstruction instruction = new GuacamoleInstruction(opcode, elements.toArray(new String[elements.size()]));
        return instruction;
    }
}

