/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.repository;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Version;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.system.repository.AbstractRepository;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class Maven1Repository
extends AbstractRepository
implements WritableListableRepository {
    private static final Pattern MAVEN_1_PATTERN = Pattern.compile("(.+)/(.+)s/(.+)-([0-9].+)\\.([^0-9]+)");
    public static final GBeanInfo GBEAN_INFO;

    public Maven1Repository(URI root, ServerInfo serverInfo) {
        super(root, serverInfo);
    }

    public Maven1Repository(File rootFile) {
        super(rootFile);
    }

    public File getLocation(Artifact artifact) {
        File path = new File(this.rootFile, artifact.getGroupId());
        path = new File(path, artifact.getType() + "s");
        String ext = artifact.getType();
        if (ext.equals("ejb")) {
            ext = "jar";
        }
        path = new File(path, artifact.getArtifactId() + "-" + artifact.getVersion() + "." + ext);
        return path;
    }

    public SortedSet list(Artifact query) {
        TreeSet<Artifact> artifacts;
        block3: {
            block2: {
                artifacts = new TreeSet<Artifact>();
                if (query.getGroupId() == null || query.getArtifactId() == null || query.getType() == null) break block2;
                File path = new File(this.rootFile, query.getGroupId());
                File[] files = (path = new File(path, query.getType() + "s")).listFiles();
                if (files == null) break block3;
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    String fileName = file.getName();
                    if (!fileName.startsWith(query.getArtifactId() + "-") || !fileName.endsWith("." + query.getType())) continue;
                    String version = fileName.substring(query.getArtifactId().length() + 1);
                    version = version.substring(0, version.length() - 1 - query.getType().length());
                    if (query.getVersion() != null && !query.getVersion().toString().equals(version)) continue;
                    artifacts.add(new Artifact(query.getGroupId(), query.getArtifactId(), version, query.getType()));
                }
                break block3;
            }
            SortedSet set = this.list();
            String targetGroup = query.getGroupId();
            String targetArtifact = query.getArtifactId();
            Version targetVersion = query.getVersion();
            String targetType = query.getType();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Artifact candidate = (Artifact)it.next();
                if (targetGroup != null && !targetGroup.equals(candidate.getGroupId()) || targetArtifact != null && !targetArtifact.equals(candidate.getArtifactId()) || targetType != null && !targetType.equals(candidate.getType()) || targetVersion != null && !targetVersion.equals((Object)candidate.getVersion())) continue;
                artifacts.add(candidate);
            }
        }
        return artifacts;
    }

    public SortedSet list() {
        TreeSet<Artifact> artifacts = new TreeSet<Artifact>();
        String[] names = this.getFiles(this.rootFile, "");
        Matcher matcher = MAVEN_1_PATTERN.matcher("");
        for (int i = 0; i < names.length; ++i) {
            matcher.reset(names[i]);
            if (matcher.matches()) {
                String groupId = matcher.group(1);
                String artifactId = matcher.group(3);
                String version = matcher.group(4);
                String type = matcher.group(2);
                if (groupId.indexOf(47) > -1 || artifactId.indexOf(47) > -1 || type.indexOf(47) > -1 || version.indexOf(47) > -1) {
                    log.warn((Object)("could not resolve URI for malformed repository entry: " + names[i] + " - the filename should look like: <groupId>/<type>s/<artifactId>-<version>.<type>   " + "Perhaps you put in a file without a version number in the name?"));
                    continue;
                }
                artifacts.add(new Artifact(groupId, artifactId, version, type));
                continue;
            }
            log.warn((Object)("could not resolve URI for malformed repository entry: " + names[i] + " - the filename should look like: <groupId>/<type>s/<artifactId>-<version>.<type>   " + "Perhaps you put in a file without a version number in the name?"));
        }
        return artifacts;
    }

    public String[] getFiles(File base, String prefix) {
        if (!base.canRead() || !base.isDirectory()) {
            throw new IllegalArgumentException(base.getAbsolutePath());
        }
        ArrayList<String> list = new ArrayList<String>();
        File[] hits = base.listFiles();
        for (int i = 0; i < hits.length; ++i) {
            File hit = hits[i];
            if (!hit.canRead()) continue;
            if (hit.isDirectory()) {
                list.addAll(Arrays.asList(this.getFiles(hit, prefix.equals("") ? hit.getName() : prefix + "/" + hit.getName())));
                continue;
            }
            list.add(prefix.equals("") ? hit.getName() : prefix + "/" + hit.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)Maven1Repository.class, (String)"Repository");
        infoFactory.addAttribute("root", URI.class, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addInterface(Maven1Repository.class);
        infoFactory.setConstructor(new String[]{"root", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

