/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.properties;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class SystemProperties {
    public static final GBeanInfo GBEAN_INFO;

    public SystemProperties(Properties properties, Properties pathProperties, ServerInfo serverInfo) {
        String propertyValue;
        String propertyName;
        Map.Entry<Object, Object> entry;
        Iterator<Map.Entry<Object, Object>> iterator;
        if (properties != null) {
            iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                propertyName = (String)entry.getKey();
                propertyValue = (String)entry.getValue();
                if (System.getProperty(propertyName) != null) continue;
                System.setProperty(propertyName, propertyValue);
            }
        }
        if (pathProperties != null && serverInfo != null) {
            iterator = pathProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                propertyName = (String)entry.getKey();
                propertyValue = (String)entry.getValue();
                propertyValue = serverInfo.resolveServerPath(propertyValue);
                if (System.getProperty(propertyName) != null) continue;
                System.setProperty(propertyName, propertyValue);
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)SystemProperties.class, (String)"GBean");
        infoBuilder.addAttribute("systemProperties", Properties.class, true, true);
        infoBuilder.addAttribute("systemPathProperties", Properties.class, true, true);
        infoBuilder.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoBuilder.setConstructor(new String[]{"systemProperties", "systemPathProperties", "ServerInfo"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

