/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.system.plugin.PluginRepositoryList;

public class PluginRepositoryDownloader
implements PluginRepositoryList {
    private static final Log log = LogFactory.getLog((Class)PluginRepositoryDownloader.class);
    private List downloadRepositories = new ArrayList();
    private List userRepositories = new ArrayList();
    private Kernel kernel;
    private AbstractName name;
    private URL repositoryList;
    public static final GBeanInfo GBEAN_INFO;

    public PluginRepositoryDownloader(List downloadRepositories, List userRepositories, URL repositoryList, Kernel kernel, AbstractName name) {
        if (downloadRepositories != null) {
            this.downloadRepositories = downloadRepositories;
        }
        if (userRepositories != null) {
            this.userRepositories = userRepositories;
        }
        this.repositoryList = repositoryList;
        this.kernel = kernel;
        this.name = name;
    }

    public void setDownloadRepositories(List downloadRepositories) {
        this.downloadRepositories = downloadRepositories;
        if (this.downloadRepositories == null) {
            this.downloadRepositories = new ArrayList();
        }
    }

    public void setUserRepositories(List userRepositories) {
        this.userRepositories = userRepositories;
        if (this.userRepositories == null) {
            this.userRepositories = new ArrayList();
        }
    }

    public URL[] getRepositories() {
        String url;
        int i;
        ArrayList<URL> list = new ArrayList<URL>();
        for (i = 0; i < this.downloadRepositories.size(); ++i) {
            url = (String)this.downloadRepositories.get(i);
            try {
                list.add(new URL(url.trim()));
                continue;
            }
            catch (MalformedURLException e) {
                log.error((Object)("Unable to format plugin repository URL " + url), (Throwable)e);
            }
        }
        for (i = 0; i < this.userRepositories.size(); ++i) {
            url = (String)this.userRepositories.get(i);
            try {
                list.add(new URL(url.trim()));
                continue;
            }
            catch (MalformedURLException e) {
                log.error((Object)("Unable to format plugin repository URL " + url), (Throwable)e);
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(this.repositoryList.openStream()));
            ArrayList<String> list = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                list.add(line);
            }
            in.close();
            in = null;
            this.kernel.setAttribute(this.name, "downloadRepositories", list);
        }
        catch (Exception e) {
            log.error((Object)"Unable to save download repositories", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addUserRepository(URL repo) {
        this.userRepositories.add(repo.toString());
        try {
            this.kernel.setAttribute(this.name, "userRepositories", (Object)this.userRepositories);
        }
        catch (Exception e) {
            log.error((Object)"Unable to save user repositories", (Throwable)e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)PluginRepositoryDownloader.class);
        infoFactory.addAttribute("downloadRepositories", List.class, true);
        infoFactory.addAttribute("userRepositories", List.class, true);
        infoFactory.addAttribute("repositoryList", URL.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false);
        infoFactory.addInterface(PluginRepositoryList.class);
        infoFactory.setConstructor(new String[]{"downloadRepositories", "userRepositories", "repositoryList", "kernel", "abstractName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

