/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.security.auth.login.FailedLoginException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.DefaultArtifactResolver;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.repository.Version;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.apache.geronimo.system.configuration.ConfigurationStoreUtil;
import org.apache.geronimo.system.configuration.GBeanOverride;
import org.apache.geronimo.system.configuration.PluginAttributeStore;
import org.apache.geronimo.system.plugin.DownloadPoller;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.PluginInstaller;
import org.apache.geronimo.system.plugin.PluginList;
import org.apache.geronimo.system.plugin.PluginMetadata;
import org.apache.geronimo.system.plugin.SnapshotVersion;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.system.threads.ThreadPool;
import org.apache.geronimo.util.encoders.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PluginInstallerGBean
implements PluginInstaller {
    private static final Log log = LogFactory.getLog((Class)PluginInstallerGBean.class);
    private static int counter;
    private ConfigurationManager configManager;
    private WritableListableRepository writeableRepo;
    private ConfigurationStore configStore;
    private ArtifactResolver resolver;
    private ServerInfo serverInfo;
    private Map asyncKeys;
    private ThreadPool threadPool;
    private PluginAttributeStore attributeStore;
    public static final GBeanInfo GBEAN_INFO;

    public PluginInstallerGBean(ConfigurationManager configManager, WritableListableRepository repository, ConfigurationStore configStore, ServerInfo serverInfo, ThreadPool threadPool, PluginAttributeStore store) {
        this.configManager = configManager;
        this.writeableRepo = repository;
        this.configStore = configStore;
        this.serverInfo = serverInfo;
        this.threadPool = threadPool;
        this.resolver = new DefaultArtifactResolver(null, (ListableRepository)this.writeableRepo);
        this.asyncKeys = Collections.synchronizedMap(new HashMap());
        this.attributeStore = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getInstalledPlugins() {
        SortedSet artifacts = this.writeableRepo.list();
        HashMap plugins = new HashMap();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact configId = (Artifact)i.next();
            File dir = this.writeableRepo.getLocation(configId);
            if (dir.isDirectory()) {
                File xml;
                File meta = new File(dir, "META-INF");
                if (!meta.isDirectory() || !meta.canRead() || !(xml = new File(meta, "geronimo-plugin.xml")).isFile() || !xml.canRead() || xml.length() == 0L) continue;
                this.readNameAndID(xml, plugins);
                continue;
            }
            if (!dir.isFile() || !dir.canRead()) {
                throw new IllegalStateException("Cannot read artifact dir " + dir.getAbsolutePath());
            }
            try {
                JarFile jar = new JarFile(dir);
                try {
                    ZipEntry entry = jar.getEntry("META-INF/geronimo-plugin.xml");
                    if (entry == null) continue;
                    InputStream in = jar.getInputStream(entry);
                    this.readNameAndID(in, plugins);
                    in.close();
                }
                finally {
                    jar.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Unable to read JAR file " + dir.getAbsolutePath()), (Throwable)e);
            }
        }
        return plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PluginMetadata getPluginMetadata(Artifact moduleId) {
        if (this.configManager != null ? !this.configManager.isConfiguration(moduleId) : !this.configStore.containsConfiguration(moduleId)) {
            return null;
        }
        File dir = this.writeableRepo.getLocation(moduleId);
        String source = dir.getAbsolutePath();
        try {
            Document doc;
            ConfigurationData configData;
            if (dir.isDirectory()) {
                File meta = new File(dir, "META-INF");
                if (!meta.isDirectory()) return null;
                if (!meta.canRead()) {
                    return null;
                }
                File xml = new File(meta, "geronimo-plugin.xml");
                configData = this.configStore.loadConfiguration(moduleId);
                if (!xml.isFile()) return this.createDefaultMetadata(configData);
                if (!xml.canRead()) return this.createDefaultMetadata(configData);
                if (xml.length() == 0L) {
                    return this.createDefaultMetadata(configData);
                }
                source = xml.getAbsolutePath();
                DocumentBuilder builder = PluginInstallerGBean.createDocumentBuilder();
                doc = builder.parse(xml);
            } else {
                if (!dir.isFile()) throw new IllegalStateException("Cannot read configuration " + dir.getAbsolutePath());
                if (!dir.canRead()) {
                    throw new IllegalStateException("Cannot read configuration " + dir.getAbsolutePath());
                }
                configData = this.configStore.loadConfiguration(moduleId);
                JarFile jar = new JarFile(dir);
                try {
                    ZipEntry entry = jar.getEntry("META-INF/geronimo-plugin.xml");
                    if (entry == null) {
                        PluginMetadata builder = this.createDefaultMetadata(configData);
                        return builder;
                    }
                    source = dir.getAbsolutePath() + "#META-INF/geronimo-plugin.xml";
                    InputStream in = jar.getInputStream(entry);
                    DocumentBuilder builder = PluginInstallerGBean.createDocumentBuilder();
                    doc = builder.parse(in);
                    in.close();
                }
                finally {
                    jar.close();
                }
            }
            PluginMetadata result = this.loadPluginMetadata(doc, source);
            this.overrideDependencies(configData, result);
            return result;
        }
        catch (InvalidConfigException e) {
            e.printStackTrace();
            log.warn((Object)("Unable to generate metadata for " + moduleId), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn((Object)("Invalid XML at " + source), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePluginMetadata(PluginMetadata metadata) {
        block23: {
            File dir = this.writeableRepo.getLocation(metadata.getModuleId());
            if (dir == null) {
                throw new IllegalArgumentException(metadata.getModuleId() + " is not installed!");
            }
            if (!dir.isDirectory()) {
                try {
                    File temp = new File(dir.getParentFile(), dir.getName() + ".temp");
                    JarFile input = new JarFile(dir);
                    Manifest manifest = input.getManifest();
                    JarOutputStream out = manifest == null ? new JarOutputStream(new BufferedOutputStream(new FileOutputStream(temp))) : new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(temp)), manifest);
                    Enumeration<JarEntry> en = input.entries();
                    byte[] buf = new byte[4096];
                    while (en.hasMoreElements()) {
                        int count;
                        JarEntry entry = en.nextElement();
                        if (entry.getName().equals("META-INF/geronimo-plugin.xml")) {
                            entry = new JarEntry(entry.getName());
                            out.putNextEntry(entry);
                            Document doc = PluginInstallerGBean.writePluginMetadata(metadata);
                            TransformerFactory xfactory = XmlUtil.newTransformerFactory();
                            Transformer xform = xfactory.newTransformer();
                            xform.setOutputProperty("indent", "yes");
                            xform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                            xform.transform(new DOMSource(doc), new StreamResult(out));
                            continue;
                        }
                        if (entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                        out.putNextEntry(entry);
                        InputStream in = input.getInputStream(entry);
                        while ((count = in.read(buf)) > -1) {
                            out.write(buf, 0, count);
                        }
                        in.close();
                        out.closeEntry();
                    }
                    out.flush();
                    out.close();
                    input.close();
                    if (!dir.delete()) {
                        throw new IOException("Unable to delete old plugin at " + dir.getAbsolutePath());
                    }
                    if (!temp.renameTo(dir)) {
                        throw new IOException("Unable to move new plugin " + temp.getAbsolutePath() + " to " + dir.getAbsolutePath());
                    }
                    break block23;
                }
                catch (Exception e) {
                    log.error((Object)"Unable to update plugin metadata", (Throwable)e);
                    throw new RuntimeException("Unable to update plugin metadata", e);
                }
            }
            File meta = new File(dir, "META-INF");
            if (!meta.isDirectory() || !meta.canRead()) {
                throw new IllegalArgumentException(metadata.getModuleId() + " is not a plugin!");
            }
            File xml = new File(meta, "geronimo-plugin.xml");
            FileOutputStream fos = null;
            try {
                if (!xml.isFile() && !xml.createNewFile()) {
                    throw new RuntimeException("Cannot create plugin metadata file for " + metadata.getModuleId());
                }
                Document doc = PluginInstallerGBean.writePluginMetadata(metadata);
                TransformerFactory xfactory = XmlUtil.newTransformerFactory();
                Transformer xform = xfactory.newTransformer();
                xform.setOutputProperty("indent", "yes");
                xform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                fos = new FileOutputStream(xml);
                StreamResult sr = new StreamResult(fos);
                xform.transform(new DOMSource(doc), sr);
            }
            catch (Exception e) {
                log.error((Object)("Unable to save plugin metadata for " + metadata.getModuleId()), (Throwable)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }

    public PluginList listPlugins(URL mavenRepository, String username, String password) throws IOException, FailedLoginException {
        String repository = mavenRepository.toString();
        if (!repository.endsWith("/")) {
            repository = repository + "/";
        }
        URL url = new URL(repository + "geronimo-plugins.xml");
        try {
            InputStream in = PluginInstallerGBean.openStream(null, new URL[]{url}, username, password, null).getStream();
            return this.loadPluginList(mavenRepository, in);
        }
        catch (MissingDependencyException e) {
            log.error((Object)("Cannot find plugin index at site " + url));
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Unable to load repository configuration data", (Throwable)e);
            return null;
        }
    }

    public DownloadResults install(PluginList pluginsToInstall, String username, String password) {
        DownloadResults results = new DownloadResults();
        this.install(pluginsToInstall, username, password, (DownloadPoller)results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(PluginList pluginsToInstall, String username, String password, DownloadPoller poller) {
        try {
            PluginMetadata metadata;
            int i;
            HashMap<Artifact, PluginMetadata> metaMap = new HashMap<Artifact, PluginMetadata>();
            for (i = 0; i < pluginsToInstall.getPlugins().length; ++i) {
                metadata = pluginsToInstall.getPlugins()[i];
                this.validatePlugin(metadata);
                if (metadata.getModuleId() == null) continue;
                metaMap.put(metadata.getModuleId(), metadata);
            }
            for (i = 0; i < pluginsToInstall.getPlugins().length; ++i) {
                metadata = pluginsToInstall.getPlugins()[i];
                ArrayList<Artifact> obsoletes = new ArrayList<Artifact>();
                for (int j = 0; j < metadata.getObsoletes().length; ++j) {
                    String name = metadata.getObsoletes()[j];
                    Artifact obsolete = Artifact.create((String)name);
                    Artifact[] list = this.configManager.getArtifactResolver().queryArtifacts(obsolete);
                    for (int k = 0; k < list.length; ++k) {
                        Artifact artifact = list[k];
                        if (!this.configManager.isLoaded(artifact)) continue;
                        if (this.configManager.isRunning(artifact)) {
                            this.configManager.stopConfiguration(artifact);
                        }
                        this.configManager.unloadConfiguration(artifact);
                        obsoletes.add(artifact);
                    }
                }
                HashSet working = new HashSet();
                if (metadata.getModuleId() != null) {
                    URL[] repos = pluginsToInstall.getRepositories();
                    if (metadata.getRepositories().length > 0) {
                        repos = metadata.getRepositories();
                    }
                    this.downloadArtifact(metadata.getModuleId(), metaMap, repos, username, password, new ResultsFileWriteMonitor(poller), working, false);
                } else {
                    String[] deps = metadata.getDependencies();
                    for (int j = 0; j < deps.length; ++j) {
                        String dep = deps[j];
                        Artifact entry = Artifact.create((String)dep);
                        URL[] repos = pluginsToInstall.getRepositories();
                        if (metadata.getRepositories().length > 0) {
                            repos = metadata.getRepositories();
                        }
                        this.downloadArtifact(entry, metaMap, repos, username, password, new ResultsFileWriteMonitor(poller), working, false);
                    }
                }
                for (int j = 0; j < obsoletes.size(); ++j) {
                    Artifact artifact = (Artifact)obsoletes.get(j);
                    this.configManager.uninstallConfiguration(artifact);
                }
            }
            for (i = 0; i < pluginsToInstall.getPlugins().length; ++i) {
                metadata = pluginsToInstall.getPlugins()[i];
                for (int j = 0; j < metadata.getForceStart().length; ++j) {
                    String id = metadata.getForceStart()[j];
                    Artifact artifact = Artifact.create((String)id);
                    if (!this.configManager.isConfiguration(artifact)) continue;
                    poller.setCurrentFilePercent(-1);
                    poller.setCurrentMessage("Starting " + artifact);
                    this.configManager.loadConfiguration(artifact);
                    this.configManager.startConfiguration(artifact);
                }
            }
        }
        catch (Exception e) {
            poller.setFailure(e);
        }
        finally {
            poller.setFinished();
        }
    }

    public Object startInstall(final PluginList pluginsToInstall, final String username, final String password) {
        Object key = PluginInstallerGBean.getNextKey();
        final DownloadResults results = new DownloadResults();
        Runnable work = new Runnable(){

            public void run() {
                PluginInstallerGBean.this.install(pluginsToInstall, username, password, (DownloadPoller)results);
            }
        };
        this.asyncKeys.put(key, results);
        try {
            this.threadPool.execute("Configuration Installer", work);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to start work", e);
        }
        return key;
    }

    public Object startInstall(final File carFile, final String username, final String password) {
        Object key = PluginInstallerGBean.getNextKey();
        final DownloadResults results = new DownloadResults();
        Runnable work = new Runnable(){

            public void run() {
                PluginInstallerGBean.this.install(carFile, username, password, (DownloadPoller)results);
            }
        };
        this.asyncKeys.put(key, results);
        try {
            this.threadPool.execute("Configuration Installer", work);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to start work", e);
        }
        return key;
    }

    public DownloadResults checkOnInstall(Object key) {
        DownloadResults results = (DownloadResults)this.asyncKeys.get(key);
        if ((results = results.duplicate()).isFinished()) {
            this.asyncKeys.remove(key);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(File carFile, String username, String password, DownloadPoller poller) {
        try {
            PluginMetadata data = this.loadCARFile(carFile, true);
            if (data == null) {
                throw new IllegalArgumentException("Invalid Configuration Archive " + carFile.getAbsolutePath() + " see server log for details");
            }
            this.validatePlugin(data);
            if (data.getModuleId() != null) {
                ResultsFileWriteMonitor monitor = new ResultsFileWriteMonitor(poller);
                this.writeableRepo.copyToRepository(carFile, data.getModuleId(), (FileWriteMonitor)monitor);
                this.installConfigXMLData(data.getModuleId(), data);
                if (data.getFilesToCopy() != null) {
                    this.extractPluginFiles(data.getModuleId(), data, monitor);
                }
            }
            this.install(new PluginList(data.getRepositories(), new PluginMetadata[]{data}), username, password, poller);
        }
        catch (Exception e) {
            poller.setFailure(e);
        }
        finally {
            poller.setFinished();
        }
    }

    private void validatePlugin(PluginMetadata metadata) throws MissingDependencyException {
        int i;
        if (metadata.getModuleId() != null && this.configManager.isRunning(metadata.getModuleId())) {
            boolean upgrade = false;
            for (i = 0; i < metadata.getObsoletes().length; ++i) {
                String obsolete = metadata.getObsoletes()[i];
                Artifact test = Artifact.create((String)obsolete);
                if (!test.matches(metadata.getModuleId())) continue;
                upgrade = true;
                break;
            }
            if (!upgrade) {
                throw new IllegalArgumentException("Configuration " + metadata.getModuleId() + " is already running!");
            }
        }
        PluginMetadata.Prerequisite[] prereqs = metadata.getPrerequisites();
        for (i = 0; i < prereqs.length; ++i) {
            PluginMetadata.Prerequisite prereq = prereqs[i];
            if (this.resolver.queryArtifacts(prereq.getModuleId()).length != 0) continue;
            throw new MissingDependencyException("Required configuration '" + prereq.getModuleId() + "' is not installed.");
        }
        if (metadata.getGeronimoVersions().length > 0 && !this.checkGeronimoVersions(metadata.getGeronimoVersions())) {
            throw new MissingDependencyException("Cannot install plugin " + metadata.getModuleId() + " on Geronimo " + this.serverInfo.getVersion());
        }
        if (metadata.getJvmVersions().length > 0 && !this.checkJVMVersions(metadata.getJvmVersions())) {
            throw new MissingDependencyException("Cannot install plugin " + metadata.getModuleId() + " on JVM " + System.getProperty("java.version"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadArtifact(Artifact configID, Map metadata, URL[] repos, String username, String password, ResultsFileWriteMonitor monitor, Set soFar, boolean dependency) throws IOException, FailedLoginException, MissingDependencyException {
        PluginMetadata currentPlugin;
        if (soFar.contains(configID)) {
            return;
        }
        soFar.add(configID);
        boolean pluginWasInstalled = false;
        Artifact[] matches = this.configManager.getArtifactResolver().queryArtifacts(configID);
        if (matches.length == 0) {
            monitor.getResults().setCurrentMessage("Downloading " + configID);
            monitor.getResults().setCurrentFilePercent(-1);
            OpenResult result = PluginInstallerGBean.openStream(configID, repos, username, password, monitor);
            try {
                String actual;
                PluginMetadata.Hash hash;
                File tempFile = this.downloadFile(result, monitor);
                PluginMetadata pluginData = (PluginMetadata)metadata.get(configID);
                PluginMetadata.Hash hash2 = hash = pluginData == null ? null : pluginData.getHash();
                if (hash != null && !(actual = ConfigurationStoreUtil.getActualChecksum(tempFile, hash.getType())).equals(hash.getValue())) {
                    throw new IOException("File download incorrect (expected " + hash.getType() + " hash " + hash.getValue() + " but got " + actual + ")");
                }
                if (pluginData == null) {
                    try {
                        pluginData = this.loadCARFile(tempFile, false);
                    }
                    catch (Exception e) {
                        throw new IOException("Unable to read plugin metadata: " + e.getMessage());
                    }
                }
                if (pluginData != null) {
                    this.validatePlugin(pluginData);
                }
                monitor.getResults().setCurrentMessage("Copying " + result.getConfigID() + " to the repository");
                this.writeableRepo.copyToRepository(tempFile, result.getConfigID(), (FileWriteMonitor)monitor);
                if (!tempFile.delete()) {
                    log.warn((Object)("Unable to delete temporary download file " + tempFile.getAbsolutePath()));
                    tempFile.deleteOnExit();
                }
                this.installConfigXMLData(result.getConfigID(), pluginData);
                if (dependency) {
                    monitor.getResults().addDependencyInstalled(configID);
                    configID = result.getConfigID();
                } else {
                    configID = result.getConfigID();
                    monitor.getResults().addInstalledConfigID(configID);
                }
                pluginWasInstalled = true;
            }
            finally {
                result.getStream().close();
            }
        }
        if (dependency) {
            monitor.getResults().addDependencyPresent(configID);
        } else {
            monitor.getResults().addInstalledConfigID(configID);
        }
        try {
            ConfigurationData data = null;
            if (!configID.isResolved()) {
                for (int i = matches.length - 1; i >= 0; --i) {
                    Artifact match = matches[i];
                    if (!this.configStore.containsConfiguration(match) || !this.configManager.isRunning(match)) continue;
                    return;
                }
                configID = matches[matches.length - 1];
            }
            if (this.configStore.containsConfiguration(configID)) {
                if (this.configManager.isRunning(configID)) {
                    return;
                }
                data = this.configStore.loadConfiguration(configID);
            }
            Dependency[] dependencies = data == null ? PluginInstallerGBean.getDependencies((Repository)this.writeableRepo, configID) : PluginInstallerGBean.getDependencies(data);
            for (int i = 0; i < dependencies.length; ++i) {
                Dependency dep = dependencies[i];
                Artifact artifact = dep.getArtifact();
                this.downloadArtifact(artifact, metadata, repos, username, password, monitor, soFar, true);
            }
        }
        catch (NoSuchConfigException e) {
            throw new IllegalStateException("Installed configuration into repository but ConfigStore does not see it: " + e.getMessage());
        }
        catch (InvalidConfigException e) {
            throw new IllegalStateException("Installed configuration into repository but ConfigStore cannot load it: " + e.getMessage());
        }
        PluginMetadata pluginMetadata = currentPlugin = this.configManager.isConfiguration(configID) ? this.getPluginMetadata(configID) : null;
        if (pluginWasInstalled && currentPlugin != null && currentPlugin.getFilesToCopy() != null) {
            this.extractPluginFiles(configID, currentPlugin, monitor);
        }
    }

    private void extractPluginFiles(Artifact configID, PluginMetadata currentPlugin, ResultsFileWriteMonitor monitor) throws IOException {
        for (int i = 0; i < currentPlugin.getFilesToCopy().length; ++i) {
            File targetDir;
            Set set;
            PluginMetadata.CopyFile data = currentPlugin.getFilesToCopy()[i];
            monitor.getResults().setCurrentFilePercent(-1);
            monitor.getResults().setCurrentFile(data.getSourceFile());
            monitor.getResults().setCurrentMessage("Copying " + data.getSourceFile() + " from plugin to Geronimo installation");
            try {
                set = this.configStore.resolve(configID, null, data.getSourceFile());
            }
            catch (NoSuchConfigException e) {
                throw new IllegalStateException("Unable to identify module " + configID + " to copy files from");
            }
            if (set.size() == 0) {
                log.error((Object)("Installed configuration into repository but cannot locate file to copy " + data.getSourceFile()));
                continue;
            }
            File file = targetDir = data.isRelativeToVar() ? this.serverInfo.resolveServer("var/" + data.getDestDir()) : this.serverInfo.resolve(data.getDestDir());
            if (!targetDir.isDirectory()) {
                log.error((Object)("Plugin install cannot write file " + data.getSourceFile() + " to " + data.getDestDir() + " because " + targetDir.getAbsolutePath() + " is not a directory"));
                continue;
            }
            if (!targetDir.canWrite()) {
                log.error((Object)("Plugin install cannot write file " + data.getSourceFile() + " to " + data.getDestDir() + " because " + targetDir.getAbsolutePath() + " is not writable"));
                continue;
            }
            Iterator it = set.iterator();
            while (it.hasNext()) {
                File target;
                URL url = (URL)it.next();
                String path = url.getPath();
                if (path.lastIndexOf(47) > -1) {
                    path = path.substring(path.lastIndexOf(47));
                }
                if (!(target = new File(targetDir, path)).exists() && !target.createNewFile()) {
                    log.error((Object)("Plugin install cannot create new file " + target.getAbsolutePath()));
                    continue;
                }
                if (!target.canWrite()) {
                    log.error((Object)("Plugin install cannot write to file " + target.getAbsolutePath()));
                    continue;
                }
                this.copyFile(url.openStream(), new FileOutputStream(target));
            }
        }
    }

    private void copyFile(InputStream in, FileOutputStream out) throws IOException {
        int count;
        byte[] buf = new byte[4096];
        while ((count = in.read(buf)) > -1) {
            out.write(buf, 0, count);
        }
        in.close();
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadFile(OpenResult result, ResultsFileWriteMonitor monitor) throws IOException {
        InputStream in = result.getStream();
        if (in == null) {
            throw new IllegalStateException();
        }
        FileOutputStream out = null;
        try {
            int count;
            monitor.writeStarted(result.getConfigID().toString(), result.fileSize);
            File file = File.createTempFile("geronimo-plugin-download-", ".tmp");
            out = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            int total = 0;
            while ((count = in.read(buf)) > -1) {
                out.write(buf, 0, count);
                monitor.writeProgress(total += count);
            }
            monitor.writeComplete(total);
            in.close();
            in = null;
            out.close();
            out = null;
            File file2 = file;
            return file2;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private static Dependency[] getDependencies(Repository repo, Artifact artifact) {
        LinkedHashSet set = repo.getDependencies(artifact);
        Dependency[] results = new Dependency[set.size()];
        int index = 0;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Artifact dep = (Artifact)it.next();
            results[index] = new Dependency(dep, ImportType.CLASSES);
            ++index;
        }
        return results;
    }

    private static Dependency[] getDependencies(ConfigurationData data) {
        ArrayList dependencies = new ArrayList(data.getEnvironment().getDependencies());
        Collection children = data.getChildConfigurations().values();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            ConfigurationData child = (ConfigurationData)it.next();
            dependencies.addAll(child.getEnvironment().getDependencies());
        }
        return dependencies.toArray(new Dependency[dependencies.size()]);
    }

    private static URL getURL(Artifact configId, URL repository) throws MalformedURLException {
        URL context = repository.toString().endsWith("/") ? repository : new URL(repository.toString() + "/");
        String qualifiedVersion = configId.getVersion().toString();
        if (configId.getVersion() instanceof SnapshotVersion) {
            SnapshotVersion ssVersion = (SnapshotVersion)configId.getVersion();
            String timestamp = ssVersion.getTimestamp();
            int buildNumber = ssVersion.getBuildNumber();
            if (timestamp != null && buildNumber != 0) {
                qualifiedVersion = qualifiedVersion.replaceAll("SNAPSHOT", timestamp + "-" + buildNumber);
            }
        }
        return new URL(context, configId.getGroupId().replace('.', '/') + "/" + configId.getArtifactId() + "/" + configId.getVersion() + "/" + configId.getArtifactId() + "-" + qualifiedVersion + "." + configId.getType());
    }

    private static OpenResult openStream(Artifact artifact, URL[] repos, String username, String password, ResultsFileWriteMonitor monitor) throws IOException, FailedLoginException, MissingDependencyException {
        URL url;
        InputStream in;
        if (!(artifact == null || artifact.isResolved() && artifact.getVersion().toString().indexOf("SNAPSHOT") < 0)) {
            artifact = PluginInstallerGBean.findArtifact(artifact, repos, username, password, monitor);
        }
        if (monitor != null) {
            monitor.getResults().setCurrentFilePercent(-1);
            monitor.getResults().setCurrentMessage("Downloading " + artifact + "...");
            monitor.setTotalBytes(-1);
        }
        LinkedList<URL> list = new LinkedList<URL>();
        list.addAll(Arrays.asList(repos));
        do {
            if (list.isEmpty()) {
                throw new MissingDependencyException("Unable to download dependency " + artifact);
            }
            if (monitor != null) {
                monitor.setTotalBytes(-1);
            }
            URL repository = (URL)list.removeFirst();
            url = artifact == null ? repository : PluginInstallerGBean.getURL(artifact, repository);
            log.debug((Object)("Attempting to download " + artifact + " from " + url));
        } while ((in = PluginInstallerGBean.connect(url, username, password, monitor)) == null);
        return new OpenResult(artifact, in, monitor == null ? -1 : monitor.getTotalBytes());
    }

    private static InputStream connect(URL url, String username, String password, ResultsFileWriteMonitor monitor) throws IOException, FailedLoginException {
        return PluginInstallerGBean.connect(url, username, password, monitor, null);
    }

    private static InputStream connect(URL url, String username, String password, ResultsFileWriteMonitor monitor, String method) throws IOException, FailedLoginException {
        URLConnection con = url.openConnection();
        if (con instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            if (method != null) {
                http.setRequestMethod(method);
            }
            http.connect();
            if (http.getResponseCode() == 401) {
                if (username == null || username.equals("")) {
                    throw new FailedLoginException("Server returned 401 " + http.getResponseMessage());
                }
                http = (HttpURLConnection)url.openConnection();
                http.setRequestProperty("Authorization", "Basic " + new String(Base64.encode((byte[])(username + ":" + password).getBytes())));
                if (method != null) {
                    http.setRequestMethod(method);
                }
                http.connect();
                if (http.getResponseCode() == 401) {
                    throw new FailedLoginException("Server returned 401 " + http.getResponseMessage());
                }
                if (http.getResponseCode() == 404) {
                    return null;
                }
                if (monitor != null && http.getContentLength() > 0) {
                    monitor.setTotalBytes(http.getContentLength());
                }
                return http.getInputStream();
            }
            if (http.getResponseCode() == 404) {
                return null;
            }
            if (monitor != null && http.getContentLength() > 0) {
                monitor.setTotalBytes(http.getContentLength());
            }
            return http.getInputStream();
        }
        if (username != null && !username.equals("")) {
            con.setRequestProperty("Authorization", "Basic " + new String(Base64.encode((byte[])(username + ":" + password).getBytes())));
            try {
                con.connect();
                if (monitor != null && con.getContentLength() > 0) {
                    monitor.setTotalBytes(con.getContentLength());
                }
                return con.getInputStream();
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        try {
            con.connect();
            if (monitor != null && con.getContentLength() > 0) {
                monitor.setTotalBytes(con.getContentLength());
            }
            return con.getInputStream();
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private static Artifact findArtifact(Artifact query, URL[] repos, String username, String password, ResultsFileWriteMonitor monitor) throws MissingDependencyException {
        if (query.getGroupId() == null || query.getArtifactId() == null || query.getType() == null) {
            throw new MissingDependencyException("No support yet for dependencies missing more than a version: " + query);
        }
        ArrayList<URL> list = new ArrayList<URL>();
        for (int i = 0; i < repos.length; ++i) {
            list.add(repos[i]);
        }
        Artifact result = null;
        for (int i = 0; i < list.size(); ++i) {
            URL url = (URL)list.get(i);
            try {
                result = PluginInstallerGBean.findArtifact(query, url, username, password, monitor);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to read from " + url), (Throwable)e);
            }
            if (result == null) continue;
            return result;
        }
        throw new MissingDependencyException("No repository has a valid artifact for " + query);
    }

    private static Artifact findArtifact(Artifact query, URL url, String username, String password, ResultsFileWriteMonitor monitor) throws IOException, FailedLoginException, ParserConfigurationException, SAXException {
        int i;
        monitor.getResults().setCurrentMessage("Searching for " + query + " at " + url);
        String base = query.getGroupId().replace('.', '/') + "/" + query.getArtifactId();
        String path = base + "/maven-metadata.xml";
        URL metaURL = new URL(url.toString().endsWith("/") ? url : new URL(url.toString() + "/"), path);
        InputStream in = PluginInstallerGBean.connect(metaURL, username, password, monitor);
        if (in == null) {
            return null;
        }
        DocumentBuilder builder = XmlUtil.newDocumentBuilderFactory().newDocumentBuilder();
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("versions");
        if (list.getLength() == 0) {
            return null;
        }
        list = ((Element)list.item(0)).getElementsByTagName("version");
        Object[] available = new Version[list.getLength()];
        for (i = 0; i < available.length; ++i) {
            available[i] = new Version(PluginInstallerGBean.getText(list.item(i)));
        }
        Arrays.sort(available);
        for (i = available.length - 1; i >= 0; --i) {
            Artifact verifiedArtifact;
            URL test;
            InputStream testStream;
            Object version = available[i];
            URL metadataURL = new URL(url.toString() + base + "/" + version + "/maven-metadata.xml");
            InputStream metadataStream = PluginInstallerGBean.connect(metadataURL, username, password, monitor);
            if (metadataStream != null) {
                DocumentBuilder metadatabuilder = XmlUtil.newDocumentBuilderFactory().newDocumentBuilder();
                Document metadatadoc = metadatabuilder.parse(metadataStream);
                NodeList snapshots = metadatadoc.getDocumentElement().getElementsByTagName("snapshot");
                if (snapshots.getLength() >= 1) {
                    Element snapshot = (Element)snapshots.item(0);
                    String[] timestamp = PluginInstallerGBean.getChildrenText(snapshot, "timestamp");
                    String[] buildNumber = PluginInstallerGBean.getChildrenText(snapshot, "buildNumber");
                    if (timestamp.length >= 1 && buildNumber.length >= 1) {
                        try {
                            SnapshotVersion snapshotVersion = new SnapshotVersion((Version)version);
                            snapshotVersion.setBuildNumber(Integer.parseInt(buildNumber[0]));
                            snapshotVersion.setTimestamp(timestamp[0]);
                            version = snapshotVersion;
                        }
                        catch (NumberFormatException nfe) {
                            log.warn((Object)("Could not create snapshot version for " + query));
                        }
                    }
                }
                metadataStream.close();
            }
            if ((testStream = PluginInstallerGBean.connect(test = PluginInstallerGBean.getURL(verifiedArtifact = new Artifact(query.getGroupId(), query.getArtifactId(), (Version)version, query.getType()), url), username, password, monitor, "HEAD")) != null) {
                testStream.close();
                return verifiedArtifact;
            }
            log.warn((Object)("Maven repository " + url + " listed artifact " + query + " version " + version + " but I couldn't find it at " + test));
        }
        return null;
    }

    private void readNameAndID(File xml, Map plugins) {
        try {
            SAXParserFactory factory = XmlUtil.newSAXParserFactory();
            SAXParser parser = factory.newSAXParser();
            PluginNameIDHandler handler = new PluginNameIDHandler();
            parser.parse(xml, (DefaultHandler)handler);
            if (handler.isComplete()) {
                plugins.put(handler.getName(), Artifact.create((String)handler.getID()));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Invalid XML at " + xml.getAbsolutePath()), (Throwable)e);
        }
    }

    private void readNameAndID(InputStream xml, Map plugins) {
        try {
            SAXParserFactory factory = XmlUtil.newSAXParserFactory();
            SAXParser parser = factory.newSAXParser();
            PluginNameIDHandler handler = new PluginNameIDHandler();
            parser.parse(xml, (DefaultHandler)handler);
            if (handler.isComplete()) {
                plugins.put(handler.getName(), Artifact.create((String)handler.getID()));
            }
        }
        catch (Exception e) {
            log.warn((Object)"Invalid XML", (Throwable)e);
        }
    }

    private void overrideDependencies(ConfigurationData data, PluginMetadata metadata) {
        PluginMetadata temp = this.createDefaultMetadata(data);
        metadata.setDependencies(temp.getDependencies());
    }

    private PluginMetadata createDefaultMetadata(ConfigurationData data) {
        PluginMetadata.Prerequisite[] prerequisiteArray;
        PluginMetadata meta = new PluginMetadata(data.getId().toString(), data.getId(), "Unknown", "Please provide a description", null, null, null, true, false);
        meta.setGeronimoVersions(new String[]{this.serverInfo.getVersion()});
        meta.setJvmVersions(new String[0]);
        meta.setLicenses(new PluginMetadata.License[0]);
        meta.setObsoletes(new String[]{new Artifact(data.getId().getGroupId(), data.getId().getArtifactId(), (Version)null, data.getId().getType()).toString()});
        meta.setFilesToCopy(new PluginMetadata.CopyFile[0]);
        ArrayList deps = new ArrayList();
        PluginMetadata.Prerequisite prereq = null;
        prereq = this.processDependencyList(data.getEnvironment().getDependencies(), prereq, deps);
        Map children = data.getChildConfigurations();
        Iterator it = children.values().iterator();
        while (it.hasNext()) {
            ConfigurationData child = (ConfigurationData)it.next();
            prereq = this.processDependencyList(child.getEnvironment().getDependencies(), prereq, deps);
        }
        meta.setDependencies(deps.toArray(new String[deps.size()]));
        if (prereq == null) {
            prerequisiteArray = new PluginMetadata.Prerequisite[]{};
        } else {
            PluginMetadata.Prerequisite[] prerequisiteArray2 = new PluginMetadata.Prerequisite[1];
            prerequisiteArray = prerequisiteArray2;
            prerequisiteArray2[0] = prereq;
        }
        meta.setPrerequisites(prerequisiteArray);
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginMetadata loadCARFile(File file, boolean definitelyCAR) throws IOException, ParserConfigurationException, SAXException {
        Document doc;
        if (!file.canRead()) {
            log.error((Object)("Cannot read from downloaded CAR file " + file.getAbsolutePath()));
            return null;
        }
        JarFile jar = new JarFile(file);
        try {
            JarEntry entry = jar.getJarEntry("META-INF/geronimo-plugin.xml");
            if (entry == null) {
                if (definitelyCAR) {
                    log.error((Object)"Downloaded CAR file does not contain META-INF/geronimo-plugin.xml file");
                }
                jar.close();
                PluginMetadata pluginMetadata = null;
                return pluginMetadata;
            }
            InputStream in = jar.getInputStream(entry);
            DocumentBuilder builder = PluginInstallerGBean.createDocumentBuilder();
            doc = builder.parse(in);
            in.close();
        }
        finally {
            jar.close();
        }
        return this.loadPluginMetadata(doc, file.getAbsolutePath());
    }

    private PluginMetadata loadPluginMetadata(Document doc, String file) throws SAXException, MalformedURLException {
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals("geronimo-plugin")) {
            log.error((Object)("Configuration archive " + file + " does not have a geronimo-plugin in META-INF/geronimo-plugin.xml"));
            return null;
        }
        return this.processPlugin(root);
    }

    private PluginList loadPluginList(URL repo, InputStream in) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = PluginInstallerGBean.createDocumentBuilder();
        Document doc = builder.parse(in);
        in.close();
        Element root = doc.getDocumentElement();
        NodeList configs = root.getElementsByTagName("plugin");
        ArrayList<PluginMetadata> results = new ArrayList<PluginMetadata>();
        for (int i = 0; i < configs.getLength(); ++i) {
            Element config = (Element)configs.item(i);
            PluginMetadata data = this.processPlugin(config);
            results.add(data);
        }
        String[] repos = PluginInstallerGBean.getChildrenText(root, "default-repository");
        URL[] repoURLs = new URL[repos.length];
        for (int i = 0; i < repos.length; ++i) {
            repoURLs[i] = repos[i].endsWith("/") ? new URL(repos[i]) : new URL(repos[i] + "/");
        }
        PluginMetadata[] data = results.toArray(new PluginMetadata[results.size()]);
        return new PluginList(repoURLs, data);
    }

    private static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = XmlUtil.newDocumentBuilderFactory();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", new InputStream[]{PluginInstallerGBean.class.getResourceAsStream("/META-INF/schema/attributes-1.1.xsd"), PluginInstallerGBean.class.getResourceAsStream("/META-INF/schema/plugins-1.1.xsd")});
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                throw new SAXException("Unable to read plugin file", exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw new SAXException("Unable to read plugin file", exception);
            }

            public void warning(SAXParseException exception) {
                log.warn((Object)"Warning reading XML document", (Throwable)exception);
            }
        });
        return builder;
    }

    private PluginMetadata processPlugin(Element plugin) throws SAXException, MalformedURLException {
        boolean match;
        String[] jvmVersions;
        boolean match2;
        String moduleId = PluginInstallerGBean.getChildText(plugin, "module-id");
        NodeList licenseNodes = plugin.getElementsByTagName("license");
        PluginMetadata.License[] licenses = new PluginMetadata.License[licenseNodes.getLength()];
        for (int j = 0; j < licenseNodes.getLength(); ++j) {
            Element node = (Element)licenseNodes.item(j);
            String licenseName = PluginInstallerGBean.getText(node);
            String openSource = node.getAttribute("osi-approved");
            if (licenseName == null || licenseName.equals("") || openSource == null || openSource.equals("")) {
                throw new SAXException("Invalid config file: license name and osi-approved flag required");
            }
            licenses[j] = new PluginMetadata.License(licenseName, Boolean.valueOf(openSource));
        }
        PluginMetadata.Hash hash = null;
        NodeList hashList = plugin.getElementsByTagName("hash");
        if (hashList.getLength() > 0) {
            Element elem = (Element)hashList.item(0);
            hash = new PluginMetadata.Hash(elem.getAttribute("type"), PluginInstallerGBean.getText(elem));
        }
        NodeList fileList = plugin.getElementsByTagName("copy-file");
        PluginMetadata.CopyFile[] files = new PluginMetadata.CopyFile[fileList.getLength()];
        for (int i = 0; i < files.length; ++i) {
            Element node = (Element)fileList.item(i);
            String relative = node.getAttribute("relative-to");
            String destDir = node.getAttribute("dest-dir");
            String fileName = PluginInstallerGBean.getText(node);
            files[i] = new PluginMetadata.CopyFile(relative.equals("server"), fileName, destDir);
        }
        NodeList gbeans = plugin.getElementsByTagName("gbean");
        GBeanOverride[] overrides = new GBeanOverride[gbeans.getLength()];
        for (int i = 0; i < overrides.length; ++i) {
            Element node = (Element)gbeans.item(i);
            try {
                overrides[i] = new GBeanOverride(node);
                continue;
            }
            catch (InvalidGBeanException e) {
                log.error((Object)("Unable to process config.xml entry " + node.getAttribute("name") + " (" + node + ")"), (Throwable)e);
            }
        }
        boolean eligible = true;
        NodeList preNodes = plugin.getElementsByTagName("prerequisite");
        PluginMetadata.Prerequisite[] prereqs = new PluginMetadata.Prerequisite[preNodes.getLength()];
        for (int j = 0; j < preNodes.getLength(); ++j) {
            Element node = (Element)preNodes.item(j);
            String originalConfigId = PluginInstallerGBean.getChildText(node, "id");
            if (originalConfigId == null) {
                throw new SAXException("Prerequisite requires <id>");
            }
            Artifact artifact = Artifact.create((String)originalConfigId.replaceAll("\\*", ""));
            boolean present = this.resolver.queryArtifacts(artifact).length > 0;
            prereqs[j] = new PluginMetadata.Prerequisite(artifact, present, PluginInstallerGBean.getChildText(node, "resource-type"), PluginInstallerGBean.getChildText(node, "description"));
            if (present) continue;
            log.debug((Object)(moduleId + " is not eligible due to missing " + prereqs[j].getModuleId()));
            eligible = false;
        }
        String[] gerVersions = PluginInstallerGBean.getChildrenText(plugin, "geronimo-version");
        if (gerVersions.length > 0 && !(match2 = this.checkGeronimoVersions(gerVersions))) {
            eligible = false;
        }
        if ((jvmVersions = PluginInstallerGBean.getChildrenText(plugin, "jvm-version")).length > 0 && !(match = this.checkJVMVersions(jvmVersions))) {
            eligible = false;
        }
        String[] repoNames = PluginInstallerGBean.getChildrenText(plugin, "source-repository");
        URL[] repos = new URL[repoNames.length];
        for (int i = 0; i < repos.length; ++i) {
            repos[i] = new URL(repoNames[i]);
        }
        Artifact artifact = null;
        boolean installed = false;
        if (moduleId != null) {
            artifact = Artifact.create((String)moduleId);
            installed = this.configManager != null && this.configManager.isInstalled(artifact);
        }
        log.trace((Object)("Checking " + moduleId + ": installed=" + installed + ", eligible=" + eligible));
        PluginMetadata data = new PluginMetadata(PluginInstallerGBean.getChildText(plugin, "name"), artifact, PluginInstallerGBean.getChildText(plugin, "category"), PluginInstallerGBean.getChildText(plugin, "description"), PluginInstallerGBean.getChildText(plugin, "url"), PluginInstallerGBean.getChildText(plugin, "author"), hash, installed, eligible);
        data.setGeronimoVersions(gerVersions);
        data.setJvmVersions(jvmVersions);
        data.setLicenses(licenses);
        data.setPrerequisites(prereqs);
        data.setRepositories(repos);
        data.setFilesToCopy(files);
        data.setConfigXmls(overrides);
        NodeList list = plugin.getElementsByTagName("dependency");
        ArrayList<String> start = new ArrayList<String>();
        String[] deps = new String[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            Element node = (Element)list.item(i);
            deps[i] = PluginInstallerGBean.getText(node);
            if (!node.hasAttribute("start") || !node.getAttribute("start").equalsIgnoreCase("true")) continue;
            start.add(deps[i]);
        }
        data.setDependencies(deps);
        data.setForceStart(start.toArray(new String[start.size()]));
        data.setObsoletes(PluginInstallerGBean.getChildrenText(plugin, "obsoletes"));
        return data;
    }

    private boolean checkJVMVersions(String[] jvmVersions) {
        if (jvmVersions.length == 0) {
            return true;
        }
        String version = System.getProperty("java.version");
        boolean match = false;
        for (int j = 0; j < jvmVersions.length; ++j) {
            String jvmVersion = jvmVersions[j];
            if (jvmVersion == null || jvmVersion.equals("")) {
                throw new IllegalStateException("jvm-version should not be empty!");
            }
            if (!version.startsWith(jvmVersion)) continue;
            match = true;
            break;
        }
        return match;
    }

    private boolean checkGeronimoVersions(String[] gerVersions) {
        if (gerVersions.length == 0) {
            return true;
        }
        String version = this.serverInfo.getVersion();
        boolean match = false;
        for (int j = 0; j < gerVersions.length; ++j) {
            String gerVersion = gerVersions[j];
            if (gerVersion == null || gerVersion.equals("")) {
                throw new IllegalStateException("geronimo-version should not be empty!");
            }
            if (!gerVersion.equals(version)) continue;
            match = true;
            break;
        }
        return match;
    }

    private static String getChildText(Element root, String property) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node check = children.item(i);
            if (check.getNodeType() != 1 || !check.getNodeName().equals(property)) continue;
            return PluginInstallerGBean.getText(check);
        }
        return null;
    }

    private static String getText(Node target) {
        NodeList nodes = target.getChildNodes();
        StringBuffer buf = null;
        for (int j = 0; j < nodes.getLength(); ++j) {
            Node node = nodes.item(j);
            if (node.getNodeType() != 3) continue;
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(node.getNodeValue());
        }
        return buf == null ? null : buf.toString();
    }

    private static String[] getChildrenText(Element root, String property) {
        NodeList children = root.getChildNodes();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node check = children.item(i);
            if (check.getNodeType() != 1 || !check.getNodeName().equals(property)) continue;
            NodeList nodes = check.getChildNodes();
            StringBuffer buf = null;
            for (int j = 0; j < nodes.getLength(); ++j) {
                Node node = nodes.item(j);
                if (node.getNodeType() != 3) continue;
                if (buf == null) {
                    buf = new StringBuffer();
                }
                buf.append(node.getNodeValue());
            }
            results.add(buf == null ? null : buf.toString());
        }
        return results.toArray(new String[results.size()]);
    }

    private PluginMetadata.Prerequisite processDependencyList(List real, PluginMetadata.Prerequisite prereq, List deps) {
        for (int i = 0; i < real.size(); ++i) {
            Dependency dep = (Dependency)real.get(i);
            if (dep.getArtifact().getGroupId().equals("geronimo")) {
                if (dep.getArtifact().getArtifactId().indexOf("jetty") > -1) {
                    if (prereq != null) continue;
                    prereq = new PluginMetadata.Prerequisite(dep.getArtifact(), true, "Web Container", "This plugin works with the Geronimo/Jetty distribution.  It is not intended to run in the Geronimo/Tomcat distribution.  There is a separate version of this plugin that works with Tomcat.");
                    continue;
                }
                if (dep.getArtifact().getArtifactId().indexOf("tomcat") > -1) {
                    if (prereq != null) continue;
                    prereq = new PluginMetadata.Prerequisite(dep.getArtifact(), true, "Web Container", "This plugin works with the Geronimo/Tomcat distribution.  It is not intended to run in the Geronimo/Jetty distribution.  There is a separate version of this plugin that works with Jetty.");
                    continue;
                }
            }
            if (deps.contains(dep.getArtifact().toString())) continue;
            deps.add(dep.getArtifact().toString());
        }
        return prereq;
    }

    private static Document writePluginMetadata(PluginMetadata data) throws ParserConfigurationException {
        int i;
        DocumentBuilder builder = PluginInstallerGBean.createDocumentBuilder();
        Document doc = builder.newDocument();
        Element config = doc.createElementNS("http://geronimo.apache.org/xml/ns/plugins-1.1", "geronimo-plugin");
        config.setAttribute("xmlns", "http://geronimo.apache.org/xml/ns/plugins-1.1");
        doc.appendChild(config);
        PluginInstallerGBean.addTextChild(doc, config, "name", data.getName());
        PluginInstallerGBean.addTextChild(doc, config, "module-id", data.getModuleId().toString());
        PluginInstallerGBean.addTextChild(doc, config, "category", data.getCategory());
        PluginInstallerGBean.addTextChild(doc, config, "description", data.getDescription());
        if (data.getPluginURL() != null) {
            PluginInstallerGBean.addTextChild(doc, config, "url", data.getPluginURL());
        }
        if (data.getAuthor() != null) {
            PluginInstallerGBean.addTextChild(doc, config, "author", data.getAuthor());
        }
        for (i = 0; i < data.getLicenses().length; ++i) {
            PluginMetadata.License license = data.getLicenses()[i];
            Element lic = doc.createElement("license");
            lic.appendChild(doc.createTextNode(license.getName()));
            lic.setAttribute("osi-approved", Boolean.toString(license.isOsiApproved()));
            config.appendChild(lic);
        }
        if (data.getHash() != null) {
            Element hash = doc.createElement("hash");
            hash.setAttribute("type", data.getHash().getType());
            hash.appendChild(doc.createTextNode(data.getHash().getValue()));
            config.appendChild(hash);
        }
        for (i = 0; i < data.getGeronimoVersions().length; ++i) {
            PluginInstallerGBean.addTextChild(doc, config, "geronimo-version", data.getGeronimoVersions()[i]);
        }
        for (i = 0; i < data.getJvmVersions().length; ++i) {
            PluginInstallerGBean.addTextChild(doc, config, "jvm-version", data.getJvmVersions()[i]);
        }
        for (i = 0; i < data.getPrerequisites().length; ++i) {
            PluginMetadata.Prerequisite prereq = data.getPrerequisites()[i];
            Element pre = doc.createElement("prerequisite");
            PluginInstallerGBean.addTextChild(doc, pre, "id", prereq.getModuleId().toString());
            if (prereq.getResourceType() != null) {
                PluginInstallerGBean.addTextChild(doc, pre, "resource-type", prereq.getResourceType());
            }
            if (prereq.getDescription() != null) {
                PluginInstallerGBean.addTextChild(doc, pre, "description", prereq.getDescription());
            }
            config.appendChild(pre);
        }
        for (i = 0; i < data.getDependencies().length; ++i) {
            PluginInstallerGBean.addTextChild(doc, config, "dependency", data.getDependencies()[i]);
        }
        for (i = 0; i < data.getObsoletes().length; ++i) {
            PluginInstallerGBean.addTextChild(doc, config, "obsoletes", data.getObsoletes()[i]);
        }
        for (i = 0; i < data.getRepositories().length; ++i) {
            URL url = data.getRepositories()[i];
            PluginInstallerGBean.addTextChild(doc, config, "source-repository", url.toString());
        }
        for (i = 0; i < data.getFilesToCopy().length; ++i) {
            PluginMetadata.CopyFile file = data.getFilesToCopy()[i];
            Element copy = doc.createElement("copy-file");
            copy.setAttribute("relative-to", file.isRelativeToVar() ? "server" : "geronimo");
            copy.setAttribute("dest-dir", file.getDestDir());
            copy.appendChild(doc.createTextNode(file.getSourceFile()));
            config.appendChild(copy);
        }
        if (data.getConfigXmls().length > 0) {
            Element content = doc.createElement("config-xml-content");
            for (int i2 = 0; i2 < data.getConfigXmls().length; ++i2) {
                GBeanOverride override = data.getConfigXmls()[i2];
                Element gbean = override.writeXml(doc, content);
                gbean.setAttribute("xmlns", "http://geronimo.apache.org/xml/ns/attributes-1.1");
            }
            config.appendChild(content);
        }
        return doc;
    }

    private static void addTextChild(Document doc, Element parent, String name, String text) {
        Element child = doc.createElement(name);
        child.appendChild(doc.createTextNode(text));
        parent.appendChild(child);
    }

    private void installConfigXMLData(Artifact configID, PluginMetadata pluginData) {
        if (this.configManager.isConfiguration(configID) && this.attributeStore != null && pluginData != null && pluginData.getConfigXmls().length > 0) {
            this.attributeStore.setModuleGBeans(configID, pluginData.getConfigXmls());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getNextKey() {
        int value;
        Class clazz = PluginInstallerGBean.class;
        synchronized (clazz) {
            value = ++counter;
        }
        return new Integer(value);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)PluginInstallerGBean.class);
        infoFactory.addReference("ConfigManager", ConfigurationManager.class, "ConfigurationManager");
        infoFactory.addReference("Repository", WritableListableRepository.class, "Repository");
        infoFactory.addReference("ConfigStore", ConfigurationStore.class, "ConfigurationStore");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addReference("ThreadPool", ThreadPool.class, "GBean");
        infoFactory.addReference("PluginAttributeStore", PluginAttributeStore.class, "AttributeStore");
        infoFactory.addInterface(PluginInstaller.class);
        infoFactory.setConstructor(new String[]{"ConfigManager", "Repository", "ConfigStore", "ServerInfo", "ThreadPool", "PluginAttributeStore"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class OpenResult {
        private final InputStream stream;
        private final Artifact configID;
        private final int fileSize;

        public OpenResult(Artifact configID, InputStream stream, int fileSize) {
            this.configID = configID;
            this.stream = stream;
            this.fileSize = fileSize;
        }

        public Artifact getConfigID() {
            return this.configID;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public int getFileSize() {
            return this.fileSize;
        }
    }

    private static class ResultsFileWriteMonitor
    implements FileWriteMonitor {
        private final DownloadPoller results;
        private int totalBytes;
        private String file;

        public ResultsFileWriteMonitor(DownloadPoller results) {
            this.results = results;
        }

        public void setTotalBytes(int totalBytes) {
            this.totalBytes = totalBytes;
        }

        public int getTotalBytes() {
            return this.totalBytes;
        }

        public void writeStarted(String fileDescription, int fileSize) {
            this.totalBytes = fileSize;
            this.file = fileDescription;
            this.results.setCurrentFile(fileDescription);
            this.results.setCurrentFilePercent(this.totalBytes > 0 ? 0 : -1);
        }

        public void writeProgress(int bytes) {
            if (this.totalBytes > 0) {
                double percent = (double)bytes / (double)this.totalBytes;
                this.results.setCurrentFilePercent((int)(percent * 100.0));
            } else {
                this.results.setCurrentMessage(bytes / 1024 + " kB of " + this.file);
            }
        }

        public void writeComplete(int bytes) {
            this.results.setCurrentFilePercent(100);
            this.results.setCurrentMessage("Finished installing " + this.file + " (" + bytes / 1024 + " kB)");
            this.results.addDownloadBytes(bytes);
        }

        public DownloadPoller getResults() {
            return this.results;
        }
    }

    private static class PluginNameIDHandler
    extends DefaultHandler {
        private String id = "";
        private String name = "";
        private String element = null;

        private PluginNameIDHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.element != null) {
                if (this.element.equals("module-id")) {
                    this.id = this.id + new String(ch, start, length);
                } else if (this.element.equals("name")) {
                    this.name = this.name + new String(ch, start, length);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.element = null;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("module-id") || qName.equals("name")) {
                this.element = qName;
            }
        }

        public void endDocument() throws SAXException {
            this.id = this.id.trim();
            this.name = this.name.trim();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isComplete() {
            return !this.id.equals("") && !this.name.equals("");
        }
    }
}

