/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoEnvironment;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.log.GeronimoLogging;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.main.LongStartupMonitor;
import org.apache.geronimo.system.main.ProgressBarStartupMonitor;
import org.apache.geronimo.system.main.SilentStartupMonitor;
import org.apache.geronimo.system.main.StartupMonitor;
import org.apache.geronimo.system.serverinfo.DirectoryUtils;

public class Daemon {
    private static final String ARGUMENT_NO_PROGRESS = "--quiet";
    private static final String ARGUMENT_LONG_PROGRESS = "--long";
    private static final String ARGUMENT_VERBOSE_SHORTFORM = "-v";
    private static final String ARGUMENT_VERBOSE = "--verbose";
    private static final String ARGUMENT_MORE_VERBOSE_SHORTFORM = "-vv";
    private static final String ARGUMENT_MORE_VERBOSE = "--veryverbose";
    private static final String ARGUMENT_MODULE_OVERRIDE = "--override";
    private static boolean started = false;
    private static Log log;
    private StartupMonitor monitor;
    private List configs = new ArrayList();
    private String verboseArg = null;
    private String noProgressArg = null;
    private String longProgressArg = null;

    private Daemon(String[] args) {
        long start = System.currentTimeMillis();
        if (!this.processArguments(args)) {
            System.exit(1);
            throw new AssertionError();
        }
        System.out.println("Booting Geronimo Kernel (in Java " + System.getProperty("java.version") + ")...");
        System.out.flush();
        this.initializeSystem();
        this.monitor.systemStarting(start);
        this.doStartup();
    }

    private void printHelp(PrintStream out) {
        out.println();
        out.println("Syntax: java -jar bin/server.jar [options]");
        out.println();
        out.println("Available options are: ");
        out.println("  --quiet");
        out.println("             Suppress the normal startup progress bar.  This is typically\n             used when redirecting console output to a file, or starting\n             the server from an IDE or other tool.");
        out.println("  --long");
        out.println("             Write startup progress to the console in a format that is\n             suitable for redirecting console output to a file, or starting\n             the server from an IDE or other tool (doesn't use linefeeds to\n             update the progress information that is used by default if you\n             don't specify --quiet or --long).\n");
        out.println("  -v --verbose");
        out.println("             Reduces the console log level to DEBUG, resulting in more\n             console output than is normally present.");
        out.println("  -vv --veryverbose");
        out.println("             Reduces the console log level to TRACE, resulting in still\n             more console output.");
        out.println();
        out.println("  --override [moduleId] [moduleId] ...");
        out.println("             USE WITH CAUTION!  Overrides the modules in\n             var/config/config.xml such that only the modules listed on\n             the command line will be started.  Note that many J2EE\n             features depend on certain modules being started, so you\n             should be very careful what you omit.  Any arguments after\n             this are assumed to be module names.");
        out.println();
        out.println("In addition you may specify a replacement for var/config/config.xml using by setting the property\n-Dorg.apache.geronimo.config.file=var/config/<my-config.xml>\nThis is resolved relative to the geronimo base directory.");
        out.println();
    }

    private boolean processArguments(String[] args) {
        boolean override = false;
        boolean help = false;
        for (int i = 0; i < args.length; ++i) {
            if (override) {
                this.configs.add(Artifact.create((String)args[i]));
                continue;
            }
            if (args[i].equals(ARGUMENT_NO_PROGRESS)) {
                this.noProgressArg = ARGUMENT_NO_PROGRESS;
                continue;
            }
            if (args[i].equals(ARGUMENT_LONG_PROGRESS)) {
                this.longProgressArg = ARGUMENT_LONG_PROGRESS;
                continue;
            }
            if (args[i].equals(ARGUMENT_VERBOSE_SHORTFORM) || args[i].equals(ARGUMENT_VERBOSE)) {
                if (this.verboseArg != null) continue;
                this.verboseArg = ARGUMENT_VERBOSE;
                continue;
            }
            if (args[i].equals(ARGUMENT_MORE_VERBOSE_SHORTFORM) || args[i].equals(ARGUMENT_MORE_VERBOSE)) {
                if (this.verboseArg != null) continue;
                this.verboseArg = ARGUMENT_MORE_VERBOSE;
                continue;
            }
            if (args[i].equals(ARGUMENT_MODULE_OVERRIDE)) {
                override = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("--help") || args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("/?")) {
                help = true;
                continue;
            }
            System.out.println("Unrecognized argument: " + args[i]);
            help = true;
        }
        if (help) {
            this.printHelp(System.out);
        }
        return !help;
    }

    private void initializeSystem() {
        if (!started) {
            started = true;
            GeronimoEnvironment.init();
            GeronimoLogging.initialize((GeronimoLogging)(this.verboseArg == null || this.verboseArg.equals(ARGUMENT_VERBOSE) ? GeronimoLogging.WARN : GeronimoLogging.DEBUG));
            GeronimoLogging.setConsoleLogLevel((GeronimoLogging)(this.verboseArg == null ? GeronimoLogging.INFO : (this.verboseArg.equals(ARGUMENT_VERBOSE) ? GeronimoLogging.DEBUG : GeronimoLogging.TRACE)));
            log = LogFactory.getLog((String)Daemon.class.getName());
        }
        this.monitor = this.verboseArg != null || this.noProgressArg != null ? new SilentStartupMonitor() : (this.longProgressArg != null ? new LongStartupMonitor() : new ProgressBarStartupMonitor());
    }

    private void JVMCheck() {
        String jvmVersion = System.getProperty("java.specification.version");
        if (!jvmVersion.equals("1.4")) {
            log.warn((Object)("\n====================================== Warning =======================================\n Geronimo is currently only certified on version 1.4 of the Java Virtual Machine.\n Use of version " + jvmVersion + " is not currently supported.  Use at your own risk.\n" + " Check http://geronimo.apache.org for current information on JDK certification level.\n" + "====================================== Warning ======================================="));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartup() {
        try {
            AbstractName configListName;
            Kernel i;
            Set configLists;
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null || !new File(tmpDir).exists() || !new File(tmpDir).isDirectory()) {
                System.err.println("The java.io.tmpdir system property specifies the non-existent directory " + tmpDir);
                System.exit(1);
                throw new AssertionError();
            }
            File geronimoInstallDirectory = DirectoryUtils.getGeronimoInstallDirectory();
            if (geronimoInstallDirectory == null) {
                System.err.println("Could not determine geronimo installation directory");
                System.exit(1);
                throw new AssertionError();
            }
            ClassLoader classLoader = Daemon.class.getClassLoader();
            final Kernel kernel = KernelFactory.newInstance().createKernel("geronimo");
            try {
                kernel.boot();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
                throw new AssertionError();
            }
            Runtime.getRuntime().addShutdownHook(new Thread("Geronimo shutdown thread"){

                public void run() {
                    System.out.println("\rServer shutdown begun              ");
                    kernel.shutdown();
                    System.out.println("Server shutdown completed");
                }
            });
            InputStream in = classLoader.getResourceAsStream("META-INF/config.ser");
            try {
                ConfigurationUtil.loadBootstrapConfiguration((Kernel)kernel, (InputStream)in, (ClassLoader)classLoader);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            this.monitor.systemStarted(kernel);
            AbstractNameQuery query = new AbstractNameQuery(PersistentConfigurationList.class.getName());
            if (this.configs.isEmpty()) {
                configLists = kernel.listGBeans(query);
                i = configLists.iterator();
                while (i.hasNext()) {
                    configListName = (AbstractName)i.next();
                    try {
                        this.configs.addAll((List)kernel.invoke(configListName, "restore"));
                    }
                    catch (IOException e) {
                        System.err.println("Unable to restore last known configurations");
                        e.printStackTrace();
                        kernel.shutdown();
                        System.exit(1);
                        throw new AssertionError();
                    }
                }
            }
            this.monitor.foundModules(this.configs.toArray(new Artifact[this.configs.size()]));
            try {
                ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
                try {
                    i = this.configs.iterator();
                    while (i.hasNext()) {
                        Artifact configID = (Artifact)i.next();
                        this.monitor.moduleLoading(configID);
                        configurationManager.loadConfiguration(configID);
                        this.monitor.moduleLoaded(configID);
                        this.monitor.moduleStarting(configID);
                        configurationManager.startConfiguration(configID);
                        this.monitor.moduleStarted(configID);
                    }
                }
                finally {
                    ConfigurationUtil.releaseConfigurationManager((Kernel)kernel, (ConfigurationManager)configurationManager);
                }
            }
            catch (Exception e) {
                this.monitor.serverStartFailed(e);
                try {
                    kernel.shutdown();
                }
                catch (Exception e1) {
                    System.err.println("Exception caught during kernel shutdown");
                    e1.printStackTrace();
                }
                System.exit(1);
                throw new AssertionError();
            }
            configLists = kernel.listGBeans(query);
            i = configLists.iterator();
            while (i.hasNext()) {
                configListName = (AbstractName)i.next();
                kernel.setAttribute(configListName, "kernelFullyStarted", (Object)Boolean.TRUE);
            }
            this.monitor.startupFinished();
            this.monitor = null;
            while (kernel.isRunning()) {
                try {
                    i = kernel;
                    synchronized (i) {
                        kernel.wait();
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
        catch (Exception e) {
            if (this.monitor != null) {
                this.monitor.serverStartFailed(e);
            }
            e.printStackTrace();
            System.exit(1);
            throw new AssertionError();
        }
    }

    private void AddToSystemProperty(String propertyName, List dirsFromManifest, File geronimoInstallDirectory) {
        String dirs = System.getProperty(propertyName, "");
        Iterator iterator = dirsFromManifest.iterator();
        while (iterator.hasNext()) {
            String directoryName = (String)iterator.next();
            File directory = new File(directoryName);
            if (!directory.isAbsolute()) {
                directory = new File(geronimoInstallDirectory, directoryName);
            }
            if (dirs.length() > 0) {
                dirs = dirs + File.pathSeparatorChar;
            }
            dirs = dirs + directory.getAbsolutePath();
        }
        if (dirs.length() > 0) {
            System.setProperty(propertyName, dirs);
        }
        log.debug((Object)(propertyName + "=" + System.getProperty(propertyName)));
    }

    public static void main(String[] args) {
        new Daemon(args);
    }
}

