/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.main.CommandLine;

public class CommandLineManifest {
    public static final Attributes.Name MAIN_GBEAN = new Attributes.Name("Main-GBean");
    public static final Attributes.Name MAIN_METHOD = new Attributes.Name("Main-Method");
    public static final Attributes.Name CONFIGURATIONS = new Attributes.Name("Configurations");
    public static final Attributes.Name ENDORSED_DIRS = new Attributes.Name("Endorsed-Dirs");
    public static final Attributes.Name EXTENSION_DIRS = new Attributes.Name("Extension-Dirs");
    private final AbstractNameQuery mainGBean;
    private final String mainMethod;
    private final List configurations;
    private final List endorsedDirs;
    private final List extensionDirs;

    public static CommandLineManifest getManifestEntries() {
        Manifest manifest;
        ClassLoader classLoader = CommandLine.class.getClassLoader();
        URL url = classLoader.getResource("META-INF/startup-jar");
        if (url == null) {
            throw new IllegalArgumentException("Unable to determine location of startup jar");
        }
        try {
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            manifest = jarConnection.getManifest();
        }
        catch (IOException e) {
            System.err.println("Startup jar does not contain a manifest: " + url);
            System.exit(1);
            throw new AssertionError();
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String mainGBeanString = mainAttributes.getValue(MAIN_GBEAN);
        AbstractNameQuery mainGBean = null;
        if (mainGBeanString != null) {
            try {
                mainGBean = new AbstractNameQuery(new URI(mainGBeanString));
            }
            catch (URISyntaxException e) {
                System.err.println("Invalid Main-GBean name: " + mainGBeanString);
                System.exit(1);
                throw new AssertionError();
            }
        }
        String mainMethod = mainAttributes.getValue(MAIN_METHOD);
        ArrayList<Artifact> configurations = new ArrayList<Artifact>();
        String configurationsString = mainAttributes.getValue(CONFIGURATIONS);
        if (configurationsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(configurationsString, " ");
            while (tokenizer.hasMoreTokens()) {
                String configuration = tokenizer.nextToken();
                configurations.add(Artifact.create((String)configuration));
            }
        }
        ArrayList<String> endorsedDirs = new ArrayList<String>();
        String endorsedDirsString = mainAttributes.getValue(ENDORSED_DIRS);
        if (endorsedDirsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(endorsedDirsString, " ");
            while (tokenizer.hasMoreTokens()) {
                String directory = tokenizer.nextToken();
                endorsedDirs.add(directory);
            }
        }
        ArrayList<String> extensionDirs = new ArrayList<String>();
        String extensionDirsString = mainAttributes.getValue(EXTENSION_DIRS);
        if (extensionDirsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensionDirsString, " ");
            while (tokenizer.hasMoreTokens()) {
                String directory = tokenizer.nextToken();
                extensionDirs.add(directory);
            }
        }
        CommandLineManifest commandLineManifest = new CommandLineManifest(mainGBean, mainMethod, configurations, endorsedDirs, extensionDirs);
        return commandLineManifest;
    }

    public CommandLineManifest(AbstractNameQuery mainGBean, String mainMethod, List configurations, List endorsedDirs, List extensionDirs) {
        this.mainGBean = mainGBean;
        this.mainMethod = mainMethod;
        this.configurations = Collections.unmodifiableList(configurations);
        this.endorsedDirs = endorsedDirs;
        this.extensionDirs = extensionDirs;
    }

    public AbstractNameQuery getMainGBeanQuery() {
        return this.mainGBean;
    }

    public String getMainMethod() {
        return this.mainMethod;
    }

    public List getConfigurations() {
        return this.configurations;
    }

    public List getEndorsedDirs() {
        return this.endorsedDirs;
    }

    public List getExtensionDirs() {
        return this.extensionDirs;
    }
}

