/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.geronimo.system.configuration.BaseMarkupSerializer;
import org.apache.geronimo.system.configuration.ElementState;
import org.apache.geronimo.system.configuration.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this.format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this.format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream output, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this.format.setMethod("xml");
        this.setOutputByteStream(output);
    }

    public void setOutputFormat(OutputFormat format) {
        super.setOutputFormat(format != null ? format : new OutputFormat("xml", null, false));
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        try {
            String value;
            String name;
            String prefix;
            if (this.printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this.started) {
                    this.startDocument(localName == null || localName.length() == 0 ? rawName : localName);
                }
            } else {
                if (state.empty) {
                    this.printer.printText('>');
                }
                if (state.inCData) {
                    this.printer.printText("]]>");
                    state.inCData = false;
                }
                if (this.indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this.printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            attrs = this.extractNamespaces(attrs);
            if (rawName == null || rawName.length() == 0) {
                if (localName == null) {
                    throw new SAXException("No rawName and localName is null");
                }
                rawName = namespaceURI != null && !namespaceURI.equals("") ? ((prefix = this.getPrefix(namespaceURI)) != null && prefix.length() > 0 ? prefix + ":" + localName : localName) : localName;
            }
            this.printer.printText('<');
            this.printer.printText(rawName);
            this.printer.indent();
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this.printer.printSpace();
                    name = attrs.getQName(i);
                    if (name != null && name.length() == 0) {
                        name = attrs.getLocalName(i);
                        String attrURI = attrs.getURI(i);
                        if (!(attrURI == null || attrURI.length() == 0 || namespaceURI != null && namespaceURI.length() != 0 && attrURI.equals(namespaceURI) || (prefix = this.getPrefix(attrURI)) == null || prefix.length() <= 0)) {
                            name = prefix + ":" + name;
                        }
                    }
                    if ((value = attrs.getValue(i)) == null) {
                        value = "";
                    }
                    this.printer.printText(name);
                    this.printer.printText("=\"");
                    this.printEscaped(value);
                    this.printer.printText('\"');
                    if (!name.equals("xml:space")) continue;
                    preserveSpace = value.equals("preserve") ? true : this.format.getPreserveSpace();
                }
            }
            if (this.prefixes != null) {
                Enumeration keyEnum = this.prefixes.keys();
                while (keyEnum.hasMoreElements()) {
                    this.printer.printSpace();
                    value = (String)keyEnum.nextElement();
                    name = (String)this.prefixes.get(value);
                    if (name.length() == 0) {
                        this.printer.printText("xmlns=\"");
                        this.printEscaped(value);
                        this.printer.printText('\"');
                        continue;
                    }
                    this.printer.printText("xmlns:");
                    this.printer.printText(name);
                    this.printer.printText("=\"");
                    this.printEscaped(value);
                    this.printer.printText('\"');
                }
            }
            state = this.enterElementState(namespaceURI, localName, rawName, preserveSpace);
            name = localName == null || localName.length() == 0 ? rawName : namespaceURI + "^" + localName;
            state.doCData = this.format.isCDataElement(name);
            state.unescaped = this.format.isNonEscapingElement(name);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        try {
            this.endElementIO(namespaceURI, localName, rawName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        this.printer.unindent();
        ElementState state = this.getElementState();
        if (state.empty) {
            this.printer.printText("/>");
        } else {
            if (state.inCData) {
                this.printer.printText("]]>");
            }
            if (this.indenting && !state.preserveSpace && (state.afterElement || state.afterComment)) {
                this.printer.breakLine();
            }
            this.printer.printText("</");
            this.printer.printText(state.rawName);
            this.printer.printText('>');
        }
        state = this.leaveElementState();
        state.afterElement = true;
        state.afterComment = false;
        state.empty = false;
        if (this.isDocumentState()) {
            this.printer.flush();
        }
    }

    public void startElement(String tagName, AttributeList attrs) throws SAXException {
        try {
            if (this.printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this.started) {
                    this.startDocument(tagName);
                }
            } else {
                if (state.empty) {
                    this.printer.printText('>');
                }
                if (state.inCData) {
                    this.printer.printText("]]>");
                    state.inCData = false;
                }
                if (this.indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this.printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            this.printer.printText('<');
            this.printer.printText(tagName);
            this.printer.indent();
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this.printer.printSpace();
                    String name = attrs.getName(i);
                    String value = attrs.getValue(i);
                    if (value != null) {
                        this.printer.printText(name);
                        this.printer.printText("=\"");
                        this.printEscaped(value);
                        this.printer.printText('\"');
                    }
                    if (!name.equals("xml:space")) continue;
                    preserveSpace = value.equals("preserve") ? true : this.format.getPreserveSpace();
                }
            }
            state = this.enterElementState(null, null, tagName, preserveSpace);
            state.doCData = this.format.isCDataElement(tagName);
            state.unescaped = this.format.isNonEscapingElement(tagName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElement(String tagName) throws SAXException {
        this.endElement(null, null, tagName);
    }

    protected void startDocument(String rootTagName) throws IOException {
        String dtd = this.printer.leaveDTD();
        if (!this.started) {
            if (!this.format.getOmitXMLDeclaration()) {
                StringBuffer buffer = new StringBuffer("<?xml version=\"");
                if (this.format.getVersion() != null) {
                    buffer.append(this.format.getVersion());
                } else {
                    buffer.append("1.0");
                }
                buffer.append('\"');
                if (this.format.getEncoding() != null) {
                    buffer.append(" encoding=\"");
                    buffer.append(this.format.getEncoding());
                    buffer.append('\"');
                }
                if (this.format.getStandalone() && this.docTypeSystemId == null && this.docTypePublicId == null) {
                    buffer.append(" standalone=\"yes\"");
                }
                buffer.append("?>");
                this.printer.printText(buffer);
                this.printer.breakLine();
            }
            if (!this.format.getOmitDocumentType()) {
                if (this.docTypeSystemId != null) {
                    this.printer.printText("<!DOCTYPE ");
                    this.printer.printText(rootTagName);
                    if (this.docTypePublicId != null) {
                        this.printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this.docTypePublicId);
                        if (this.indenting) {
                            this.printer.breakLine();
                            for (int i = 0; i < 18 + rootTagName.length(); ++i) {
                                this.printer.printText(" ");
                            }
                        } else {
                            this.printer.printText(" ");
                        }
                        this.printDoctypeURL(this.docTypeSystemId);
                    } else {
                        this.printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this.docTypeSystemId);
                    }
                    if (dtd != null && dtd.length() > 0) {
                        this.printer.printText(" [");
                        this.printText(dtd, true, true);
                        this.printer.printText(']');
                    }
                    this.printer.printText(">");
                    this.printer.breakLine();
                } else if (dtd != null && dtd.length() > 0) {
                    this.printer.printText("<!DOCTYPE ");
                    this.printer.printText(rootTagName);
                    this.printer.printText(" [");
                    this.printText(dtd, true, true);
                    this.printer.printText("]>");
                    this.printer.breakLine();
                }
            }
        }
        this.started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element elem) throws IOException {
        String tagName = elem.getTagName();
        ElementState state = this.getElementState();
        if (this.isDocumentState()) {
            if (!this.started) {
                this.startDocument(tagName);
            }
        } else {
            if (state.empty) {
                this.printer.printText('>');
            }
            if (state.inCData) {
                this.printer.printText("]]>");
                state.inCData = false;
            }
            if (this.indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                this.printer.breakLine();
            }
        }
        boolean preserveSpace = state.preserveSpace;
        this.printer.printText('<');
        this.printer.printText(tagName);
        this.printer.indent();
        NamedNodeMap attrMap = elem.getAttributes();
        if (attrMap != null) {
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Attr attr = (Attr)attrMap.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                if (value == null) {
                    value = "";
                }
                if (attr.getSpecified()) {
                    this.printer.printSpace();
                    this.printer.printText(name);
                    this.printer.printText("=\"");
                    this.printEscaped(value);
                    this.printer.printText('\"');
                }
                if (!name.equals("xml:space")) continue;
                preserveSpace = value.equals("preserve") ? true : this.format.getPreserveSpace();
            }
        }
        if (elem.hasChildNodes()) {
            state = this.enterElementState(null, null, tagName, preserveSpace);
            state.doCData = this.format.isCDataElement(tagName);
            state.unescaped = this.format.isNonEscapingElement(tagName);
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.serializeNode(child);
            }
            this.endElementIO(null, null, tagName);
        } else {
            this.printer.unindent();
            this.printer.printText("/>");
            state.afterElement = true;
            state.afterComment = false;
            state.empty = false;
            if (this.isDocumentState()) {
                this.printer.flush();
            }
        }
    }

    protected String getEntityRef(int ch) {
        switch (ch) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attrs) throws SAXException {
        int length = attrs.getLength();
        AttributesImpl attrsOnly = new AttributesImpl(attrs);
        for (int i = length - 1; i >= 0; --i) {
            String rawName = attrsOnly.getQName(i);
            if (!rawName.startsWith("xmlns")) continue;
            if (rawName.length() == 5) {
                this.startPrefixMapping("", attrs.getValue(i));
                attrsOnly.removeAttribute(i);
                continue;
            }
            if (rawName.charAt(5) != ':') continue;
            this.startPrefixMapping(rawName.substring(6), attrs.getValue(i));
            attrsOnly.removeAttribute(i);
        }
        return attrsOnly;
    }
}

