/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan.internal.client.locator;

import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import org.apache.geode.cache.client.internal.locator.wan.LocatorMembershipListener;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorJoinRequest;
import org.apache.geode.cache.wan.internal.client.locator.LocatorDiscovery;
import org.apache.geode.cache.wan.internal.client.locator.LocatorHelper;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.WanLocatorDiscoverer;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.logging.internal.executors.LoggingExecutors;

public class WanLocatorDiscovererImpl
implements WanLocatorDiscoverer {
    private volatile boolean stopped = false;
    private ExecutorService _executor;

    public void discover(int port, DistributionConfigImpl config, LocatorMembershipListener locatorListener, String hostnameForClients) {
        this._executor = LoggingExecutors.newCachedThreadPool((String)"WAN Locator Discovery Thread", (boolean)true);
        this.exchangeLocalLocators(port, config, locatorListener, hostnameForClients);
        this.exchangeRemoteLocators(port, config, locatorListener, hostnameForClients);
        this._executor.shutdown();
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void exchangeLocalLocators(int port, DistributionConfigImpl config, LocatorMembershipListener locatorListener, String hostnameForClients) {
        String localLocator = config.getStartLocator();
        String memberName = config.getName();
        DistributionLocatorId locatorId = localLocator.equals("") ? new DistributionLocatorId(port, config.getBindAddress(), hostnameForClients, memberName) : DistributionLocatorId.unmarshal((String)localLocator, (String)memberName);
        LocatorHelper.addLocator(config.getDistributedSystemId(), locatorId, locatorListener, null);
        RemoteLocatorJoinRequest request = this.buildRemoteDSJoinRequest(port, config, hostnameForClients);
        StringTokenizer locatorsOnThisVM = new StringTokenizer(config.getLocators(), ",");
        while (locatorsOnThisVM.hasMoreTokens()) {
            DistributionLocatorId localLocatorId = DistributionLocatorId.unmarshal((String)locatorsOnThisVM.nextToken());
            if (locatorId.equals((Object)localLocatorId)) continue;
            LocatorDiscovery localDiscovery = new LocatorDiscovery(this, localLocatorId, request, locatorListener);
            LocatorDiscovery.LocalLocatorDiscovery localLocatorDiscovery = new LocatorDiscovery.LocalLocatorDiscovery(localDiscovery);
            this._executor.execute(localLocatorDiscovery);
        }
    }

    private void exchangeRemoteLocators(int port, DistributionConfigImpl config, LocatorMembershipListener locatorListener, String hostnameForClients) {
        RemoteLocatorJoinRequest request = this.buildRemoteDSJoinRequest(port, config, hostnameForClients);
        String remoteDistributedSystems = config.getRemoteLocators();
        if (remoteDistributedSystems.length() > 0) {
            StringTokenizer remoteLocators = new StringTokenizer(remoteDistributedSystems, ",");
            while (remoteLocators.hasMoreTokens()) {
                DistributionLocatorId remoteLocatorId = DistributionLocatorId.unmarshal((String)remoteLocators.nextToken());
                LocatorDiscovery localDiscovery = new LocatorDiscovery(this, remoteLocatorId, request, locatorListener);
                LocatorDiscovery.RemoteLocatorDiscovery remoteLocatorDiscovery = new LocatorDiscovery.RemoteLocatorDiscovery(localDiscovery);
                this._executor.execute(remoteLocatorDiscovery);
            }
        }
    }

    private RemoteLocatorJoinRequest buildRemoteDSJoinRequest(int port, DistributionConfigImpl config, String hostnameForClients) {
        String localLocator = config.getStartLocator();
        String memberName = config.getName();
        DistributionLocatorId locatorId = localLocator.equals("") ? new DistributionLocatorId(port, config.getBindAddress(), hostnameForClients, memberName) : DistributionLocatorId.unmarshal((String)localLocator, (String)memberName);
        return new RemoteLocatorJoinRequest(config.getDistributedSystemId(), locatorId, "");
    }
}

