/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan.internal;

import java.io.IOException;
import java.net.ConnectException;
import java.util.StringTokenizer;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorResponse;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.WanLocatorDiscoverer;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderAttributes;
import org.apache.geode.internal.cache.wan.GatewaySenderConfigurationException;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRemoteGatewaySender
extends AbstractGatewaySender {
    private static final Logger logger = LogService.getLogger();
    protected int proxyFailureTries = 0;

    public AbstractRemoteGatewaySender(InternalCache cache, StatisticsClock statisticsClock, GatewaySenderAttributes attrs) {
        super(cache, statisticsClock, attrs);
    }

    public synchronized void initProxy() {
        if (this.remoteDSId == -1 || this.proxy != null && !this.proxy.isDestroyed()) {
            return;
        }
        int locatorCount = 0;
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.setPRSingleHopEnabled(false);
        if (this.locatorDiscoveryCallback != null) {
            pf.setLocatorDiscoveryCallback(this.locatorDiscoveryCallback);
        }
        pf.setReadTimeout(this.socketReadTimeout);
        pf.setIdleTimeout((long)this.connectionIdleTimeOut);
        pf.setSocketBufferSize(this.socketBufferSize);
        pf.setServerGroup("__recv__group");
        RemoteLocatorRequest request = new RemoteLocatorRequest(this.remoteDSId, pf.getPoolAttributes().getServerGroup());
        String locators = this.cache.getInternalDistributedSystem().getConfig().getLocators();
        boolean debugEnabled = logger.isDebugEnabled();
        if (debugEnabled) {
            logger.debug("Gateway Sender is attempting to configure pool with remote locator information");
        }
        StringTokenizer locatorsOnThisVM = new StringTokenizer(locators, ",");
        while (locatorsOnThisVM.hasMoreTokens()) {
            String localLocator = locatorsOnThisVM.nextToken();
            DistributionLocatorId locatorID = DistributionLocatorId.unmarshal((String)localLocator);
            try {
                RemoteLocatorResponse response = (RemoteLocatorResponse)new TcpClient((TcpSocketCreator)SocketCreatorFactory.getSocketCreatorForComponent((SecurableCommunicationChannel)SecurableCommunicationChannel.LOCATOR), InternalDataSerializer.getDSFIDSerializer().getObjectSerializer(), InternalDataSerializer.getDSFIDSerializer().getObjectDeserializer(), TcpSocketFactory.DEFAULT).requestToServer(locatorID.getHost(), (Object)request, WanLocatorDiscoverer.WAN_LOCATOR_CONNECTION_TIMEOUT, true);
                if (response == null) continue;
                if (response.getLocators() == null) {
                    if (!this.logProxyFailure()) continue;
                    logger.warn("Remote locator host port information for remote site {} is not available in local locator {}.", (Object)this.remoteDSId, (Object)localLocator);
                    continue;
                }
                if (debugEnabled) {
                    logger.debug("Received the remote site {} location information: {}", (Object)this.remoteDSId, response.getLocators());
                }
                for (String remoteLocator : response.getLocators()) {
                    try {
                        DistributionLocatorId locatorId = DistributionLocatorId.unmarshal((String)remoteLocator);
                        pf.addLocator(locatorId.getHost().getHostName(), locatorId.getPort());
                        ++locatorCount;
                    }
                    catch (Exception e) {
                        if (!this.logProxyFailure()) continue;
                        logger.warn("Caught the following exception attempting to add remote locator {}. The locator will be ignored.", (Object)remoteLocator, (Object)e);
                    }
                }
                break;
            }
            catch (IOException ioe) {
                if (!this.logProxyFailure()) continue;
                if (ioe instanceof ConnectException && !debugEnabled) {
                    logger.warn("GatewaySender {} is not able to connect to local locator {} : {}", (Object)this.id, (Object)localLocator, (Object)ioe);
                    continue;
                }
                logger.warn("GatewaySender {} is not able to connect to local locator {}", (Object)this.id, (Object)localLocator, (Object)ioe);
            }
            catch (ClassNotFoundException e) {
                if (!this.logProxyFailure()) continue;
                logger.warn("GatewaySender {} is not able to connect to local locator {}", (Object)this.id, (Object)localLocator, (Object)e);
            }
        }
        if (locatorCount == 0) {
            if (this.logProxyFailure()) {
                logger.fatal("GatewaySender {} could not get remote locator information for remote site {}.", (Object)this.id, (Object)this.remoteDSId);
            }
            ++this.proxyFailureTries;
            throw new GatewaySenderConfigurationException(String.format("GatewaySender %s could not get remote locator information for remote site %s.", this.id, this.remoteDSId));
        }
        pf.init((GatewaySender)this);
        this.proxy = (PoolImpl)pf.create(this.getId());
        if (this.proxyFailureTries > 0) {
            logger.info("GatewaySender {} got remote locator information for remote site {} after {} failures in connecting to remote site.", (Object)this.id, (Object)this.remoteDSId, (Object)this.proxyFailureTries);
            this.proxyFailureTries = 0;
        }
    }

    protected boolean logProxyFailure() {
        assert (Thread.holdsLock((Object)this));
        if (logger.isDebugEnabled() || this.proxyFailureTries == 0) {
            return true;
        }
        if (this.proxyFailureTries >= 3000) {
            return this.proxyFailureTries % 3000 == 0;
        }
        return this.proxyFailureTries == 30 || this.proxyFailureTries == 300;
    }
}

