/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.util.ArrayUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.cli.domain.DiskStoreDetails;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.logging.log4j.Logger;

public class DescribeDiskStoreFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();

    protected static void assertState(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    public String getId() {
        return this.getClass().getName();
    }

    public void init(Properties props) {
    }

    public void execute(FunctionContext context) {
        Cache cache = context.getCache();
        try {
            if (cache instanceof InternalCache) {
                InternalCache gemfireCache = (InternalCache)cache;
                InternalDistributedMember member = gemfireCache.getMyId();
                String diskStoreName = (String)context.getArguments();
                String memberId = member.getId();
                String memberName = member.getName();
                DiskStore diskStore = gemfireCache.findDiskStore(diskStoreName);
                if (diskStore != null) {
                    DiskStoreDetails diskStoreDetails = new DiskStoreDetails(diskStore.getDiskStoreUUID(), diskStore.getName(), memberId, memberName);
                    diskStoreDetails.setAllowForceCompaction(diskStore.getAllowForceCompaction());
                    diskStoreDetails.setAutoCompact(diskStore.getAutoCompact());
                    diskStoreDetails.setCompactionThreshold(diskStore.getCompactionThreshold());
                    diskStoreDetails.setMaxOplogSize(diskStore.getMaxOplogSize());
                    diskStoreDetails.setQueueSize(diskStore.getQueueSize());
                    diskStoreDetails.setTimeInterval(diskStore.getTimeInterval());
                    diskStoreDetails.setWriteBufferSize(diskStore.getWriteBufferSize());
                    diskStoreDetails.setDiskUsageWarningPercentage(Float.valueOf(diskStore.getDiskUsageWarningPercentage()));
                    diskStoreDetails.setDiskUsageCriticalPercentage(Float.valueOf(diskStore.getDiskUsageCriticalPercentage()));
                    this.setDiskDirDetails(diskStore, diskStoreDetails);
                    this.setRegionDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setCacheServerDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setGatewayDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setPdxSerializationDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setAsyncEventQueueDetails(gemfireCache, diskStore, diskStoreDetails);
                    context.getResultSender().lastResult((Object)diskStoreDetails);
                } else {
                    context.getResultSender().sendException((Throwable)new EntityNotFoundException(String.format("A disk store with name '%1$s' was not found on member '%2$s'.", diskStoreName, memberName)));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while executing 'describe disk-store': {}!", (Object)e.getMessage(), (Object)e);
            context.getResultSender().sendException((Throwable)e);
        }
    }

    private void setDiskDirDetails(DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        Object[] diskDirSizes;
        File[] diskDirs = diskStore.getDiskDirs();
        DescribeDiskStoreFunction.assertState(diskDirs.length == (diskDirSizes = ArrayUtils.toIntegerArray((int[])diskStore.getDiskDirSizes())).length, "The number of disk directories with a specified size (%1$d) does not match the number of disk directories (%2$d)!", diskDirSizes.length, diskDirs.length);
        for (int index = 0; index < diskDirs.length; ++index) {
            diskStoreDetails.add(new DiskStoreDetails.DiskDirDetails(diskDirs[index].getAbsolutePath(), (Integer)ArrayUtils.getElementAtIndex((Object[])diskDirSizes, (int)index, (Object)0)));
        }
    }

    protected String getDiskStoreName(Region region) {
        return (String)StringUtils.defaultIfBlank((CharSequence)region.getAttributes().getDiskStoreName(), (CharSequence)"DEFAULT");
    }

    protected boolean isOverflowToDisk(Region region) {
        return region.getAttributes().getEvictionAttributes() != null && EvictionAction.OVERFLOW_TO_DISK.equals(region.getAttributes().getEvictionAttributes().getAction());
    }

    protected boolean isPersistent(Region region) {
        return region.getAttributes().getDataPolicy().withPersistence();
    }

    protected boolean isUsingDiskStore(Region region, DiskStore diskStore) {
        return (this.isPersistent(region) || this.isOverflowToDisk(region)) && ObjectUtils.equals((Object)this.getDiskStoreName(region), (Object)diskStore.getName());
    }

    protected void setRegionDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (Region region : cache.rootRegions()) {
            this.setRegionDetails(region, diskStore, diskStoreDetails);
        }
    }

    private void setRegionDetails(Region<?, ?> region, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        if (this.isUsingDiskStore(region, diskStore)) {
            String regionFullPath = region.getFullPath();
            DiskStoreDetails.RegionDetails regionDetails = new DiskStoreDetails.RegionDetails(regionFullPath, (String)StringUtils.defaultIfBlank((CharSequence)region.getName(), (CharSequence)regionFullPath));
            regionDetails.setOverflowToDisk(this.isOverflowToDisk(region));
            regionDetails.setPersistent(this.isPersistent(region));
            diskStoreDetails.add(regionDetails);
        }
        for (Region subregion : region.subregions(false)) {
            this.setRegionDetails(subregion, diskStore, diskStoreDetails);
        }
    }

    protected String getDiskStoreName(CacheServer cacheServer) {
        return cacheServer.getClientSubscriptionConfig() == null ? null : (String)StringUtils.defaultIfBlank((CharSequence)cacheServer.getClientSubscriptionConfig().getDiskStoreName(), (CharSequence)"DEFAULT");
    }

    protected boolean isUsingDiskStore(CacheServer cacheServer, DiskStore diskStore) {
        return ObjectUtils.equals((Object)this.getDiskStoreName(cacheServer), (Object)diskStore.getName());
    }

    protected void setCacheServerDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (CacheServer cacheServer : cache.getCacheServers()) {
            if (!this.isUsingDiskStore(cacheServer, diskStore)) continue;
            DiskStoreDetails.CacheServerDetails cacheServerDetails = new DiskStoreDetails.CacheServerDetails(cacheServer.getBindAddress(), cacheServer.getPort());
            cacheServerDetails.setHostName(cacheServer.getHostnameForClients());
            diskStoreDetails.add(cacheServerDetails);
        }
    }

    protected String getDiskStoreName(GatewaySender gateway) {
        return (String)StringUtils.defaultIfBlank((CharSequence)gateway.getDiskStoreName(), (CharSequence)"DEFAULT");
    }

    protected boolean isPersistent(GatewaySender gateway) {
        return gateway.isPersistenceEnabled();
    }

    protected boolean isUsingDiskStore(GatewaySender gateway, DiskStore diskStore) {
        return ObjectUtils.equals((Object)this.getDiskStoreName(gateway), (Object)diskStore.getName());
    }

    protected void setGatewayDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (GatewaySender gatewaySender : cache.getGatewaySenders()) {
            if (!this.isUsingDiskStore(gatewaySender, diskStore)) continue;
            DiskStoreDetails.GatewayDetails gatewayDetails = new DiskStoreDetails.GatewayDetails(gatewaySender.getId());
            gatewayDetails.setPersistent(this.isPersistent(gatewaySender));
            diskStoreDetails.add(gatewayDetails);
        }
    }

    protected void setPdxSerializationDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        if (cache.getPdxPersistent()) {
            String diskStoreName = (String)StringUtils.defaultIfBlank((CharSequence)cache.getPdxDiskStore(), (CharSequence)"DEFAULT");
            diskStoreDetails.setPdxSerializationMetaDataStored(ObjectUtils.equals((Object)diskStoreName, (Object)diskStore.getName()));
        }
    }

    protected String getDiskStoreName(AsyncEventQueue queue) {
        return (String)StringUtils.defaultIfBlank((CharSequence)queue.getDiskStoreName(), (CharSequence)"DEFAULT");
    }

    protected boolean isUsingDiskStore(AsyncEventQueue queue, DiskStore diskStore) {
        return queue.isPersistent() && ObjectUtils.equals((Object)this.getDiskStoreName(queue), (Object)diskStore.getName());
    }

    protected void setAsyncEventQueueDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (AsyncEventQueue queue : cache.getAsyncEventQueues()) {
            if (!this.isUsingDiskStore(queue, diskStore)) continue;
            diskStoreDetails.add(new DiskStoreDetails.AsyncEventQueueDetails(queue.getId()));
        }
    }
}

