/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.domain;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexStatistics;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.lang.ObjectUtils;

public class IndexDetails
implements Comparable<IndexDetails>,
Serializable {
    private static final long serialVersionUID = -2198907141534201288L;
    private IndexStatisticsDetails indexStatisticsDetails;
    private IndexType indexType;
    private String indexedExpression;
    private String fromClause;
    private String projectionAttributes;
    private String memberName;
    private String regionName;
    private boolean isValid;
    private final String indexName;
    private final String memberId;
    private final String regionPath;

    protected static void assertValidArgument(boolean valid, String message, Object ... args) {
        if (!valid) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    protected static <T extends Comparable<T>> int compare(T obj1, T obj2) {
        return obj1 == null && obj2 == null ? 0 : (obj1 == null ? 1 : (obj2 == null ? -1 : obj1.compareTo(obj2)));
    }

    protected static IndexStatisticsDetails createIndexStatisticsDetails(IndexStatistics indexStatistics) {
        IndexStatisticsDetails indexStatisticsDetails = new IndexStatisticsDetails();
        indexStatisticsDetails.setNumberOfKeys(indexStatistics.getNumberOfKeys());
        indexStatisticsDetails.setNumberOfUpdates(indexStatistics.getNumUpdates());
        indexStatisticsDetails.setNumberOfValues(indexStatistics.getNumberOfValues());
        indexStatisticsDetails.setTotalUpdateTime(indexStatistics.getTotalUpdateTime());
        indexStatisticsDetails.setTotalUses(indexStatistics.getTotalUses());
        return indexStatisticsDetails;
    }

    public IndexDetails(DistributedMember member, Index index) {
        this(member.getId(), index.getRegion().getFullPath(), index.getName());
        this.setFromClause(index.getFromClause());
        this.setIndexedExpression(index.getIndexedExpression());
        this.setIndexType(index.getType());
        this.setMemberName(member.getName());
        this.setProjectionAttributes(index.getProjectionAttributes());
        this.setRegionName(index.getRegion().getName());
        if (index instanceof AbstractIndex) {
            this.setIsValid(((AbstractIndex)index).isValid());
        } else {
            this.setIsValid(false);
        }
        if (index.getStatistics() != null) {
            this.setIndexStatisticsDetails(IndexDetails.createIndexStatisticsDetails(index.getStatistics()));
        }
    }

    public void setIsValid(boolean valid) {
        this.isValid = valid;
    }

    public IndexDetails(String memberId, String regionPath, String indexName) {
        IndexDetails.assertValidArgument(StringUtils.isNotBlank((CharSequence)memberId), "The member having a region with an index must be specified!", new Object[0]);
        IndexDetails.assertValidArgument(StringUtils.isNotBlank((CharSequence)regionPath), "The region in member (%1$s) with an index must be specified!", memberId);
        IndexDetails.assertValidArgument(StringUtils.isNotBlank((CharSequence)indexName), "The name of the index on region (%1$s) of member (%2$s) must be specified!", regionPath, memberId);
        this.memberId = memberId;
        this.regionPath = regionPath;
        this.indexName = indexName;
    }

    public String getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = fromClause;
    }

    public String getIndexedExpression() {
        return this.indexedExpression;
    }

    public void setIndexedExpression(String indexedExpression) {
        this.indexedExpression = indexedExpression;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexStatisticsDetails getIndexStatisticsDetails() {
        return this.indexStatisticsDetails;
    }

    public void setIndexStatisticsDetails(IndexStatisticsDetails indexStatisticsDetails) {
        this.indexStatisticsDetails = indexStatisticsDetails;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getProjectionAttributes() {
        return this.projectionAttributes;
    }

    public void setProjectionAttributes(String projectionAttributes) {
        this.projectionAttributes = projectionAttributes;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    @Override
    public int compareTo(IndexDetails indexDetails) {
        int comparisonValue = IndexDetails.compare(this.getMemberName(), indexDetails.getMemberName());
        comparisonValue = comparisonValue != 0 ? comparisonValue : IndexDetails.compare(this.getMemberId(), indexDetails.getMemberId());
        comparisonValue = comparisonValue != 0 ? comparisonValue : IndexDetails.compare(this.getRegionPath(), indexDetails.getRegionPath());
        return comparisonValue != 0 ? comparisonValue : IndexDetails.compare(this.getIndexName(), indexDetails.getIndexName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IndexDetails)) {
            return false;
        }
        IndexDetails that = (IndexDetails)obj;
        return ObjectUtils.equals((Object)this.getMemberId(), (Object)that.getMemberId()) && ObjectUtils.equals((Object)this.getRegionPath(), (Object)that.getRegionPath()) && ObjectUtils.equals((Object)this.getIndexName(), (Object)that.getIndexName());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.hashCode((Object)this.getMemberId());
        hashValue = 37 * hashValue + ObjectUtils.hashCode((Object)this.getRegionPath());
        hashValue = 37 * hashValue + ObjectUtils.hashCode((Object)this.getIndexName());
        return hashValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append(" {fromClause = ").append(this.getFromClause());
        buffer.append(", indexExpression = ").append(this.getIndexedExpression());
        buffer.append(", indexName = ").append(this.getIndexName());
        buffer.append(", indexType = ").append(this.getIndexType().getName());
        buffer.append(", memberId = ").append(this.getMemberId());
        buffer.append(", memberName = ").append(this.getMemberName());
        buffer.append(", regionName = ").append(this.getRegionName());
        buffer.append(", regionPath = ").append(this.getRegionPath());
        buffer.append(", isValid = ").append(this.getIsValid());
        buffer.append(", projectAttributes = ").append(this.getProjectionAttributes());
        buffer.append("}");
        return buffer.toString();
    }

    public static class IndexStatisticsDetails
    implements Serializable {
        private Long numberOfKeys;
        private Long numberOfUpdates;
        private Long numberOfValues;
        private Long totalUpdateTime;
        private Long totalUses;

        public Long getNumberOfKeys() {
            return this.numberOfKeys;
        }

        public void setNumberOfKeys(Long numberOfKeys) {
            this.numberOfKeys = numberOfKeys;
        }

        public Long getNumberOfUpdates() {
            return this.numberOfUpdates;
        }

        public void setNumberOfUpdates(Long numberOfUpdates) {
            this.numberOfUpdates = numberOfUpdates;
        }

        public Long getNumberOfValues() {
            return this.numberOfValues;
        }

        public void setNumberOfValues(Long numberOfValues) {
            this.numberOfValues = numberOfValues;
        }

        public Long getTotalUpdateTime() {
            return this.totalUpdateTime;
        }

        public void setTotalUpdateTime(Long totalUpdateTime) {
            this.totalUpdateTime = totalUpdateTime;
        }

        public Long getTotalUses() {
            return this.totalUses;
        }

        public void setTotalUses(Long totalUses) {
            this.totalUses = totalUses;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append(" {numberOfKeys = ").append(this.getNumberOfKeys());
            buffer.append(", numberOfUpdates = ").append(this.getNumberOfUpdates());
            buffer.append(", numberOfValues = ").append(this.getNumberOfValues());
            buffer.append(", totalUpdateTime = ").append(this.getTotalUpdateTime());
            buffer.append(", totalUses").append(this.getTotalUses());
            buffer.append("}");
            return buffer.toString();
        }
    }
}

