/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.query.management.configuration.QueryConfigService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.functions.DescribeQueryServiceFunction;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

public class DescribeQueryServiceCommand
extends SingleGfshCommand {
    static final String COMMAND_NAME = "describe query-service";
    private static final String COMMAND_HELP = "Describes the clusters query service";
    static final String QUERY_SERVICE_DATA_SECTION = "QueryService";
    public static final String ALL_METHODS_ALLOWED = "Security is not enabled. All methods will be authorized.";
    public static final String FUNCTION_FAILED_ON_ALL_MEMBERS = "Function was not successful";
    public static final String NO_CLUSTER_CONFIG_AND_NO_MEMBERS = "No cluster config found and no distributed members found.";
    public static final String AUTHORIZER_CLASS_NAME = "Method Authorizer Class";

    @CliCommand(value={"describe query-service"}, help="Describes the clusters query service")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel execute() {
        QueryConfigService queryConfigService = this.getQueryConfigService();
        if (queryConfigService != null) {
            return this.constructResultModelFromQueryService(queryConfigService);
        }
        Set<DistributedMember> targetMembers = this.findMembers(null, null);
        if (targetMembers.size() > 0) {
            for (DistributedMember member : targetMembers) {
                CliFunctionResult result = this.executeFunctionAndGetFunctionResult((Function)new DescribeQueryServiceFunction(), null, member);
                if (!result.isSuccessful() || (queryConfigService = (QueryConfigService)result.getResultObject()) == null) continue;
                return this.constructResultModelFromQueryService(queryConfigService);
            }
            return ResultModel.createError(FUNCTION_FAILED_ON_ALL_MEMBERS);
        }
        return ResultModel.createError(NO_CLUSTER_CONFIG_AND_NO_MEMBERS);
    }

    QueryConfigService getQueryConfigService() {
        CacheConfig cacheConfig;
        InternalConfigurationPersistenceService configService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (configService != null && (cacheConfig = configService.getCacheConfig(null)) != null) {
            return (QueryConfigService)cacheConfig.findCustomCacheElement("query-config-service", QueryConfigService.class);
        }
        return null;
    }

    ResultModel constructResultModelFromQueryService(QueryConfigService queryConfigurationService) {
        ResultModel result = new ResultModel();
        this.addMethodAuthorizerToResultModel(queryConfigurationService, result);
        return result;
    }

    void addMethodAuthorizerToResultModel(QueryConfigService queryConfigurationService, ResultModel result) {
        QueryConfigService.MethodAuthorizer methodAuthorizer = queryConfigurationService.getMethodAuthorizer();
        DataResultModel dataResultModel = result.addData(QUERY_SERVICE_DATA_SECTION);
        if (methodAuthorizer != null) {
            if (this.isSecurityEnabled()) {
                dataResultModel.addData(AUTHORIZER_CLASS_NAME, methodAuthorizer.getClassName());
            } else {
                dataResultModel.addData(AUTHORIZER_CLASS_NAME, ALL_METHODS_ALLOWED);
            }
        }
    }

    boolean isSecurityEnabled() {
        return ((InternalCache)CacheFactory.getAnyInstance()).getSecurityService().isIntegratedSecurity();
    }
}

