/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.GroupableConfiguration;
import org.apache.geode.management.configuration.Region;
import org.apache.geode.management.internal.cli.functions.CreateIndexFunction;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateIndexCommand
extends GfshCommand {
    @Immutable
    private static final CreateIndexFunction createIndexFunction = new CreateIndexFunction();

    @CliCommand(value={"create index"}, help="Create an index that can be used when executing queries.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public ResultModel createIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the index to create.") String indexName, @CliOption(key={"expression"}, mandatory=true, help="Field of the region values that are referenced by the index.") String indexedExpression, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region which corresponds to the \"from\" clause in a query.") String regionPath, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member in which the index will be created.") String[] memberNameOrID, @CliOption(key={"type"}, unspecifiedDefaultValue="range", optionContext="geode.converter.index.type:disable-enum-converter", help="Type of the index. Valid values are: range and key. Deprecated: Since Geode 1.4, hash should not be used.") IndexType indexType, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group of members in which the index will be created. Value will be ignored when using cluster configuration.") String[] groups) {
        Set<DistributedMember> targetMembers;
        InternalConfigurationPersistenceService ccService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        ClusterManagementService cms = this.getClusterManagementService();
        ResultModel resultModel = new ResultModel();
        InfoResultModel info = resultModel.addInfo();
        String regionName = null;
        if (ccService != null && memberNameOrID == null) {
            regionName = this.getValidRegionName(regionPath, cms);
            Set<String> calculatedGroups = this.getGroupsContainingRegion(cms, regionName);
            if (calculatedGroups.isEmpty()) {
                return ResultModel.createError("Region " + regionName + " does not exist.");
            }
            if (groups != null && !calculatedGroups.containsAll(Arrays.asList(groups))) {
                return ResultModel.createError("Region " + regionName + " does not exist in some of the groups.");
            }
            if (groups == null) {
                groups = (String[])calculatedGroups.stream().filter(Objects::nonNull).toArray(String[]::new);
            }
            targetMembers = this.findMembers(groups, null);
        } else {
            targetMembers = this.findMembers(groups, memberNameOrID);
        }
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        RegionConfig.Index index = new RegionConfig.Index();
        index.setName(indexName);
        index.setExpression(indexedExpression);
        index.setFromClause(regionPath);
        if (indexType == IndexType.PRIMARY_KEY) {
            index.setKeyIndex(Boolean.valueOf(true));
        } else {
            index.setKeyIndex(Boolean.valueOf(false));
            index.setType(indexType.getName());
        }
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult((Function)createIndexFunction, index, targetMembers);
        resultModel.addTableAndSetStatus("createIndex", functionResults, true, false);
        if (!resultModel.isSuccessful()) {
            return resultModel;
        }
        if (ccService == null) {
            info.addLine("Cluster configuration service is not running. Configuration change is not persisted.");
            return resultModel;
        }
        if (memberNameOrID != null) {
            info.addLine("Configuration change is not persisted because the command is executed on specific member.");
            return resultModel;
        }
        InfoResultModel groupStatus = resultModel.addInfo("groupStatus");
        String finalRegionName = regionName;
        if (groups.length == 0) {
            groups = new String[]{"cluster"};
        }
        for (String group : groups) {
            ccService.updateCacheConfig(group, cacheConfig -> {
                RegionConfig regionConfig = cacheConfig.findRegionConfiguration(finalRegionName);
                regionConfig.getIndexes().add(index);
                groupStatus.addLine("Cluster configuration for group '" + group + "' is updated.");
                return cacheConfig;
            });
        }
        return resultModel;
    }

    String getValidRegionName(String regionPath, ClusterManagementService cms) {
        Set<String> groupsContainingRegion;
        String regionName = regionPath.trim().split(" ")[0];
        while (regionName.contains(".") && (groupsContainingRegion = this.getGroupsContainingRegion(cms, regionName)).isEmpty()) {
            regionName = regionName.substring(0, regionName.lastIndexOf("."));
        }
        return regionName;
    }

    Set<String> getGroupsContainingRegion(ClusterManagementService cms, String regionName) {
        Region regionConfig = new Region();
        regionConfig.setName(regionName);
        List regions = cms.list((AbstractConfiguration)regionConfig).getConfigResult();
        return regions.stream().map(GroupableConfiguration::getGroup).collect(Collectors.toSet());
    }
}

