/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.fop.render.pdf.pdfbox.Interceptors;
import org.apache.fop.render.pdf.pdfbox.PDFUtil;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.encryption.BadSecurityHandlerException;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.image.loader.util.SoftMapCache;
import org.apache.xmlgraphics.util.io.SubInputStream;

public class PreloaderPDF
extends AbstractImagePreloader {
    private static final String PDF_HEADER = "%PDF-";
    private static SoftMapCache pdfCache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo preloadImage(String uri, Source src, ImageContext context) throws IOException, ImageException {
        if (!ImageUtil.hasImageInputStream((Source)src)) {
            return null;
        }
        ImageInfo info = null;
        ImageInputStream in = ImageUtil.needImageInputStream((Source)src);
        in.mark();
        try {
            byte[] header = this.getHeader(in, PDF_HEADER.length());
            String s = new String(header, "US-ASCII");
            boolean supported = PDF_HEADER.equals(s);
            if (supported) {
                info = this.loadPDF(uri, src, context);
            }
            ImageInfo imageInfo = info;
            return imageInfo;
        }
        finally {
            if (info != null) {
                ImageUtil.closeQuietly((Source)src);
            } else {
                in.reset();
            }
        }
    }

    private static URI deriveDocumentURI(String uri) throws URISyntaxException {
        URI originalURI = new URI(URISpecification.escapeURI((String)uri));
        URI tempURI = new URI(originalURI.getScheme(), originalURI.getSchemeSpecificPart(), null);
        return tempURI;
    }

    private ImageInfo loadPDF(String uri, Source src, ImageContext context) throws IOException, ImageException {
        PDDocument pddoc;
        URI docURI;
        InputStream in = ImageUtil.needInputStream((Source)src);
        int selectedPage = ImageUtil.needPageIndexFromURI((String)uri);
        try {
            docURI = PreloaderPDF.deriveDocumentURI(src.getSystemId() != null ? src.getSystemId() : uri);
        }
        catch (URISyntaxException e) {
            docURI = null;
        }
        if (pdfCache != null && docURI != null) {
            pddoc = (PDDocument)pdfCache.get((Object)docURI);
            if (pddoc == null) {
                pddoc = PDDocument.load((InputStream)new SubInputStream(in, Integer.MAX_VALUE));
                pddoc = Interceptors.getInstance().interceptOnLoad(pddoc, docURI);
                pdfCache.put((Object)docURI, (Object)pddoc);
            }
        } else {
            pddoc = PDDocument.load((InputStream)new SubInputStream(in, Integer.MAX_VALUE));
            pddoc = Interceptors.getInstance().interceptOnLoad(pddoc, docURI);
        }
        pddoc.getDocument().setWarnMissingClose(false);
        if (pddoc.isEncrypted()) {
            StandardDecryptionMaterial dec = new StandardDecryptionMaterial("");
            try {
                pddoc.openProtection((DecryptionMaterial)dec);
            }
            catch (CryptographyException e) {
                this.notifyCouldNotDecrypt((Exception)((Object)e));
            }
            catch (BadSecurityHandlerException e) {
                this.notifyCouldNotDecrypt((Exception)((Object)e));
            }
        }
        int pageCount = pddoc.getNumberOfPages();
        if (selectedPage < 0 || selectedPage >= pageCount) {
            throw new ImageException("Selected page (index: " + selectedPage + ") does not exist in the PDF file. The document has " + pddoc.getNumberOfPages() + " pages.");
        }
        PDPage page = (PDPage)pddoc.getDocumentCatalog().getAllPages().get(selectedPage);
        PDRectangle mediaBox = page.findMediaBox();
        PDRectangle cropBox = page.findCropBox();
        PDRectangle viewBox = cropBox != null ? cropBox : mediaBox;
        int w = Math.round(viewBox.getWidth() * 1000.0f);
        int h = Math.round(viewBox.getHeight() * 1000.0f);
        int rotation = PDFUtil.getNormalizedRotation(page);
        if (rotation == 90 || rotation == 270) {
            int exch = w;
            w = h;
            h = exch;
        }
        ImageSize size = new ImageSize();
        size.setSizeInMillipoints(w, h);
        size.setResolution((double)context.getSourceResolution());
        size.calcPixelsFromSize();
        ImageInfo info = new ImageInfo(uri, "application/pdf");
        info.setSize(size);
        info.getCustomObjects().put(ImageInfo.ORIGINAL_IMAGE, new ImagePDF(info, pddoc));
        int lastPageIndex = pddoc.getNumberOfPages() - 1;
        if (selectedPage < lastPageIndex) {
            info.getCustomObjects().put(ImageInfo.HAS_MORE_IMAGES, Boolean.TRUE);
        }
        return info;
    }

    private void notifyCouldNotDecrypt(Exception e) throws ImageException {
        throw new ImageException("Error decrypting PDF: " + e.getMessage() + "\nPlease use an OnLoadInterceptor to provide " + "suitable decryption material (ex. a password).", (Throwable)e);
    }
}

