/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFFormXObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.PDFImageHandler;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.render.pdf.pdfbox.AbstractPDFBoxHandler;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;

public class PDFBoxPDFImageHandler
extends AbstractPDFBoxHandler
implements PDFImageHandler {
    protected static Log log = LogFactory.getLog((Class)PDFBoxPDFImageHandler.class);
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImagePDF.PDFBOX_IMAGE};

    public PDFXObject generateImage(RendererContext context, Image image, Point origin, Rectangle pos) throws IOException {
        PDFRenderer renderer = (PDFRenderer)context.getRenderer();
        ImagePDF pdfImage = (ImagePDF)image;
        PDFPage pdfPage = (PDFPage)context.getProperty("pdfPage");
        PDFFormXObject form = this.createFormForPDF(pdfImage, pdfPage);
        if (form == null) {
            return null;
        }
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        renderer.placeImage(x, y, w, h, (PDFXObject)form);
        return form;
    }

    public int getPriority() {
        return 50;
    }

    public Class getSupportedImageClass() {
        return ImagePDF.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }
}

