/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Map;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;

public class ImageConverterPDF2G2D
extends AbstractImageConverter {
    public Image convert(Image src, Map hints) throws ImageException, IOException {
        this.checkSourceFlavor(src);
        ImagePDF imgPDF = (ImagePDF)src;
        int selectedPage = ImageUtil.needPageIndexFromURI((String)src.getInfo().getOriginalURI());
        PDDocument pddoc = imgPDF.getPDDocument();
        PDPage page = (PDPage)pddoc.getDocumentCatalog().getAllPages().get(selectedPage);
        Graphics2DImagePainterPDF painter = new Graphics2DImagePainterPDF(page);
        ImageGraphics2D g2dImage = new ImageGraphics2D(src.getInfo(), (Graphics2DImagePainter)painter);
        return g2dImage;
    }

    public ImageFlavor getSourceFlavor() {
        return ImagePDF.PDFBOX_IMAGE;
    }

    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }

    public int getConversionPenalty() {
        return 1000;
    }

    private static class Graphics2DImagePainterPDF
    implements Graphics2DImagePainter {
        private final PDPage page;

        public Graphics2DImagePainterPDF(PDPage page) {
            this.page = page;
        }

        public Dimension getImageSize() {
            PDRectangle mediaBox = this.page.findMediaBox();
            int wmpt = (int)Math.ceil(mediaBox.getWidth() * 1000.0f);
            int hmpt = (int)Math.ceil(mediaBox.getHeight() * 1000.0f);
            return new Dimension(wmpt, hmpt);
        }

        public void paint(Graphics2D g2d, Rectangle2D area) {
            try {
                PDRectangle mediaBox = this.page.findMediaBox();
                Dimension pageDimension = mediaBox.createDimension();
                AffineTransform at = new AffineTransform();
                at.translate(area.getX(), area.getY());
                at.scale(area.getWidth() / (double)pageDimension.width, area.getHeight() / (double)pageDimension.height);
                g2d.transform(at);
                PageDrawer drawer = new PageDrawer();
                drawer.drawPage((Graphics)g2d, this.page, pageDimension);
            }
            catch (IOException ioe) {
                throw new RuntimeException("I/O error while painting PDF page", ioe);
            }
        }
    }
}

