/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.entrypoint;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.Utils;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.slf4j.Logger;

public class YarnEntrypointUtils {
    public static Configuration loadConfiguration(String workingDirectory, Configuration dynamicParameters, Map<String, String> env) {
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)workingDirectory, (Configuration)dynamicParameters);
        String keytabPrincipal = env.get("_KEYTAB_PRINCIPAL");
        String hostname = env.get(ApplicationConstants.Environment.NM_HOST.key());
        Preconditions.checkState((hostname != null ? 1 : 0) != 0, (String)"ApplicationMaster hostname variable %s not set", (Object[])new Object[]{ApplicationConstants.Environment.NM_HOST.key()});
        configuration.setString(JobManagerOptions.ADDRESS, hostname);
        configuration.setString(RestOptions.ADDRESS, hostname);
        if (configuration.getInteger(WebOptions.PORT, 0) >= 0) {
            configuration.setInteger(WebOptions.PORT, 0);
        }
        if (!configuration.contains(RestOptions.BIND_PORT)) {
            configuration.setString(RestOptions.BIND_PORT, "0");
        }
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)configuration, (String)"yarn.application-master.env.", (String)"containerized.master.env.");
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)configuration, (String)"yarn.taskmanager.env.", (String)"containerized.taskmanager.env.");
        String keytabPath = Utils.resolveKeytabPath(workingDirectory, env.get("_LOCAL_KEYTAB_PATH"));
        if (keytabPath != null && keytabPrincipal != null) {
            configuration.setString(SecurityOptions.KERBEROS_LOGIN_KEYTAB, keytabPath);
            configuration.setString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, keytabPrincipal);
        }
        String localDirs = env.get(ApplicationConstants.Environment.LOCAL_DIRS.key());
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)configuration, (String)localDirs);
        return configuration;
    }

    public static void logYarnEnvironmentInformation(Map<String, String> env, Logger log) throws IOException {
        String yarnClientUsername = env.get("HADOOP_USER_NAME");
        Preconditions.checkArgument((yarnClientUsername != null ? 1 : 0) != 0, (String)"YARN client user name environment variable %s not set", (Object[])new Object[]{"HADOOP_USER_NAME"});
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        log.info("YARN daemon is running as: {} Yarn client user obtainer: {}", (Object)currentUser.getShortUserName(), (Object)yarnClientUsername);
    }

    public static Optional<File> getUsrLibDir(Configuration configuration) {
        YarnConfigOptions.UserJarInclusion userJarInclusion = (YarnConfigOptions.UserJarInclusion)((Object)configuration.get(YarnConfigOptions.CLASSPATH_INCLUDE_USER_JAR));
        Optional<File> userLibDir = ClusterEntrypointUtils.tryFindUserLibDirectory();
        Preconditions.checkState((userJarInclusion != YarnConfigOptions.UserJarInclusion.DISABLED || userLibDir.isPresent() ? 1 : 0) != 0, (String)"The %s is set to %s. But the usrlib directory does not exist.", (Object[])new Object[]{YarnConfigOptions.CLASSPATH_INCLUDE_USER_JAR.key(), YarnConfigOptions.UserJarInclusion.DISABLED});
        return userJarInclusion == YarnConfigOptions.UserJarInclusion.DISABLED ? userLibDir : Optional.empty();
    }
}

