/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.state.operator.restore.unkeyed;

import org.apache.flink.FlinkVersion;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.state.operator.restore.AbstractOperatorRestoreTestBase;
import org.apache.flink.test.state.operator.restore.ExecutionMode;
import org.apache.flink.test.state.operator.restore.unkeyed.NonKeyedJob;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractNonKeyedOperatorRestoreTestBase
extends AbstractOperatorRestoreTestBase {
    protected AbstractNonKeyedOperatorRestoreTestBase(FlinkVersion flinkVersion) {
        super(flinkVersion);
    }

    @Override
    public void createMigrationJob(StreamExecutionEnvironment env) {
        SingleOutputStreamOperator<Integer> source = NonKeyedJob.createSource(env, ExecutionMode.MIGRATE);
        SingleOutputStreamOperator<Integer> first = NonKeyedJob.createFirstStatefulMap(ExecutionMode.MIGRATE, source);
        first.startNewChain();
        SingleOutputStreamOperator<Integer> second = NonKeyedJob.createSecondStatefulMap(ExecutionMode.MIGRATE, first);
        second.startNewChain();
        SingleOutputStreamOperator<Integer> stateless = NonKeyedJob.createStatelessMap(second);
        SingleOutputStreamOperator<Integer> third = NonKeyedJob.createThirdStatefulMap(ExecutionMode.MIGRATE, stateless);
    }

    @Override
    protected String getMigrationSavepointName(FlinkVersion flinkVersion) {
        return "nonKeyed-flink" + flinkVersion;
    }
}

