/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.state;

import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.contrib.streaming.state.EmbeddedRocksDBStateBackend;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackendBuilder;
import org.apache.flink.contrib.streaming.state.RocksDBResourceContainer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.CheckpointableKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.TestLocalRecoveryConfig;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackendBuilder;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSetFactory;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.junit.rules.TemporaryFolder;

public final class BackendSwitchSpecs {
    static final BackendSwitchSpec ROCKS = new RocksSpec(EmbeddedRocksDBStateBackend.PriorityQueueStateType.ROCKSDB);
    static final BackendSwitchSpec ROCKS_HEAP_TIMERS = new RocksSpec(EmbeddedRocksDBStateBackend.PriorityQueueStateType.HEAP);
    static final BackendSwitchSpec HEAP = new HeapSpec();

    private static final class HeapSpec
    implements BackendSwitchSpec {
        private HeapSpec() {
        }

        @Override
        public CheckpointableKeyedStateBackend<String> createBackend(KeyGroupRange keyGroupRange, int numKeyGroups, Collection<KeyedStateHandle> stateHandles) throws Exception {
            ExecutionConfig executionConfig = new ExecutionConfig();
            return new HeapKeyedStateBackendBuilder(new KvStateRegistry().createTaskRegistry(new JobID(), new JobVertexID()), (TypeSerializer)StringSerializer.INSTANCE, this.getClass().getClassLoader(), numKeyGroups, keyGroupRange, executionConfig, TtlTimeProvider.DEFAULT, LatencyTrackingStateConfig.disabled(), stateHandles, AbstractStateBackend.getCompressionDecorator((ExecutionConfig)executionConfig), TestLocalRecoveryConfig.disabled(), new HeapPriorityQueueSetFactory(keyGroupRange, numKeyGroups, 128), true, new CloseableRegistry()).build();
        }

        @Override
        public void close() throws Exception {
        }

        public String toString() {
            return "HEAP";
        }
    }

    private static final class RocksSpec
    implements BackendSwitchSpec {
        private final TemporaryFolder temporaryFolder = new TemporaryFolder();
        private final EmbeddedRocksDBStateBackend.PriorityQueueStateType queueStateType;

        public RocksSpec(EmbeddedRocksDBStateBackend.PriorityQueueStateType queueStateType) {
            this.queueStateType = queueStateType;
        }

        @Override
        public CheckpointableKeyedStateBackend<String> createBackend(KeyGroupRange keyGroupRange, int numKeyGroups, Collection<KeyedStateHandle> stateHandles) throws Exception {
            RocksDBResourceContainer optionsContainer = new RocksDBResourceContainer();
            this.temporaryFolder.create();
            return new RocksDBKeyedStateBackendBuilder("no-op", ClassLoader.getSystemClassLoader(), this.temporaryFolder.newFolder(), optionsContainer, stateName -> optionsContainer.getColumnOptions(), new KvStateRegistry().createTaskRegistry(new JobID(), new JobVertexID()), (TypeSerializer)StringSerializer.INSTANCE, numKeyGroups, keyGroupRange, new ExecutionConfig(), TestLocalRecoveryConfig.disabled(), this.queueStateType, TtlTimeProvider.DEFAULT, LatencyTrackingStateConfig.disabled(), (MetricGroup)new UnregisteredMetricsGroup(), stateHandles, UncompressedStreamCompressionDecorator.INSTANCE, new CloseableRegistry()).build();
        }

        @Override
        public void close() throws Exception {
            this.temporaryFolder.delete();
        }

        public String toString() {
            return "ROCKS(" + this.queueStateType + ")";
        }
    }

    public static interface BackendSwitchSpec
    extends AutoCloseable {
        public CheckpointableKeyedStateBackend<String> createBackend(KeyGroupRange var1, int var2, Collection<KeyedStateHandle> var3) throws Exception;
    }
}

