/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RegisterTypeWithKryoSerializerITCase
extends MultipleProgramsTestBase {
    public RegisterTypeWithKryoSerializerITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Test
    public void testRegisterTypeWithKryoSerializer() throws Exception {
        int numElements = 10;
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.registerTypeWithKryoSerializer(TestClass.class, (Serializer)new TestClassSerializer());
        DataSource input = env.generateSequence(0L, (long)(numElements - 1));
        MapOperator mapped = input.map((MapFunction)new MapFunction<Long, TestClass>(){
            private static final long serialVersionUID = -529116076312998262L;

            public TestClass map(Long value) throws Exception {
                return new TestClass(value);
            }
        });
        ArrayList<TestClass> expected = new ArrayList<TestClass>(numElements);
        for (int i = 0; i < numElements; ++i) {
            expected.add(new TestClass(42L));
        }
        TestBaseUtils.compareResultCollections(expected, (List)mapped.collect(), (Comparator)new Comparator<TestClass>(){

            @Override
            public int compare(TestClass o1, TestClass o2) {
                return (int)(o1.getValue() - o2.getValue());
            }
        });
    }

    static class TestClassSerializer
    extends Serializer<TestClass>
    implements Serializable {
        private static final long serialVersionUID = -3585880741695717533L;

        TestClassSerializer() {
        }

        public void write(Kryo kryo, Output output, TestClass testClass) {
            output.writeLong(42L);
        }

        public TestClass read(Kryo kryo, Input input, Class<TestClass> aClass) {
            return new TestClass(input.readLong());
        }
    }

    static class TestClass {
        private final long value;
        private Object obj = new Object();

        public TestClass(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public String toString() {
            return "TestClass(" + this.value + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof TestClass) {
                TestClass other = (TestClass)obj;
                return this.value == other.value;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.value;
        }
    }
}

