/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime;

import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.test.runtime.BatchShuffleITCaseBase;
import org.junit.jupiter.api.Test;

class HybridShuffleITCase
extends BatchShuffleITCaseBase {
    HybridShuffleITCase() {
    }

    @Test
    void testHybridFullExchanges() throws Exception {
        int numRecordsToSend = 10000;
        Configuration configuration = this.getConfiguration();
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_HYBRID_FULL);
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_ENABLE_NEW_MODE, (Object)false);
        JobGraph jobGraph = this.createJobGraph(10000, false, configuration);
        this.executeJob(jobGraph, configuration, 10000);
    }

    @Test
    void testHybridSelectiveExchanges() throws Exception {
        int numRecordsToSend = 10000;
        Configuration configuration = this.getConfiguration();
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_HYBRID_SELECTIVE);
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_ENABLE_NEW_MODE, (Object)false);
        JobGraph jobGraph = this.createJobGraph(10000, false, configuration);
        this.executeJob(jobGraph, configuration, 10000);
    }

    @Test
    void testHybridFullExchangesRestart() throws Exception {
        int numRecordsToSend = 10;
        Configuration configuration = this.getConfiguration();
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_HYBRID_FULL);
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_ENABLE_NEW_MODE, (Object)false);
        JobGraph jobGraph = this.createJobGraph(10, true, configuration);
        this.executeJob(jobGraph, configuration, 10);
    }

    @Test
    void testHybridSelectiveExchangesRestart() throws Exception {
        int numRecordsToSend = 10;
        Configuration configuration = this.getConfiguration();
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_HYBRID_SELECTIVE);
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_ENABLE_NEW_MODE, (Object)false);
        JobGraph jobGraph = this.createJobGraph(10, true, configuration);
        this.executeJob(jobGraph, configuration, 10);
    }
}

