/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window;

import java.time.Duration;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceTableAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunctionBase;
import org.apache.flink.table.runtime.generated.NamespaceTableAggsHandleFunction;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.window.AggregateWindowOperator;
import org.apache.flink.table.runtime.operators.window.TableAggregateWindowOperator;
import org.apache.flink.table.runtime.operators.window.WindowOperator;
import org.apache.flink.table.runtime.operators.window.assigners.CountSlidingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.CountTumblingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.CumulativeWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.InternalTimeWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.SessionWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.SlidingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.TumblingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.triggers.ElementTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.EventTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.ProcessingTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.Trigger;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

public class WindowOperatorBuilder {
    protected LogicalType[] inputFieldTypes;
    protected WindowAssigner<?> windowAssigner;
    protected Trigger<?> trigger;
    protected LogicalType[] accumulatorTypes;
    protected LogicalType[] aggResultTypes;
    protected LogicalType[] windowPropertyTypes;
    protected long allowedLateness = 0L;
    protected boolean produceUpdates = false;
    protected int rowtimeIndex = -1;

    public static WindowOperatorBuilder builder() {
        return new WindowOperatorBuilder();
    }

    public WindowOperatorBuilder withInputFields(LogicalType[] inputFieldTypes) {
        this.inputFieldTypes = inputFieldTypes;
        return this;
    }

    public WindowOperatorBuilder tumble(Duration size) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        this.windowAssigner = TumblingWindowAssigner.of(size);
        return this;
    }

    public WindowOperatorBuilder sliding(Duration size, Duration slide) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        this.windowAssigner = SlidingWindowAssigner.of(size, slide);
        return this;
    }

    public WindowOperatorBuilder cumulative(Duration size, Duration step) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        this.windowAssigner = CumulativeWindowAssigner.of(size, step);
        return this;
    }

    public WindowOperatorBuilder session(Duration sessionGap) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        this.windowAssigner = SessionWindowAssigner.withGap(sessionGap);
        return this;
    }

    public WindowOperatorBuilder countWindow(long size) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.trigger == null ? 1 : 0) != 0);
        this.windowAssigner = CountTumblingWindowAssigner.of(size);
        this.trigger = ElementTriggers.count(size);
        return this;
    }

    public WindowOperatorBuilder countWindow(long size, long slide) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.trigger == null ? 1 : 0) != 0);
        this.windowAssigner = CountSlidingWindowAssigner.of(size, slide);
        this.trigger = ElementTriggers.count(size);
        return this;
    }

    public WindowOperatorBuilder assigner(WindowAssigner<?> windowAssigner) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        Preconditions.checkNotNull(windowAssigner);
        this.windowAssigner = windowAssigner;
        return this;
    }

    public WindowOperatorBuilder triggering(Trigger<?> trigger) {
        Preconditions.checkNotNull(trigger);
        this.trigger = trigger;
        return this;
    }

    public WindowOperatorBuilder withEventTime(int rowtimeIndex) {
        Preconditions.checkNotNull(this.windowAssigner);
        Preconditions.checkArgument((boolean)(this.windowAssigner instanceof InternalTimeWindowAssigner));
        InternalTimeWindowAssigner timeWindowAssigner = (InternalTimeWindowAssigner)((Object)this.windowAssigner);
        this.windowAssigner = (WindowAssigner)((Object)timeWindowAssigner.withEventTime());
        this.rowtimeIndex = rowtimeIndex;
        if (this.trigger == null) {
            this.trigger = EventTimeTriggers.afterEndOfWindow();
        }
        return this;
    }

    public WindowOperatorBuilder withProcessingTime() {
        Preconditions.checkNotNull(this.windowAssigner);
        Preconditions.checkArgument((boolean)(this.windowAssigner instanceof InternalTimeWindowAssigner));
        InternalTimeWindowAssigner timeWindowAssigner = (InternalTimeWindowAssigner)((Object)this.windowAssigner);
        this.windowAssigner = (WindowAssigner)((Object)timeWindowAssigner.withProcessingTime());
        if (this.trigger == null) {
            this.trigger = ProcessingTimeTriggers.afterEndOfWindow();
        }
        return this;
    }

    public WindowOperatorBuilder withAllowedLateness(Duration allowedLateness) {
        Preconditions.checkArgument((!allowedLateness.isNegative() ? 1 : 0) != 0);
        if (allowedLateness.toMillis() > 0L) {
            this.allowedLateness = allowedLateness.toMillis();
        }
        return this;
    }

    public WindowOperatorBuilder produceUpdates() {
        this.produceUpdates = true;
        return this;
    }

    protected void aggregate(LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes) {
        this.accumulatorTypes = accumulatorTypes;
        this.aggResultTypes = aggResultTypes;
        this.windowPropertyTypes = windowPropertyTypes;
    }

    public AggregateWindowOperatorBuilder aggregate(NamespaceAggsHandleFunction<?> aggregateFunction, RecordEqualiser equaliser, LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes) {
        this.aggregate(accumulatorTypes, aggResultTypes, windowPropertyTypes);
        return new AggregateWindowOperatorBuilder(aggregateFunction, equaliser, this);
    }

    public AggregateWindowOperatorBuilder aggregate(GeneratedNamespaceAggsHandleFunction<?> generatedAggregateFunction, GeneratedRecordEqualiser generatedEqualiser, LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes) {
        this.aggregate(accumulatorTypes, aggResultTypes, windowPropertyTypes);
        return new AggregateWindowOperatorBuilder(generatedAggregateFunction, generatedEqualiser, this);
    }

    public TableAggregateWindowOperatorBuilder aggregate(NamespaceTableAggsHandleFunction<?> tableAggregateFunction, LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes) {
        this.aggregate(accumulatorTypes, aggResultTypes, windowPropertyTypes);
        return new TableAggregateWindowOperatorBuilder(tableAggregateFunction, this);
    }

    public TableAggregateWindowOperatorBuilder aggregate(GeneratedNamespaceTableAggsHandleFunction<?> generatedTableAggregateFunction, LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes) {
        this.aggregate(accumulatorTypes, aggResultTypes, windowPropertyTypes);
        return new TableAggregateWindowOperatorBuilder(generatedTableAggregateFunction, this);
    }

    @VisibleForTesting
    WindowOperator aggregateAndBuild(NamespaceAggsHandleFunctionBase<?> aggregateFunction, RecordEqualiser equaliser, LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes) {
        this.aggregate(accumulatorTypes, aggResultTypes, windowPropertyTypes);
        if (aggregateFunction instanceof NamespaceAggsHandleFunction) {
            return new AggregateWindowOperatorBuilder((NamespaceAggsHandleFunction)aggregateFunction, equaliser, this).build();
        }
        return new TableAggregateWindowOperatorBuilder((NamespaceTableAggsHandleFunction)aggregateFunction, this).build();
    }

    public static class AggregateWindowOperatorBuilder {
        private NamespaceAggsHandleFunction<?> aggregateFunction;
        private GeneratedNamespaceAggsHandleFunction<?> generatedAggregateFunction;
        private RecordEqualiser equaliser;
        private GeneratedRecordEqualiser generatedEqualiser;
        private WindowOperatorBuilder windowOperatorBuilder;

        public AggregateWindowOperatorBuilder(GeneratedNamespaceAggsHandleFunction<?> generatedAggregateFunction, GeneratedRecordEqualiser generatedEqualiser, WindowOperatorBuilder windowOperatorBuilder) {
            this.generatedAggregateFunction = generatedAggregateFunction;
            this.generatedEqualiser = generatedEqualiser;
            this.windowOperatorBuilder = windowOperatorBuilder;
        }

        public AggregateWindowOperatorBuilder(NamespaceAggsHandleFunction<?> aggregateFunction, RecordEqualiser equaliser, WindowOperatorBuilder windowOperatorBuilder) {
            this.aggregateFunction = aggregateFunction;
            this.equaliser = equaliser;
            this.windowOperatorBuilder = windowOperatorBuilder;
        }

        public AggregateWindowOperator build() {
            Preconditions.checkNotNull(this.windowOperatorBuilder.trigger, (String)"trigger is not set");
            if (this.generatedAggregateFunction != null && this.generatedEqualiser != null) {
                return new AggregateWindowOperator(this.generatedAggregateFunction, this.generatedEqualiser, this.windowOperatorBuilder.windowAssigner, this.windowOperatorBuilder.trigger, this.windowOperatorBuilder.windowAssigner.getWindowSerializer(new ExecutionConfig()), this.windowOperatorBuilder.inputFieldTypes, this.windowOperatorBuilder.accumulatorTypes, this.windowOperatorBuilder.aggResultTypes, this.windowOperatorBuilder.windowPropertyTypes, this.windowOperatorBuilder.rowtimeIndex, this.windowOperatorBuilder.produceUpdates, this.windowOperatorBuilder.allowedLateness);
            }
            return new AggregateWindowOperator(this.aggregateFunction, this.equaliser, this.windowOperatorBuilder.windowAssigner, this.windowOperatorBuilder.trigger, this.windowOperatorBuilder.windowAssigner.getWindowSerializer(new ExecutionConfig()), this.windowOperatorBuilder.inputFieldTypes, this.windowOperatorBuilder.accumulatorTypes, this.windowOperatorBuilder.aggResultTypes, this.windowOperatorBuilder.windowPropertyTypes, this.windowOperatorBuilder.rowtimeIndex, this.windowOperatorBuilder.produceUpdates, this.windowOperatorBuilder.allowedLateness);
        }
    }

    public static class TableAggregateWindowOperatorBuilder {
        private NamespaceTableAggsHandleFunction<?> tableAggregateFunction;
        private GeneratedNamespaceTableAggsHandleFunction<?> generatedTableAggregateFunction;
        private WindowOperatorBuilder windowOperatorBuilder;

        public TableAggregateWindowOperatorBuilder(NamespaceTableAggsHandleFunction<?> tableAggregateFunction, WindowOperatorBuilder windowOperatorBuilder) {
            this.tableAggregateFunction = tableAggregateFunction;
            this.windowOperatorBuilder = windowOperatorBuilder;
        }

        public TableAggregateWindowOperatorBuilder(GeneratedNamespaceTableAggsHandleFunction<?> generatedTableAggregateFunction, WindowOperatorBuilder windowOperatorBuilder) {
            this.generatedTableAggregateFunction = generatedTableAggregateFunction;
            this.windowOperatorBuilder = windowOperatorBuilder;
        }

        public WindowOperator build() {
            Preconditions.checkNotNull(this.windowOperatorBuilder.trigger, (String)"trigger is not set");
            if (this.generatedTableAggregateFunction != null) {
                return new TableAggregateWindowOperator(this.generatedTableAggregateFunction, this.windowOperatorBuilder.windowAssigner, this.windowOperatorBuilder.trigger, this.windowOperatorBuilder.windowAssigner.getWindowSerializer(new ExecutionConfig()), this.windowOperatorBuilder.inputFieldTypes, this.windowOperatorBuilder.accumulatorTypes, this.windowOperatorBuilder.aggResultTypes, this.windowOperatorBuilder.windowPropertyTypes, this.windowOperatorBuilder.rowtimeIndex, this.windowOperatorBuilder.produceUpdates, this.windowOperatorBuilder.allowedLateness);
            }
            return new TableAggregateWindowOperator(this.tableAggregateFunction, this.windowOperatorBuilder.windowAssigner, this.windowOperatorBuilder.trigger, this.windowOperatorBuilder.windowAssigner.getWindowSerializer(new ExecutionConfig()), this.windowOperatorBuilder.inputFieldTypes, this.windowOperatorBuilder.accumulatorTypes, this.windowOperatorBuilder.aggResultTypes, this.windowOperatorBuilder.windowPropertyTypes, this.windowOperatorBuilder.rowtimeIndex, this.windowOperatorBuilder.produceUpdates, this.windowOperatorBuilder.allowedLateness);
        }
    }
}

