/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput;

import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.InputSelection;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.multipleinput.MultipleInputStreamOperatorBase;
import org.apache.flink.table.runtime.operators.multipleinput.TableOperatorWrapper;
import org.apache.flink.table.runtime.operators.multipleinput.input.InputSelectionHandler;
import org.apache.flink.table.runtime.operators.multipleinput.input.InputSpec;
import org.apache.flink.util.Preconditions;

public class BatchMultipleInputStreamOperator
extends MultipleInputStreamOperatorBase
implements BoundedMultiInput,
InputSelectable {
    private static final long serialVersionUID = 1L;
    private final InputSelectionHandler inputSelectionHandler;

    public BatchMultipleInputStreamOperator(StreamOperatorParameters<RowData> parameters, List<InputSpec> inputSpecs, List<TableOperatorWrapper<?>> headWrapper, TableOperatorWrapper<?> tailWrapper) {
        super(parameters, inputSpecs, headWrapper, tailWrapper);
        this.inputSelectionHandler = new InputSelectionHandler(inputSpecs);
    }

    public void endInput(int inputId) throws Exception {
        this.inputSelectionHandler.endInput(inputId);
        InputSpec inputSpec = (InputSpec)this.inputSpecMap.get(inputId);
        inputSpec.getOutput().endOperatorInput(inputSpec.getOutputOpInputId());
    }

    public InputSelection nextSelection() {
        return this.inputSelectionHandler.getInputSelection();
    }

    @Override
    protected StreamConfig createStreamConfig(StreamOperatorParameters<RowData> multipleInputOperatorParameters, TableOperatorWrapper<?> wrapper) {
        StreamConfig streamConfig = super.createStreamConfig(multipleInputOperatorParameters, wrapper);
        Preconditions.checkState((wrapper.getManagedMemoryFraction() >= 0.0 ? 1 : 0) != 0);
        Configuration taskManagerConfig = this.getRuntimeContext().getTaskManagerRuntimeInfo().getConfiguration();
        double managedMemoryFraction = multipleInputOperatorParameters.getStreamConfig().getManagedMemoryFractionOperatorUseCaseOfSlot(ManagedMemoryUseCase.BATCH_OP, taskManagerConfig, this.getRuntimeContext().getUserCodeClassLoader()) * wrapper.getManagedMemoryFraction();
        streamConfig.setManagedMemoryFractionOperatorOfUseCase(ManagedMemoryUseCase.BATCH_OP, managedMemoryFraction);
        return streamConfig;
    }
}

