/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state.restore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.contrib.streaming.state.RocksDBNativeMetricMonitor;
import org.apache.flink.contrib.streaming.state.RocksDBNativeMetricOptions;
import org.apache.flink.contrib.streaming.state.RocksDBOperationUtils;
import org.apache.flink.contrib.streaming.state.restore.RocksDBRestoreOperation;
import org.apache.flink.contrib.streaming.state.restore.RocksDBRestoreResult;
import org.apache.flink.contrib.streaming.state.ttl.RocksDbTtlCompactFiltersManager;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedBackendSerializationProxy;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.StateMigrationException;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRocksDBRestoreOperation<K>
implements RocksDBRestoreOperation,
AutoCloseable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final KeyGroupRange keyGroupRange;
    protected final int keyGroupPrefixBytes;
    protected final int numberOfTransferringThreads;
    protected final CloseableRegistry cancelStreamRegistry;
    protected final ClassLoader userCodeClassLoader;
    protected final Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory;
    protected final DBOptions dbOptions;
    protected final Map<String, RocksDBKeyedStateBackend.RocksDbKvStateInfo> kvStateInformation;
    protected final File instanceBasePath;
    protected final File instanceRocksDBPath;
    protected final String dbPath;
    protected List<ColumnFamilyHandle> columnFamilyHandles;
    protected List<ColumnFamilyDescriptor> columnFamilyDescriptors;
    protected final StateSerializerProvider<K> keySerializerProvider;
    protected final RocksDBNativeMetricOptions nativeMetricOptions;
    protected final MetricGroup metricGroup;
    protected final Collection<KeyedStateHandle> restoreStateHandles;
    protected final RocksDbTtlCompactFiltersManager ttlCompactFiltersManager;
    protected RocksDB db;
    protected ColumnFamilyHandle defaultColumnFamilyHandle;
    protected RocksDBNativeMetricMonitor nativeMetricMonitor;
    protected boolean isKeySerializerCompatibilityChecked;
    protected final Long writeBufferManagerCapacity;

    protected AbstractRocksDBRestoreOperation(KeyGroupRange keyGroupRange, int keyGroupPrefixBytes, int numberOfTransferringThreads, CloseableRegistry cancelStreamRegistry, ClassLoader userCodeClassLoader, Map<String, RocksDBKeyedStateBackend.RocksDbKvStateInfo> kvStateInformation, StateSerializerProvider<K> keySerializerProvider, File instanceBasePath, File instanceRocksDBPath, DBOptions dbOptions, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, RocksDBNativeMetricOptions nativeMetricOptions, MetricGroup metricGroup, @Nonnull Collection<KeyedStateHandle> stateHandles, @Nonnull RocksDbTtlCompactFiltersManager ttlCompactFiltersManager, Long writeBufferManagerCapacity) {
        this.keyGroupRange = keyGroupRange;
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
        this.numberOfTransferringThreads = numberOfTransferringThreads;
        this.cancelStreamRegistry = cancelStreamRegistry;
        this.userCodeClassLoader = userCodeClassLoader;
        this.kvStateInformation = kvStateInformation;
        this.keySerializerProvider = keySerializerProvider;
        this.instanceBasePath = instanceBasePath;
        this.instanceRocksDBPath = instanceRocksDBPath;
        this.dbPath = instanceRocksDBPath.getAbsolutePath();
        this.dbOptions = dbOptions;
        this.columnFamilyOptionsFactory = columnFamilyOptionsFactory;
        this.nativeMetricOptions = nativeMetricOptions;
        this.metricGroup = metricGroup;
        this.restoreStateHandles = stateHandles;
        this.ttlCompactFiltersManager = ttlCompactFiltersManager;
        this.columnFamilyHandles = new ArrayList<ColumnFamilyHandle>(1);
        this.columnFamilyDescriptors = Collections.emptyList();
        this.writeBufferManagerCapacity = writeBufferManagerCapacity;
    }

    void openDB() throws IOException {
        this.db = RocksDBOperationUtils.openDB(this.dbPath, this.columnFamilyDescriptors, this.columnFamilyHandles, RocksDBOperationUtils.createColumnFamilyOptions(this.columnFamilyOptionsFactory, "default"), this.dbOptions);
        this.defaultColumnFamilyHandle = this.columnFamilyHandles.remove(0);
        this.nativeMetricMonitor = this.nativeMetricOptions.isEnabled() ? new RocksDBNativeMetricMonitor(this.nativeMetricOptions, this.metricGroup, this.db) : null;
    }

    public RocksDB getDb() {
        return this.db;
    }

    RocksDBKeyedStateBackend.RocksDbKvStateInfo getOrRegisterStateColumnFamilyHandle(ColumnFamilyHandle columnFamilyHandle, StateMetaInfoSnapshot stateMetaInfoSnapshot) {
        RocksDBKeyedStateBackend.RocksDbKvStateInfo registeredStateMetaInfoEntry = this.kvStateInformation.get(stateMetaInfoSnapshot.getName());
        if (null == registeredStateMetaInfoEntry) {
            RegisteredStateMetaInfoBase stateMetaInfo = RegisteredStateMetaInfoBase.fromMetaInfoSnapshot((StateMetaInfoSnapshot)stateMetaInfoSnapshot);
            registeredStateMetaInfoEntry = columnFamilyHandle == null ? RocksDBOperationUtils.createStateInfo(stateMetaInfo, this.db, this.columnFamilyOptionsFactory, this.ttlCompactFiltersManager, this.writeBufferManagerCapacity) : new RocksDBKeyedStateBackend.RocksDbKvStateInfo(columnFamilyHandle, stateMetaInfo);
            RocksDBOperationUtils.registerKvStateInformation(this.kvStateInformation, this.nativeMetricMonitor, stateMetaInfoSnapshot.getName(), registeredStateMetaInfoEntry);
        }
        return registeredStateMetaInfoEntry;
    }

    KeyedBackendSerializationProxy<K> readMetaData(DataInputView dataInputView) throws IOException, StateMigrationException {
        KeyedBackendSerializationProxy serializationProxy = new KeyedBackendSerializationProxy(this.userCodeClassLoader);
        serializationProxy.read(dataInputView);
        if (!this.isKeySerializerCompatibilityChecked) {
            TypeSerializer currentSerializer = this.keySerializerProvider.currentSchemaSerializer();
            TypeSerializerSchemaCompatibility keySerializerSchemaCompat = this.keySerializerProvider.setPreviousSerializerSnapshotForRestoredState(serializationProxy.getKeySerializerSnapshot());
            if (keySerializerSchemaCompat.isCompatibleAfterMigration() || keySerializerSchemaCompat.isIncompatible()) {
                throw new StateMigrationException("The new key serializer (" + currentSerializer + ") must be compatible with the previous key serializer (" + this.keySerializerProvider.previousSchemaSerializer() + ").");
            }
            this.isKeySerializerCompatibilityChecked = true;
        }
        return serializationProxy;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.defaultColumnFamilyHandle);
        IOUtils.closeQuietly((AutoCloseable)this.nativeMetricMonitor);
        IOUtils.closeQuietly((AutoCloseable)this.db);
        this.columnFamilyDescriptors.forEach(cfd -> IOUtils.closeQuietly((AutoCloseable)cfd.getOptions()));
    }

    @Override
    public abstract RocksDBRestoreResult restore() throws Exception;
}

