/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.SqlPartitionUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;

public class SqlDropPartitions
extends SqlAlterTable {
    private final boolean ifExists;
    private final List<SqlNodeList> partSpecs;

    public SqlDropPartitions(SqlParserPos pos, SqlIdentifier tableName, boolean ifExists, List<SqlNodeList> partSpecs) {
        super(pos, tableName);
        this.ifExists = ifExists;
        this.partSpecs = partSpecs;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public List<SqlNodeList> getPartSpecs() {
        return this.partSpecs;
    }

    public LinkedHashMap<String, String> getPartitionKVs(int i) {
        return SqlPartitionUtils.getPartitionKVs(this.getPartSpecs().get(i));
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.newlineAndIndent();
        writer.keyword("DROP");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        int opLeftPrec = this.getOperator().getLeftPrec();
        int opRightPrec = this.getOperator().getRightPrec();
        SqlWriter.Frame frame = writer.startList("", "");
        for (SqlNodeList partSpec : this.partSpecs) {
            writer.sep(",");
            writer.newlineAndIndent();
            writer.keyword("PARTITION");
            partSpec.unparse(writer, opLeftPrec, opRightPrec);
        }
        writer.endList(frame);
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> operands = new ArrayList<SqlNode>();
        operands.add((SqlNode)this.tableIdentifier);
        operands.addAll(this.partSpecs);
        return operands;
    }
}

