/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.StreamCompressionDecorator;

public class CompressibleFSDataOutputStream
extends FSDataOutputStream {
    private final FSDataOutputStream delegate;
    private final OutputStream compressingDelegate;

    public CompressibleFSDataOutputStream(CheckpointStateOutputStream delegate, StreamCompressionDecorator compressionDecorator) throws IOException {
        this.delegate = delegate;
        this.compressingDelegate = compressionDecorator.decorateWithCompression((OutputStream)((Object)delegate));
    }

    public long getPos() throws IOException {
        return this.delegate.getPos();
    }

    public void write(int b) throws IOException {
        this.compressingDelegate.write(b);
    }

    public void flush() throws IOException {
        this.compressingDelegate.flush();
    }

    public void sync() throws IOException {
        this.delegate.sync();
    }

    public void close() throws IOException {
        this.compressingDelegate.close();
    }
}

