/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.queryablestate.client.state.ImmutableState;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.util.Preconditions;

public final class ImmutableMapState<K, V>
extends ImmutableState
implements MapState<K, V> {
    private final Map<K, V> state;

    private ImmutableMapState(Map<K, V> mapState) {
        this.state = (Map)Preconditions.checkNotNull(mapState);
    }

    public V get(K key) {
        return this.state.get(key);
    }

    public void put(K key, V value) {
        throw MODIFICATION_ATTEMPT_ERROR;
    }

    public void putAll(Map<K, V> map) {
        throw MODIFICATION_ATTEMPT_ERROR;
    }

    public void remove(K key) {
        throw MODIFICATION_ATTEMPT_ERROR;
    }

    public boolean contains(K key) {
        return this.state.containsKey(key);
    }

    public Iterable<Map.Entry<K, V>> entries() {
        return Collections.unmodifiableSet(this.state.entrySet());
    }

    public Iterable<K> keys() {
        return Collections.unmodifiableSet(this.state.keySet());
    }

    public Iterable<V> values() {
        return Collections.unmodifiableCollection(this.state.values());
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        return Collections.unmodifiableSet(this.state.entrySet()).iterator();
    }

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public void clear() {
        throw MODIFICATION_ATTEMPT_ERROR;
    }

    public static <K, V, T, S extends State> S createState(StateDescriptor<S, T> stateDescriptor, byte[] serializedState) throws IOException {
        MapStateDescriptor mapStateDescriptor = (MapStateDescriptor)stateDescriptor;
        Map state = KvStateSerializer.deserializeMap(serializedState, mapStateDescriptor.getKeySerializer(), mapStateDescriptor.getValueSerializer());
        return (S)new ImmutableMapState(state);
    }
}

