/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.wordcount;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.examples.wordcount.util.WordCountData;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class WordCount {
    public static void main(String[] args) throws Exception {
        MultipleParameterTool params = MultipleParameterTool.fromArgs((String[])args);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        DataStreamSource text = null;
        if (params.has("input")) {
            for (String input : params.getMultiParameterRequired("input")) {
                if (text == null) {
                    text = env.readTextFile(input);
                    continue;
                }
                text = text.union(new DataStream[]{env.readTextFile(input)});
            }
            Preconditions.checkNotNull((Object)text, (String)"Input DataStream should not be null.");
        } else {
            System.out.println("Executing WordCount example with default input data set.");
            System.out.println("Use --input to specify file input.");
            text = env.fromElements((Object[])WordCountData.WORDS);
        }
        SingleOutputStreamOperator counts = text.flatMap((FlatMapFunction)new Tokenizer()).keyBy(new int[]{0}).sum(1);
        if (params.has("output")) {
            counts.writeAsText(params.get("output"));
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            counts.print();
        }
        env.execute("Streaming WordCount");
    }

    public static final class Tokenizer
    implements FlatMapFunction<String, Tuple2<String, Integer>> {
        public void flatMap(String value, Collector<Tuple2<String, Integer>> out) {
            String[] tokens;
            for (String token : tokens = value.toLowerCase().split("\\W+")) {
                if (token.length() <= 0) continue;
                out.collect((Object)new Tuple2((Object)token, (Object)1));
            }
        }
    }
}

