/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.changelog.SequenceNumber;
import org.apache.flink.runtime.state.changelog.StateChange;

@ThreadSafe
@Internal
public class StateChangeSet {
    private final UUID logId;
    private final List<StateChange> changes;
    private final SequenceNumber sequenceNumber;

    public StateChangeSet(UUID logId, SequenceNumber sequenceNumber, List<StateChange> changes) {
        this.logId = logId;
        this.changes = Collections.unmodifiableList(changes);
        this.sequenceNumber = sequenceNumber;
    }

    public UUID getLogId() {
        return this.logId;
    }

    public SequenceNumber getSequenceNumber() {
        return this.sequenceNumber;
    }

    public List<StateChange> getChanges() {
        return this.changes;
    }

    public long getSize() {
        long size = 0L;
        for (StateChange change : this.changes) {
            size += (long)change.getChange().length;
        }
        return size;
    }

    public String toString() {
        return "logId=" + this.logId + ", sequenceNumber=" + this.sequenceNumber + ", changes=" + this.changes;
    }
}

