/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.table.config;

import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.PartitionStrategy;
import org.apache.flink.connector.mongodb.table.FilterHandlingPolicy;
import org.apache.flink.connector.mongodb.table.MongoConnectorOptions;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.factories.FactoryUtil;

@Internal
public class MongoConfiguration {
    private final ReadableConfig config;

    public MongoConfiguration(ReadableConfig config) {
        this.config = config;
    }

    public String getUri() {
        return (String)this.config.get(MongoConnectorOptions.URI);
    }

    public String getDatabase() {
        return (String)this.config.get(MongoConnectorOptions.DATABASE);
    }

    public String getCollection() {
        return (String)this.config.get(MongoConnectorOptions.COLLECTION);
    }

    public int getFetchSize() {
        return (Integer)this.config.get(MongoConnectorOptions.SCAN_FETCH_SIZE);
    }

    public boolean isNoCursorTimeout() {
        return (Boolean)this.config.get(MongoConnectorOptions.SCAN_CURSOR_NO_TIMEOUT);
    }

    public PartitionStrategy getPartitionStrategy() {
        return (PartitionStrategy)((Object)this.config.get(MongoConnectorOptions.SCAN_PARTITION_STRATEGY));
    }

    public MemorySize getPartitionSize() {
        return (MemorySize)this.config.get(MongoConnectorOptions.SCAN_PARTITION_SIZE);
    }

    public int getSamplesPerPartition() {
        return (Integer)this.config.get(MongoConnectorOptions.SCAN_PARTITION_SAMPLES);
    }

    public Integer getPartitionRecordSize() {
        return (Integer)this.config.get(MongoConnectorOptions.SCAN_PARTITION_RECORD_SIZE);
    }

    public int getLookupMaxRetries() {
        return (Integer)this.config.get(LookupOptions.MAX_RETRIES);
    }

    public long getLookupRetryIntervalMs() {
        return ((Duration)this.config.get(MongoConnectorOptions.LOOKUP_RETRY_INTERVAL)).toMillis();
    }

    public FilterHandlingPolicy getFilterHandlingPolicy() {
        return (FilterHandlingPolicy)((Object)this.config.get(MongoConnectorOptions.FILTER_HANDLING_POLICY));
    }

    public int getBufferFlushMaxRows() {
        return (Integer)this.config.get(MongoConnectorOptions.BUFFER_FLUSH_MAX_ROWS);
    }

    public long getBufferFlushIntervalMs() {
        return ((Duration)this.config.get(MongoConnectorOptions.BUFFER_FLUSH_INTERVAL)).toMillis();
    }

    public int getSinkMaxRetries() {
        return (Integer)this.config.get(MongoConnectorOptions.SINK_MAX_RETRIES);
    }

    public long getSinkRetryIntervalMs() {
        return ((Duration)this.config.get(MongoConnectorOptions.SINK_RETRY_INTERVAL)).toMillis();
    }

    public DeliveryGuarantee getDeliveryGuarantee() {
        return (DeliveryGuarantee)this.config.get(MongoConnectorOptions.DELIVERY_GUARANTEE);
    }

    @Nullable
    public Integer getSinkParallelism() {
        return this.config.getOptional(FactoryUtil.SINK_PARALLELISM).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoConfiguration that = (MongoConfiguration)o;
        return Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.config);
    }
}

