/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.table;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.mongodb.common.utils.MongoValidationUtils;
import org.apache.flink.connector.mongodb.table.converter.RowDataToBsonConverters;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.ProjectedRowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableFunction;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.types.ObjectId;

@Internal
public class MongoPrimaryKeyExtractor
implements SerializableFunction<RowData, BsonValue> {
    private static final long serialVersionUID = 1L;
    public static final String RESERVED_ID = "_id";
    private static final AppendOnlyPrimaryKeyExtractor APPEND_ONLY_KEY_EXTRACTOR = new AppendOnlyPrimaryKeyExtractor();
    private final int[] primaryKeyIndexes;
    private final SerializableFunction<Object, BsonValue> primaryKeyConverter;
    private final RowData.FieldGetter primaryKeyGetter;

    private MongoPrimaryKeyExtractor(LogicalType primaryKeyType, int[] primaryKeyIndexes) {
        this.primaryKeyIndexes = primaryKeyIndexes;
        this.primaryKeyConverter = RowDataToBsonConverters.createFieldDataConverter(primaryKeyType);
        this.primaryKeyGetter = MongoPrimaryKeyExtractor.isCompoundPrimaryKey(primaryKeyIndexes) ? rowData -> ProjectedRowData.from((int[])primaryKeyIndexes).replaceRow(rowData) : RowData.createFieldGetter((LogicalType)primaryKeyType, (int)primaryKeyIndexes[0]);
    }

    public BsonValue apply(RowData rowData) {
        String keyString;
        Object rowKeyValue = this.primaryKeyGetter.getFieldOrNull(rowData);
        Preconditions.checkNotNull((Object)rowKeyValue, (String)("Primary key value is null of RowData: " + rowData));
        BsonValue keyValue = (BsonValue)this.primaryKeyConverter.apply(rowKeyValue);
        if (!MongoPrimaryKeyExtractor.isCompoundPrimaryKey(this.primaryKeyIndexes) && keyValue.isString() && ObjectId.isValid((String)(keyString = keyValue.asString().getValue()))) {
            keyValue = new BsonObjectId(new ObjectId(keyString));
        }
        return keyValue;
    }

    public static SerializableFunction<RowData, BsonValue> createPrimaryKeyExtractor(ResolvedSchema resolvedSchema) {
        DataType primaryKeyType;
        Optional primaryKey = resolvedSchema.getPrimaryKey();
        int[] primaryKeyIndexes = resolvedSchema.getPrimaryKeyIndexes();
        Optional reservedId = resolvedSchema.getColumn(RESERVED_ID);
        if (!primaryKey.isPresent() && !reservedId.isPresent()) {
            return APPEND_ONLY_KEY_EXTRACTOR;
        }
        if (reservedId.isPresent() && (!primaryKey.isPresent() || MongoPrimaryKeyExtractor.isCompoundPrimaryKey(primaryKeyIndexes) || !MongoPrimaryKeyExtractor.primaryKeyContainsReservedId((UniqueConstraint)primaryKey.get()))) {
            throw new IllegalArgumentException("Ambiguous keys being used due to the presence of an _id field. Either use the _id column as the key, or rename the _id column.");
        }
        if (MongoPrimaryKeyExtractor.isCompoundPrimaryKey(primaryKeyIndexes)) {
            DataType physicalRowDataType = resolvedSchema.toPhysicalRowDataType();
            primaryKeyType = Projection.of((int[])primaryKeyIndexes).project(physicalRowDataType);
        } else {
            int primaryKeyIndex = primaryKeyIndexes[0];
            Optional column = resolvedSchema.getColumn(primaryKeyIndex);
            if (!column.isPresent()) {
                throw new IllegalStateException(String.format("No primary key column found with index '%s'.", primaryKeyIndex));
            }
            primaryKeyType = ((Column)column.get()).getDataType();
        }
        MongoValidationUtils.validatePrimaryKey(primaryKeyType);
        return new MongoPrimaryKeyExtractor(primaryKeyType.getLogicalType(), primaryKeyIndexes);
    }

    private static boolean isCompoundPrimaryKey(int[] primaryKeyIndexes) {
        return primaryKeyIndexes.length > 1;
    }

    private static boolean primaryKeyContainsReservedId(UniqueConstraint primaryKey) {
        return primaryKey.getColumns().contains(RESERVED_ID);
    }

    private static class AppendOnlyPrimaryKeyExtractor
    implements SerializableFunction<RowData, BsonValue> {
        private static final long serialVersionUID = 1L;

        private AppendOnlyPrimaryKeyExtractor() {
        }

        public BsonValue apply(RowData rowData) {
            return null;
        }
    }
}

