/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.table;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.mongodb.common.config.MongoConnectionOptions;
import org.apache.flink.connector.mongodb.sink.MongoSink;
import org.apache.flink.connector.mongodb.sink.config.MongoWriteOptions;
import org.apache.flink.connector.mongodb.table.MongoPrimaryKeyExtractor;
import org.apache.flink.connector.mongodb.table.MongoShardKeysExtractor;
import org.apache.flink.connector.mongodb.table.converter.RowDataToBsonConverters;
import org.apache.flink.connector.mongodb.table.serialization.MongoRowDataSerializationSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.connector.sink.abilities.SupportsOverwrite;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableFunction;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MongoDynamicTableSink
implements DynamicTableSink,
SupportsPartitioning,
SupportsOverwrite {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDynamicTableSink.class);
    private final MongoConnectionOptions connectionOptions;
    private final MongoWriteOptions writeOptions;
    @Nullable
    private final Integer parallelism;
    private final boolean supportUpsert;
    private final ResolvedSchema resolvedSchema;
    private final String[] partitionKeys;
    private final SerializableFunction<RowData, BsonValue> primaryKeyExtractor;
    private final SerializableFunction<RowData, BsonDocument> shardKeysExtractor;

    public MongoDynamicTableSink(MongoConnectionOptions connectionOptions, MongoWriteOptions writeOptions, @Nullable Integer parallelism, ResolvedSchema resolvedSchema, String[] partitionKeys) {
        this.connectionOptions = (MongoConnectionOptions)Preconditions.checkNotNull((Object)connectionOptions);
        this.writeOptions = (MongoWriteOptions)Preconditions.checkNotNull((Object)writeOptions);
        this.parallelism = parallelism;
        this.resolvedSchema = (ResolvedSchema)Preconditions.checkNotNull((Object)resolvedSchema);
        this.partitionKeys = (String[])Preconditions.checkNotNull((Object)partitionKeys);
        this.supportUpsert = resolvedSchema.getPrimaryKey().isPresent();
        this.primaryKeyExtractor = MongoPrimaryKeyExtractor.createPrimaryKeyExtractor(resolvedSchema);
        this.shardKeysExtractor = MongoShardKeysExtractor.createShardKeysExtractor(resolvedSchema, partitionKeys);
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        if (this.supportUpsert) {
            return ChangelogMode.upsert();
        }
        return ChangelogMode.insertOnly();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        RowDataToBsonConverters.RowDataToBsonConverter rowDataToBsonConverter = RowDataToBsonConverters.createConverter((RowType)this.resolvedSchema.toPhysicalRowDataType().getLogicalType());
        MongoRowDataSerializationSchema serializationSchema = new MongoRowDataSerializationSchema(rowDataToBsonConverter, (Function<RowData, BsonValue>)this.primaryKeyExtractor, (Function<RowData, BsonDocument>)this.shardKeysExtractor);
        MongoSink<RowData> mongoSink = MongoSink.builder().setUri(this.connectionOptions.getUri()).setDatabase(this.connectionOptions.getDatabase()).setCollection(this.connectionOptions.getCollection()).setBatchSize(this.writeOptions.getBatchSize()).setBatchIntervalMs(this.writeOptions.getBatchIntervalMs()).setDeliveryGuarantee(this.writeOptions.getDeliveryGuarantee()).setMaxRetries(this.writeOptions.getMaxRetries()).setSerializationSchema(serializationSchema).build();
        return SinkV2Provider.of(mongoSink, (Integer)this.parallelism);
    }

    public void applyStaticPartition(Map<String, String> partition) {
        LOG.info("Applied static partition: {}", partition);
    }

    public void applyOverwrite(boolean overwrite) {
        if (overwrite && !this.supportUpsert) {
            throw new IllegalStateException("Overwrite sink requires specifying the table's primary key");
        }
    }

    public MongoDynamicTableSink copy() {
        return new MongoDynamicTableSink(this.connectionOptions, this.writeOptions, this.parallelism, this.resolvedSchema, this.partitionKeys);
    }

    public String asSummaryString() {
        return "MongoDB";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoDynamicTableSink that = (MongoDynamicTableSink)o;
        return Objects.equals(this.connectionOptions, that.connectionOptions) && Objects.equals(this.writeOptions, that.writeOptions) && Objects.equals(this.parallelism, that.parallelism) && Objects.equals(this.supportUpsert, that.supportUpsert) && Objects.equals(this.resolvedSchema, that.resolvedSchema) && Arrays.equals(this.partitionKeys, that.partitionKeys);
    }

    public int hashCode() {
        return 31 * Objects.hash(this.connectionOptions, this.writeOptions, this.parallelism, this.supportUpsert, this.resolvedSchema) + Arrays.hashCode(this.partitionKeys);
    }
}

