/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.enumerator.splitter;

import com.mongodb.MongoNamespace;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.mongodb.common.utils.MongoConstants;
import org.apache.flink.connector.mongodb.source.config.MongoReadOptions;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoSingleSplitter;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoSplitContext;
import org.apache.flink.connector.mongodb.source.split.MongoScanSourceSplit;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MongoPaginationSplitter {
    private static final Logger LOG = LoggerFactory.getLogger(MongoPaginationSplitter.class);

    public static Collection<MongoScanSourceSplit> split(MongoSplitContext splitContext) {
        MongoReadOptions readOptions = splitContext.getReadOptions();
        MongoNamespace namespace = splitContext.getMongoNamespace();
        Integer partitionRecordSize = readOptions.getPartitionRecordSize();
        if (partitionRecordSize == null) {
            long avgObjSizeInBytes = splitContext.getAvgObjSize();
            if (avgObjSizeInBytes == 0L) {
                LOG.info("{} seems to be an empty collection, Returning a single partition.", (Object)namespace);
                return MongoSingleSplitter.split(splitContext);
            }
            partitionRecordSize = Math.toIntExact(readOptions.getPartitionSize().getBytes() / avgObjSizeInBytes);
        }
        long totalNumOfDocuments = splitContext.getCount();
        if ((long)partitionRecordSize.intValue() >= totalNumOfDocuments) {
            LOG.info("Fewer documents ({}) than the number of documents per partition ({}), Returning a single partition.", (Object)totalNumOfDocuments, (Object)partitionRecordSize);
            return MongoSingleSplitter.split(splitContext);
        }
        int numberOfPartitions = (int)Math.ceil((double)totalNumOfDocuments / (double)partitionRecordSize.intValue());
        BsonDocument lastUpperBound = null;
        ArrayList<MongoScanSourceSplit> paginatedSplits = new ArrayList<MongoScanSourceSplit>();
        for (int splitNum = 0; splitNum < numberOfPartitions; ++splitNum) {
            ArrayList<Bson> pipeline = new ArrayList<Bson>();
            pipeline.add(Aggregates.project((Bson)Projections.include((String[])new String[]{"_id"})));
            pipeline.add(Aggregates.project((Bson)Sorts.ascending((String[])new String[]{"_id"})));
            if (lastUpperBound != null) {
                BsonDocument matchFilter = new BsonDocument();
                if (lastUpperBound.containsKey((Object)"_id")) {
                    matchFilter.put("_id", (BsonValue)new BsonDocument("$gte", lastUpperBound.get((Object)"_id")));
                }
                pipeline.add(Aggregates.match((Bson)matchFilter));
            }
            pipeline.add(Aggregates.skip((int)partitionRecordSize));
            pipeline.add(Aggregates.limit((int)1));
            BsonDocument currentUpperBound = (BsonDocument)splitContext.getMongoCollection().aggregate(pipeline).allowDiskUse(Boolean.valueOf(true)).first();
            paginatedSplits.add(new MongoScanSourceSplit(String.format("%s_%d", namespace, splitNum), namespace.getDatabaseName(), namespace.getCollectionName(), lastUpperBound != null ? lastUpperBound : MongoConstants.BSON_MIN_BOUNDARY, currentUpperBound != null ? currentUpperBound : MongoConstants.BSON_MAX_BOUNDARY, MongoConstants.ID_HINT));
            if (currentUpperBound == null) break;
            lastUpperBound = currentUpperBound;
        }
        return paginatedSplits;
    }
}

