/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.config;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.PartitionStrategy;
import org.apache.flink.connector.mongodb.table.MongoConnectorOptions;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class MongoReadOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int fetchSize;
    private final boolean noCursorTimeout;
    private final PartitionStrategy partitionStrategy;
    private final MemorySize partitionSize;
    private final int samplesPerPartition;
    @Nullable
    private final Integer partitionRecordSize;

    private MongoReadOptions(int fetchSize, boolean noCursorTimeout, PartitionStrategy partitionStrategy, MemorySize partitionSize, int samplesPerPartition, @Nullable Integer partitionRecordSize) {
        this.fetchSize = fetchSize;
        this.noCursorTimeout = noCursorTimeout;
        this.partitionStrategy = partitionStrategy;
        this.partitionSize = partitionSize;
        this.samplesPerPartition = samplesPerPartition;
        this.partitionRecordSize = partitionRecordSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public PartitionStrategy getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public MemorySize getPartitionSize() {
        return this.partitionSize;
    }

    public int getSamplesPerPartition() {
        return this.samplesPerPartition;
    }

    @Nullable
    public Integer getPartitionRecordSize() {
        return this.partitionRecordSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoReadOptions that = (MongoReadOptions)o;
        return this.noCursorTimeout == that.noCursorTimeout && this.partitionStrategy == that.partitionStrategy && this.samplesPerPartition == that.samplesPerPartition && Objects.equals(this.partitionSize, that.partitionSize) && Objects.equals(this.partitionRecordSize, that.partitionRecordSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.noCursorTimeout, this.partitionStrategy, this.partitionSize, this.samplesPerPartition, this.partitionRecordSize});
    }

    public static MongoReadOptionsBuilder builder() {
        return new MongoReadOptionsBuilder();
    }

    @PublicEvolving
    public static class MongoReadOptionsBuilder {
        private int fetchSize = (Integer)MongoConnectorOptions.SCAN_FETCH_SIZE.defaultValue();
        private boolean noCursorTimeout = (Boolean)MongoConnectorOptions.SCAN_CURSOR_NO_TIMEOUT.defaultValue();
        private PartitionStrategy partitionStrategy = (PartitionStrategy)((Object)MongoConnectorOptions.SCAN_PARTITION_STRATEGY.defaultValue());
        private MemorySize partitionSize = (MemorySize)MongoConnectorOptions.SCAN_PARTITION_SIZE.defaultValue();
        private int samplesPerPartition = (Integer)MongoConnectorOptions.SCAN_PARTITION_SAMPLES.defaultValue();
        @Nullable
        private Integer partitionRecordSize = null;

        private MongoReadOptionsBuilder() {
        }

        public MongoReadOptionsBuilder setFetchSize(int fetchSize) {
            Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (Object)"The fetch size must be larger than 0.");
            this.fetchSize = fetchSize;
            return this;
        }

        public MongoReadOptionsBuilder setNoCursorTimeout(boolean noCursorTimeout) {
            this.noCursorTimeout = noCursorTimeout;
            return this;
        }

        public MongoReadOptionsBuilder setPartitionStrategy(PartitionStrategy partitionStrategy) {
            Preconditions.checkNotNull((Object)((Object)partitionStrategy), (String)"The partition strategy must not be null.");
            this.partitionStrategy = partitionStrategy;
            return this;
        }

        public MongoReadOptionsBuilder setPartitionSize(MemorySize partitionSize) {
            Preconditions.checkNotNull((Object)partitionSize, (String)"The partition size must not be null");
            Preconditions.checkArgument((partitionSize.getMebiBytes() >= 1 ? 1 : 0) != 0, (Object)"The partition size must be larger than or equal to 1mb.");
            this.partitionSize = partitionSize;
            return this;
        }

        public MongoReadOptionsBuilder setSamplesPerPartition(int samplesPerPartition) {
            Preconditions.checkArgument((samplesPerPartition > 0 ? 1 : 0) != 0, (Object)"The samples per partition must be larger than 0.");
            this.samplesPerPartition = samplesPerPartition;
            return this;
        }

        public MongoReadOptionsBuilder setPartitionRecordSize(@Nullable Integer partitionRecordSize) {
            Preconditions.checkArgument((partitionRecordSize == null || partitionRecordSize > 0 ? 1 : 0) != 0, (Object)"The record size per partition must be larger than 0.");
            this.partitionRecordSize = partitionRecordSize;
            return this;
        }

        public MongoReadOptions build() {
            return new MongoReadOptions(this.fetchSize, this.noCursorTimeout, this.partitionStrategy, this.partitionSize, this.samplesPerPartition, this.partitionRecordSize);
        }
    }
}

