/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.sink.config;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.mongodb.table.MongoConnectorOptions;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class MongoWriteOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int batchSize;
    private final long batchIntervalMs;
    private final int maxRetries;
    private final long retryIntervalMs;
    private final DeliveryGuarantee deliveryGuarantee;

    private MongoWriteOptions(int batchSize, long batchIntervalMs, int maxRetries, long retryIntervalMs, DeliveryGuarantee deliveryGuarantee) {
        this.batchSize = batchSize;
        this.batchIntervalMs = batchIntervalMs;
        this.maxRetries = maxRetries;
        this.retryIntervalMs = retryIntervalMs;
        this.deliveryGuarantee = deliveryGuarantee;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getBatchIntervalMs() {
        return this.batchIntervalMs;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getRetryIntervalMs() {
        return this.retryIntervalMs;
    }

    public DeliveryGuarantee getDeliveryGuarantee() {
        return this.deliveryGuarantee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoWriteOptions that = (MongoWriteOptions)o;
        return this.batchSize == that.batchSize && this.batchIntervalMs == that.batchIntervalMs && this.maxRetries == that.maxRetries && this.retryIntervalMs == that.retryIntervalMs && this.deliveryGuarantee == that.deliveryGuarantee;
    }

    public int hashCode() {
        return Objects.hash(this.batchSize, this.batchIntervalMs, this.maxRetries, this.retryIntervalMs, this.deliveryGuarantee);
    }

    public static MongoWriteOptionsBuilder builder() {
        return new MongoWriteOptionsBuilder();
    }

    @PublicEvolving
    public static class MongoWriteOptionsBuilder {
        private int batchSize = (Integer)MongoConnectorOptions.BUFFER_FLUSH_MAX_ROWS.defaultValue();
        private long batchIntervalMs = ((Duration)MongoConnectorOptions.BUFFER_FLUSH_INTERVAL.defaultValue()).toMillis();
        private int maxRetries = (Integer)MongoConnectorOptions.SINK_MAX_RETRIES.defaultValue();
        private long retryIntervalMs = ((Duration)MongoConnectorOptions.SINK_RETRY_INTERVAL.defaultValue()).toMillis();
        private DeliveryGuarantee deliveryGuarantee = (DeliveryGuarantee)MongoConnectorOptions.DELIVERY_GUARANTEE.defaultValue();

        private MongoWriteOptionsBuilder() {
        }

        public MongoWriteOptionsBuilder setBatchSize(int batchSize) {
            Preconditions.checkArgument((batchSize == -1 || batchSize > 0 ? 1 : 0) != 0, (Object)"Max number of batch size must be larger than 0.");
            this.batchSize = batchSize;
            return this;
        }

        public MongoWriteOptionsBuilder setBatchIntervalMs(long batchIntervalMs) {
            Preconditions.checkArgument((batchIntervalMs == -1L || batchIntervalMs >= 0L ? 1 : 0) != 0, (Object)"The batch flush interval (in milliseconds) between each flush must be larger than or equal to 0.");
            this.batchIntervalMs = batchIntervalMs;
            return this;
        }

        public MongoWriteOptionsBuilder setMaxRetries(int maxRetries) {
            Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)"The sink max retry times must be larger than or equal to 0.");
            this.maxRetries = maxRetries;
            return this;
        }

        public MongoWriteOptionsBuilder setRetryIntervalMs(long retryIntervalMs) {
            Preconditions.checkArgument((retryIntervalMs > 0L ? 1 : 0) != 0, (Object)"The retry interval (in milliseconds) must be larger than 0.");
            this.retryIntervalMs = retryIntervalMs;
            return this;
        }

        public MongoWriteOptionsBuilder setDeliveryGuarantee(DeliveryGuarantee deliveryGuarantee) {
            Preconditions.checkArgument((deliveryGuarantee != DeliveryGuarantee.EXACTLY_ONCE ? 1 : 0) != 0, (Object)"Mongo sink does not support the EXACTLY_ONCE guarantee.");
            this.deliveryGuarantee = (DeliveryGuarantee)Preconditions.checkNotNull((Object)deliveryGuarantee);
            return this;
        }

        public MongoWriteOptions build() {
            return new MongoWriteOptions(this.batchSize, this.batchIntervalMs, this.maxRetries, this.retryIntervalMs, this.deliveryGuarantee);
        }
    }
}

