/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.common.config;

import com.mongodb.ConnectionString;
import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class MongoConnectionOptions
implements Serializable {
    private final String uri;
    private final String database;
    private final String collection;

    private MongoConnectionOptions(String uri, String database, String collection) {
        this.uri = (String)Preconditions.checkNotNull((Object)uri);
        this.database = (String)Preconditions.checkNotNull((Object)database);
        this.collection = (String)Preconditions.checkNotNull((Object)collection);
    }

    public String getUri() {
        return this.uri;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoConnectionOptions that = (MongoConnectionOptions)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.database, that.database) && Objects.equals(this.collection, that.collection);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.database, this.collection);
    }

    public static MongoConnectionOptionsBuilder builder() {
        return new MongoConnectionOptionsBuilder();
    }

    @PublicEvolving
    public static class MongoConnectionOptionsBuilder {
        private String uri;
        private String database;
        private String collection;

        private MongoConnectionOptionsBuilder() {
        }

        public MongoConnectionOptionsBuilder setUri(String uri) {
            this.uri = new ConnectionString(uri).getConnectionString();
            return this;
        }

        public MongoConnectionOptionsBuilder setDatabase(String database) {
            this.database = (String)Preconditions.checkNotNull((Object)database, (String)"The database of MongoDB must not be null");
            return this;
        }

        public MongoConnectionOptionsBuilder setCollection(String collection) {
            this.collection = (String)Preconditions.checkNotNull((Object)collection, (String)"The collection of MongoDB must not be null");
            return this;
        }

        public MongoConnectionOptions build() {
            return new MongoConnectionOptions(this.uri, this.database, this.collection);
        }
    }
}

