/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.avro.typeutils.AvroConversions;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class AvroRowSerializationSchema
implements SerializationSchema<Row> {
    private Class<? extends SpecificRecord> recordClazz;
    private String schemaString;
    private transient Schema schema;
    private transient DatumWriter<IndexedRecord> datumWriter;
    private transient ByteArrayOutputStream arrayOutputStream;
    private transient Encoder encoder;

    public AvroRowSerializationSchema(Class<? extends SpecificRecord> recordClazz) {
        Preconditions.checkNotNull(recordClazz, (String)"Avro record class must not be null.");
        this.recordClazz = recordClazz;
        this.schema = SpecificData.get().getSchema(recordClazz);
        this.schemaString = this.schema.toString();
        this.datumWriter = new SpecificDatumWriter(this.schema);
        this.arrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder((OutputStream)this.arrayOutputStream, null);
    }

    public AvroRowSerializationSchema(String avroSchemaString) {
        Preconditions.checkNotNull((Object)avroSchemaString, (String)"Avro schema must not be null.");
        this.recordClazz = null;
        this.schemaString = avroSchemaString;
        try {
            this.schema = new Schema.Parser().parse(avroSchemaString);
        }
        catch (SchemaParseException e) {
            throw new IllegalArgumentException("Could not parse Avro schema string.", e);
        }
        this.datumWriter = new GenericDatumWriter(this.schema);
        this.arrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder((OutputStream)this.arrayOutputStream, null);
    }

    public byte[] serialize(Row row) {
        try {
            GenericRecord record = AvroConversions.convertRowToAvroRecord(this.schema, row);
            this.arrayOutputStream.reset();
            this.datumWriter.write((Object)record, this.encoder);
            this.encoder.flush();
            return this.arrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize row.", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroRowSerializationSchema that = (AvroRowSerializationSchema)o;
        return Objects.equals(this.recordClazz, that.recordClazz) && Objects.equals(this.schemaString, that.schemaString);
    }

    public int hashCode() {
        return Objects.hash(this.recordClazz, this.schemaString);
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.writeObject(this.recordClazz);
        outputStream.writeObject(this.schemaString);
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        this.recordClazz = (Class)inputStream.readObject();
        this.schemaString = (String)inputStream.readObject();
        this.schema = this.recordClazz != null ? SpecificData.get().getSchema(this.recordClazz) : new Schema.Parser().parse(this.schemaString);
        this.datumWriter = new SpecificDatumWriter(this.schema);
        this.arrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder((OutputStream)this.arrayOutputStream, null);
    }
}

