/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.avro.AvroFileFormatFactory;
import org.apache.flink.formats.avro.AvroInputFormat;
import org.apache.flink.formats.avro.AvroToRowDataConverters;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.FileSystemFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.PartitionPathUtils;

public class AvroFileSystemFormatFactory
implements FileSystemFormatFactory {
    public static final String IDENTIFIER = "avro";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(AvroFileFormatFactory.AVRO_OUTPUT_CODEC);
        return options;
    }

    public InputFormat<RowData, ?> createReader(FileSystemFormatFactory.ReaderContext context) {
        String[] fieldNames = context.getSchema().getFieldNames();
        List projectFields = Arrays.stream(context.getProjectFields()).mapToObj(idx -> fieldNames[idx]).collect(Collectors.toList());
        List csvFields = Arrays.stream(fieldNames).filter(field -> !context.getPartitionKeys().contains(field)).collect(Collectors.toList());
        int[] selectFieldToProjectField = context.getFormatProjectFields().stream().mapToInt(projectFields::indexOf).toArray();
        int[] selectFieldToFormatField = context.getFormatProjectFields().stream().mapToInt(csvFields::indexOf).toArray();
        return new RowDataAvroInputFormat(context.getPaths(), context.getFormatRowType(), context.getSchema().getFieldDataTypes(), context.getSchema().getFieldNames(), context.getProjectFields(), context.getPartitionKeys(), context.getDefaultPartName(), context.getPushedDownLimit(), selectFieldToProjectField, selectFieldToFormatField);
    }

    private static class RowDataAvroInputFormat
    extends AvroInputFormat {
        private static final long serialVersionUID = 1L;
        private final DataType[] fieldTypes;
        private final String[] fieldNames;
        private final int[] selectFields;
        private final List<String> partitionKeys;
        private final String defaultPartValue;
        private final long limit;
        private final int[] selectFieldToProjectField;
        private final int[] selectFieldToFormatField;
        private final RowType formatRowType;
        private transient long emitted;
        private transient GenericRowData rowData;
        private transient IndexedRecord record;
        private transient AvroToRowDataConverters.AvroToRowDataConverter converter;

        public RowDataAvroInputFormat(Path[] filePaths, RowType formatRowType, DataType[] fieldTypes, String[] fieldNames, int[] selectFields, List<String> partitionKeys, String defaultPartValue, long limit, int[] selectFieldToProjectField, int[] selectFieldToFormatField) {
            super(filePaths[0], GenericRecord.class);
            super.setFilePaths(filePaths);
            this.formatRowType = formatRowType;
            this.fieldTypes = fieldTypes;
            this.fieldNames = fieldNames;
            this.partitionKeys = partitionKeys;
            this.defaultPartValue = defaultPartValue;
            this.selectFields = selectFields;
            this.limit = limit;
            this.emitted = 0L;
            this.selectFieldToProjectField = selectFieldToProjectField;
            this.selectFieldToFormatField = selectFieldToFormatField;
        }

        @Override
        public void open(FileInputSplit split) throws IOException {
            super.open(split);
            Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)this.formatRowType);
            this.record = new GenericData.Record(schema);
            this.rowData = PartitionPathUtils.fillPartitionValueForRecord((String[])this.fieldNames, (DataType[])this.fieldTypes, (int[])this.selectFields, this.partitionKeys, (Path)this.currentSplit.getPath(), (String)this.defaultPartValue);
            this.converter = AvroToRowDataConverters.createRowConverter(this.formatRowType);
        }

        @Override
        public boolean reachedEnd() throws IOException {
            return this.emitted >= this.limit || super.reachedEnd();
        }

        public Object nextRecord(Object reuse) throws IOException {
            IndexedRecord r = super.nextRecord(this.record);
            if (r == null) {
                return null;
            }
            GenericRowData row = (GenericRowData)this.converter.convert(r);
            for (int i = 0; i < this.selectFieldToFormatField.length; ++i) {
                this.rowData.setField(this.selectFieldToProjectField[i], row.getField(this.selectFieldToFormatField[i]));
            }
            ++this.emitted;
            return this.rowData;
        }
    }
}

