/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.formats.avro.AvroBuilder;
import org.apache.flink.formats.avro.AvroWriterFactory;
import org.apache.flink.formats.avro.RowDataToAvroConverters;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.BulkWriterFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class AvroFileFormatFactory
implements BulkWriterFormatFactory {
    public static final String IDENTIFIER = "avro";
    public static final ConfigOption<String> AVRO_OUTPUT_CODEC = ConfigOptions.key((String)"codec").stringType().noDefaultValue().withDescription("The compression codec for avro");

    public EncodingFormat<BulkWriter.Factory<RowData>> createEncodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        return new EncodingFormat<BulkWriter.Factory<RowData>>(){

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }

            public BulkWriter.Factory<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                return new RowDataAvroWriterFactory((RowType)consumedDataType.getLogicalType(), (String)formatOptions.get(AVRO_OUTPUT_CODEC));
            }
        };
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(AVRO_OUTPUT_CODEC);
        return options;
    }

    private static class RowDataAvroWriterFactory
    implements BulkWriter.Factory<RowData> {
        private static final long serialVersionUID = 1L;
        private final AvroWriterFactory<GenericRecord> factory;
        private final RowType rowType;

        private RowDataAvroWriterFactory(final RowType rowType, final String codec) {
            this.rowType = rowType;
            this.factory = new AvroWriterFactory<GenericRecord>(new AvroBuilder<GenericRecord>(){

                @Override
                public DataFileWriter<GenericRecord> createWriter(OutputStream out) throws IOException {
                    Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)rowType);
                    GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
                    DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
                    if (codec != null) {
                        dataFileWriter.setCodec(CodecFactory.fromString((String)codec));
                    }
                    dataFileWriter.create(schema, out);
                    return dataFileWriter;
                }
            });
        }

        public BulkWriter<RowData> create(FSDataOutputStream out) throws IOException {
            final BulkWriter<GenericRecord> writer = this.factory.create(out);
            final RowDataToAvroConverters.RowDataToAvroConverter converter = RowDataToAvroConverters.createConverter((LogicalType)this.rowType);
            final Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)this.rowType);
            return new BulkWriter<RowData>(){

                public void addElement(RowData element) throws IOException {
                    GenericRecord record = (GenericRecord)converter.convert(schema, element);
                    writer.addElement((Object)record);
                }

                public void flush() throws IOException {
                    writer.flush();
                }

                public void finish() throws IOException {
                    writer.finish();
                }
            };
        }
    }
}

